/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.AbstractInternationalString;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;

@Immutable
public class ResourceInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 6339944890723487336L;
    private final String resources;
    private final String key;
    private final ClassLoader loader;

    public ResourceInternationalString(String string, String string2) {
        this(string, string2, null);
    }

    public ResourceInternationalString(String string, String string2, ClassLoader classLoader) {
        this.resources = string;
        this.key = string2;
        this.loader = classLoader;
        ArgumentChecks.ensureNonNull("resources", string);
        ArgumentChecks.ensureNonNull("key", string2);
    }

    @Override
    public String toString(Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return this.getBundle(locale).getString(this.key);
    }

    protected ResourceBundle getBundle(Locale locale) {
        return this.loader == null ? ResourceBundle.getBundle(this.resources, locale) : ResourceBundle.getBundle(this.resources, locale, this.loader);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ResourceInternationalString resourceInternationalString = (ResourceInternationalString)object;
            return Utilities.equals(this.key, resourceInternationalString.key) && Utilities.equals(this.resources, resourceInternationalString.resources);
        }
        return false;
    }

    public int hashCode() {
        return 0xA3204E68 ^ this.key.hashCode() ^ this.resources.hashCode();
    }
}

