/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.VerticalDatumTypes;
import org.geotoolkit.lang.Static;
import org.geotoolkit.math.XMath;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.AxisRangeType;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.TransformException;

public final class CRSUtilities
extends Static {
    public static final String EPSG_VERSION = "7.09";
    public static final String PARAMETERS_KEY = "parameters";
    public static final int AXIS_RANGE_COUNT = 2;
    public static final int AXIS_RANGE_RECIPROCAL_MASK = 1;

    private CRSUtilities() {
    }

    public static double getAuthalicRadius(double d, double d2) {
        if (d == d2) {
            return d;
        }
        double d3 = 1.0 - d2 / d;
        double d4 = Math.sqrt(2.0 * d3 - d3 * d3);
        return Math.sqrt(0.5 * (d * d + d2 * d2 * XMath.atanh((double)d4) / d4));
    }

    public static int dimensionColinearWith(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        int n;
        int n2 = AxisDirections.indexOf(coordinateSystem, coordinateSystem2.getAxis(0).getDirection());
        if (n2 >= 0 && n2 + (n = coordinateSystem2.getDimension()) <= coordinateSystem.getDimension()) {
            while (--n > 0) {
                if (AxisDirections.absolute(coordinateSystem2.getAxis(n).getDirection()).equals(AxisDirections.absolute(coordinateSystem.getAxis(n + n2).getDirection()))) continue;
                return -1;
            }
            return n2;
        }
        return -1;
    }

    public static Unit<?> getUnit(CoordinateSystem coordinateSystem) {
        Unit<?> unit = null;
        int n = coordinateSystem.getDimension();
        while (--n >= 0) {
            Unit<?> unit2 = coordinateSystem.getAxis(n).getUnit();
            if (unit2 == null) continue;
            if (unit == null) {
                unit = unit2;
                continue;
            }
            if (unit.equals(unit2)) continue;
            return null;
        }
        return unit;
    }

    public static int getDimensionOf(CoordinateReferenceSystem coordinateReferenceSystem, Class<? extends CoordinateReferenceSystem> clazz) throws IllegalArgumentException {
        if (clazz.isAssignableFrom(coordinateReferenceSystem.getClass())) {
            return 0;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            int n = 0;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                int n2 = CRSUtilities.getDimensionOf(coordinateReferenceSystem2, clazz);
                if (n2 >= 0) {
                    return n2 + n;
                }
                n += coordinateReferenceSystem2.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (coordinateReferenceSystem != null) {
            while (coordinateReferenceSystem.getCoordinateSystem().getDimension() != 2) {
                if (coordinateReferenceSystem instanceof CompoundCRS) {
                    coordinateReferenceSystem = ((CompoundCRS)coordinateReferenceSystem).getComponents().get(0);
                    continue;
                }
                if ((coordinateReferenceSystem = CRS.getHorizontalCRS(coordinateReferenceSystem)) != null) continue;
                throw new TransformException(Errors.format((int)36, (Object)coordinateReferenceSystem.getName()));
            }
        }
        return coordinateReferenceSystem;
    }

    public static Map<String, ?> changeDimensionInName(IdentifiedObject identifiedObject, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(identifiedObject.getName().getCode());
        int n = stringBuilder.length() - string.length();
        boolean bl = true;
        int n2 = stringBuilder.lastIndexOf(string);
        while (n2 >= 0) {
            if (!(n2 != 0 && Character.isLetterOrDigit(stringBuilder.charAt(n2 - 1)) || n2 != n && Character.isLetterOrDigit(n2 + string.length()))) {
                stringBuilder.replace(n2, n2 + string.length(), string2);
                n2 = stringBuilder.indexOf(". ", n2);
                if (n2 >= 0) {
                    stringBuilder.setLength(n2 + 1);
                }
                bl = false;
                break;
            }
            n2 = stringBuilder.lastIndexOf(string, n2 - 1);
        }
        if (bl) {
            if (stringBuilder.indexOf(" ") >= 0) {
                stringBuilder.append(" (").append(string2).append(')');
            } else {
                stringBuilder.append('_').append(string2);
            }
        }
        return Collections.singletonMap("name", stringBuilder.toString());
    }

    public static Envelope appendMissingDimensions(Envelope envelope, CompoundCRS compoundCRS) {
        ArrayList<CoordinateReferenceSystem> arrayList = new ArrayList<CoordinateReferenceSystem>(4);
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        for (SingleCRS singleCRS : DefaultCompoundCRS.getSingleCRS(compoundCRS)) {
            CoordinateSystem coordinateSystem2 = singleCRS.getCoordinateSystem();
            if (coordinateSystem2.getDimension() != 1 || CRSUtilities.dimensionColinearWith(coordinateSystem, coordinateSystem2) >= 0) continue;
            arrayList.add(singleCRS);
        }
        if (arrayList.isEmpty()) {
            return envelope;
        }
        arrayList.add(0, coordinateReferenceSystem);
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(new DefaultCompoundCRS("Temporarily expanded", arrayList.toArray(new CoordinateReferenceSystem[arrayList.size()])));
        generalEnvelope.setToNull();
        generalEnvelope.setSubEnvelope(envelope, 0);
        return generalEnvelope;
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian == null) {
            return 0.0;
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian) {
        return CRSUtilities.getGreenwichLongitude(primeMeridian, (Unit<Angle>)NonSI.DEGREE_ANGLE);
    }

    public static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        Datum datum;
        if (coordinateReferenceSystem instanceof SingleCRS) {
            datum = ((SingleCRS)coordinateReferenceSystem).getDatum();
        } else {
            datum = null;
            for (SingleCRS singleCRS : DefaultCompoundCRS.getSingleCRS(coordinateReferenceSystem)) {
                Datum datum2 = singleCRS.getDatum();
                if (datum != null && !datum.equals(datum2)) {
                    if (CRSUtilities.isGeodetic3D(datum, datum2)) continue;
                    if (!CRSUtilities.isGeodetic3D(datum2, datum)) {
                        return null;
                    }
                }
                datum = datum2;
            }
        }
        return datum;
    }

    private static boolean isGeodetic3D(Datum datum, Datum datum2) {
        return datum instanceof GeodeticDatum && datum2 instanceof VerticalDatum && VerticalDatumTypes.ELLIPSOIDAL.equals(((VerticalDatum)datum2).getVerticalDatumType());
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (!(coordinateReferenceSystem instanceof GeographicCRS)) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                coordinateReferenceSystem = ((CompoundCRS)coordinateReferenceSystem).getComponents().get(0);
                continue;
            }
            return null;
        }
        return ((GeographicCRS)coordinateReferenceSystem).getDatum().getEllipsoid();
    }

    public static GeographicCRS getStandardGeographicCRS2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
        }
        if (!(coordinateReferenceSystem instanceof SingleCRS)) {
            return DefaultGeographicCRS.WGS84;
        }
        Datum datum = ((SingleCRS)coordinateReferenceSystem).getDatum();
        if (!(datum instanceof GeodeticDatum)) {
            return DefaultGeographicCRS.WGS84;
        }
        GeodeticDatum geodeticDatum = (GeodeticDatum)datum;
        if (geodeticDatum.getPrimeMeridian().getGreenwichLongitude() != 0.0) {
            geodeticDatum = new DefaultGeodeticDatum(geodeticDatum.getName().getCode(), geodeticDatum.getEllipsoid());
        } else if (coordinateReferenceSystem instanceof GeographicCRS && CRS.equalsIgnoreMetadata(DefaultEllipsoidalCS.GEODETIC_2D, coordinateReferenceSystem.getCoordinateSystem())) {
            return (GeographicCRS)coordinateReferenceSystem;
        }
        return new DefaultGeographicCRS(coordinateReferenceSystem.getName().getCode(), geodeticDatum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
    }

    public static Measure getHorizontalResolution(CoordinateReferenceSystem coordinateReferenceSystem, double ... dArray) {
        int n;
        CoordinateSystem coordinateSystem;
        Unit<?> unit;
        SingleCRS singleCRS;
        if (dArray != null && (singleCRS = CRS.getHorizontalCRS(coordinateReferenceSystem)) != null && (unit = CRSUtilities.getUnit(coordinateSystem = singleCRS.getCoordinateSystem())) != null && (n = CRSUtilities.dimensionColinearWith(coordinateReferenceSystem.getCoordinateSystem(), coordinateSystem)) >= 0) {
            int n2 = coordinateSystem.getDimension();
            double d = Double.POSITIVE_INFINITY;
            for (int i = n; i < n2; ++i) {
                double d2 = dArray[i];
                if (!(d2 > 0.0) || !(d2 < d)) continue;
                d = d2;
            }
            if (d != Double.POSITIVE_INFINITY) {
                return new Measure(d, unit);
            }
        }
        return null;
    }

    public static CoordinateReferenceSystem shiftAxisRange(CoordinateReferenceSystem coordinateReferenceSystem, AxisRangeType axisRangeType) {
        DefaultCompoundCRS defaultCompoundCRS;
        DefaultCompoundCRS defaultCompoundCRS2;
        if (coordinateReferenceSystem instanceof GeographicCRS) {
            DefaultGeographicCRS defaultGeographicCRS = DefaultGeographicCRS.castOrCopy((GeographicCRS)coordinateReferenceSystem);
            DefaultGeographicCRS defaultGeographicCRS2 = defaultGeographicCRS.shiftAxisRange(axisRangeType);
            if (defaultGeographicCRS2 != defaultGeographicCRS) {
                return defaultGeographicCRS2;
            }
        } else if (coordinateReferenceSystem instanceof CompoundCRS && (defaultCompoundCRS2 = (defaultCompoundCRS = DefaultCompoundCRS.castOrCopy((CompoundCRS)coordinateReferenceSystem)).shiftAxisRange(axisRangeType)) != defaultCompoundCRS) {
            return defaultCompoundCRS2;
        }
        return coordinateReferenceSystem;
    }

    public static Class<? extends IdentifiedObject> getReferencingGroup(Class<? extends IdentifiedObject> clazz) {
        Class clazz2 = null;
        if (clazz != null) {
            int n = 0;
            block8: while (true) {
                Class clazz3;
                switch (n) {
                    case 0: {
                        clazz3 = CoordinateReferenceSystem.class;
                        break;
                    }
                    case 1: {
                        clazz3 = CoordinateSystem.class;
                        break;
                    }
                    case 2: {
                        clazz3 = CoordinateSystemAxis.class;
                        break;
                    }
                    case 3: {
                        clazz3 = Datum.class;
                        break;
                    }
                    case 4: {
                        clazz3 = Ellipsoid.class;
                        break;
                    }
                    case 5: {
                        clazz3 = PrimeMeridian.class;
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    if (clazz2 != null) {
                        return IdentifiedObject.class;
                    }
                    clazz2 = clazz3;
                }
                ++n;
            }
            if (clazz2 == null) {
                return IdentifiedObject.class;
            }
        }
        return clazz2;
    }
}

