/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.AxisRangeType;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

@Immutable
public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;
    public static final DefaultEllipsoidalCS GEODETIC_2D = new DefaultEllipsoidalCS((Map<String, ?>)DefaultEllipsoidalCS.name(121), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
    public static final DefaultEllipsoidalCS GEODETIC_3D = new DefaultEllipsoidalCS((Map<String, ?>)DefaultEllipsoidalCS.name(122), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    private transient int longitudeAxis;
    private transient int latitudeAxis;
    private transient int heightAxis;
    private transient UnitConverter longitudeConverter;
    private transient UnitConverter latitudeConverter;
    private transient UnitConverter heightConverter;
    private transient DefaultEllipsoidalCS shifted;

    private DefaultEllipsoidalCS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super(ellipsoidalCS);
    }

    public DefaultEllipsoidalCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2);
    }

    public DefaultEllipsoidalCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    private DefaultEllipsoidalCS(EllipsoidalCS ellipsoidalCS, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(IdentifiedObjects.getProperties(ellipsoidalCS, null), coordinateSystemAxisArray);
    }

    public static DefaultEllipsoidalCS castOrCopy(EllipsoidalCS ellipsoidalCS) {
        return ellipsoidalCS == null || ellipsoidalCS instanceof DefaultEllipsoidalCS ? (DefaultEllipsoidalCS)ellipsoidalCS : new DefaultEllipsoidalCS(ellipsoidalCS);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.NORTH.equals(axisDirection = AxisDirections.absolute(axisDirection)) || AxisDirection.EAST.equals(axisDirection) || AxisDirection.UP.equals(axisDirection);
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        if (AxisDirection.UP.equals(axisDirection = AxisDirections.absolute(axisDirection))) {
            return Units.isLinear(unit);
        }
        return Units.isAngular(unit);
    }

    private void updateConverters() {
        int n = this.getDimension();
        while (--n >= 0) {
            CoordinateSystemAxis coordinateSystemAxis = this.getAxis(n);
            AxisDirection axisDirection = AxisDirections.absolute(coordinateSystemAxis.getDirection());
            Unit<?> unit = coordinateSystemAxis.getUnit();
            if (AxisDirection.EAST.equals(axisDirection)) {
                this.longitudeAxis = n;
                this.longitudeConverter = unit.asType(Angle.class).getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.NORTH.equals(axisDirection)) {
                this.latitudeAxis = n;
                this.latitudeConverter = unit.asType(Angle.class).getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.UP.equals(axisDirection)) {
                this.heightAxis = n;
                this.heightConverter = unit.asType(Length.class).getConverterTo((Unit)SI.METRE);
                continue;
            }
            throw new AssertionError(axisDirection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLongitude(double[] dArray) throws MismatchedDimensionException {
        UnitConverter unitConverter;
        this.ensureDimensionMatch("coordinates", dArray);
        DefaultEllipsoidalCS defaultEllipsoidalCS = this;
        synchronized (defaultEllipsoidalCS) {
            unitConverter = this.longitudeConverter;
            if (unitConverter == null) {
                this.updateConverters();
                unitConverter = this.longitudeConverter;
            }
        }
        return unitConverter.convert(dArray[this.longitudeAxis]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLatitude(double[] dArray) throws MismatchedDimensionException {
        UnitConverter unitConverter;
        this.ensureDimensionMatch("coordinates", dArray);
        DefaultEllipsoidalCS defaultEllipsoidalCS = this;
        synchronized (defaultEllipsoidalCS) {
            unitConverter = this.latitudeConverter;
            if (unitConverter == null) {
                this.updateConverters();
                unitConverter = this.latitudeConverter;
            }
        }
        return unitConverter.convert(dArray[this.latitudeAxis]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getHeight(double[] dArray) throws MismatchedDimensionException {
        UnitConverter unitConverter;
        this.ensureDimensionMatch("coordinates", dArray);
        DefaultEllipsoidalCS defaultEllipsoidalCS = this;
        synchronized (defaultEllipsoidalCS) {
            unitConverter = this.heightConverter;
            if (unitConverter == null) {
                this.updateConverters();
                unitConverter = this.heightConverter;
                if (unitConverter == null) {
                    throw new IllegalStateException(Errors.format((int)149));
                }
            }
        }
        return unitConverter.convert(dArray[this.heightAxis]);
    }

    public synchronized DefaultEllipsoidalCS shiftAxisRange(AxisRangeType axisRangeType) {
        boolean bl;
        switch (axisRangeType) {
            case SPANNING_ZERO_LONGITUDE: {
                bl = false;
                break;
            }
            case POSITIVE_LONGITUDE: {
                bl = true;
                break;
            }
            default: {
                return this;
            }
        }
        if (this.longitudeConverter == null) {
            this.updateConverters();
        }
        CoordinateSystemAxis coordinateSystemAxis = this.getAxis(this.longitudeAxis);
        double d = coordinateSystemAxis.getMinimumValue();
        if (bl ? d >= 0.0 : d < 0.0) {
            return this;
        }
        if (this.shifted == null) {
            double d2 = this.longitudeConverter.inverse().convert(180.0);
            double d3 = Math.floor(d / d2 + 1.0E-10);
            if (!bl) {
                d3 -= 1.0;
            }
            Unit<?> unit = coordinateSystemAxis.getUnit();
            if (Double.isNaN(d3 *= d2) || Double.isInfinite(d3)) {
                throw new IllegalStateException(Errors.format((int)227, unit));
            }
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis(IdentifiedObjects.getProperties(coordinateSystemAxis), coordinateSystemAxis.getAbbreviation(), coordinateSystemAxis.getDirection(), unit, d - d3, coordinateSystemAxis.getMaximumValue() - d3, coordinateSystemAxis.getRangeMeaning());
            if (defaultCoordinateSystemAxis.equals(coordinateSystemAxis, ComparisonMode.BY_CONTRACT)) {
                this.shifted = this;
            } else {
                CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[this.getDimension()];
                int n = coordinateSystemAxisArray.length;
                while (--n >= 0) {
                    coordinateSystemAxisArray[n] = n != this.longitudeAxis ? this.getAxis(n) : defaultCoordinateSystemAxis;
                }
                this.shifted = new DefaultEllipsoidalCS(this, coordinateSystemAxisArray);
                this.shifted.shifted = this;
            }
        }
        return this.shifted;
    }

    public DefaultEllipsoidalCS usingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] coordinateSystemAxisArray;
        try {
            coordinateSystemAxisArray = this.axisUsingUnit(unit, (Unit<?>)(Units.isLinear(unit) ? SI.RADIAN : SI.METRE));
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((int)92, unit), conversionException);
        }
        if (coordinateSystemAxisArray == null) {
            return this;
        }
        return new DefaultEllipsoidalCS(this, coordinateSystemAxisArray);
    }
}

