/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.CassiniOrMercator;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class TransverseMercator
extends CassiniOrMercator {
    private static final long serialVersionUID = -4717976245811852528L;
    private final double esp;
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        Parameters parameters = new Parameters(parameterDescriptorGroup, parameterValueGroup);
        TransverseMercator transverseMercator = parameters.isSpherical() ? new Spherical(parameters) : new TransverseMercator(parameters);
        return transverseMercator.createConcatenatedTransform();
    }

    protected TransverseMercator(Parameters parameters) {
        super(parameters);
        this.esp = this.excentricitySquared / (1.0 - this.excentricitySquared);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2 = this.rollLongitude(dArray[n]);
        double d3 = dArray[n + 1];
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        double d6 = d4 / d5;
        double d7 = d4 * d4;
        double d8 = d5 * d5;
        double d9 = d2 * d5;
        double d10 = d9 * d9;
        double d11 = Math.abs(d5) > 1.0E-6 ? d6 * d6 : 0.0;
        double d12 = this.esp * d8;
        double d13 = Math.sqrt(1.0 - this.excentricitySquared * d7);
        if (dArray2 != null) {
            d = d9 / d13;
            dArray2[n2] = d * (1.0 + 0.16666666666666666 * d10 * (1.0 - d11 + d12 + 0.05 * d10 * (5.0 + d11 * (d11 - 18.0) + d12 * (14.0 - 58.0 * d11) + 0.023809523809523808 * d10 * (61.0 + d11 * (d11 * (179.0 - d11) - 479.0)))));
            dArray2[n2 + 1] = this.mlfn(d3, d4, d5) + d4 * d * d2 * 0.5 * (1.0 + 0.08333333333333333 * d10 * (5.0 - d11 + d12 * (9.0 + 4.0 * d12) + 0.03333333333333333 * d10 * (61.0 + d11 * (d11 - 58.0) + d12 * (270.0 - 330.0 * d11) + 0.017857142857142856 * d10 * (1385.0 + d11 * (d11 * (543.0 - d11) - 3111.0)))));
        }
        if (!bl) {
            return null;
        }
        d = d2 * d2;
        double d14 = Math.abs(d5) > 1.0E-6 ? 2.0 * d6 * (1.0 + d11) : 0.0;
        double d15 = 14.0 - 58.0 * d11;
        double d16 = (9.0 - 11.0 * d11) * 30.0;
        double d17 = 2.0 * d9 * d5;
        double d18 = -2.0 * d9 * d4 * d2;
        double d19 = d2 * d4 * (this.excentricitySquared - 1.0) / (1.0 - this.excentricitySquared * d7);
        double d20 = -2.0 * d12 * d6;
        double d21 = ((179.0 - d11) * d11 - 479.0) * d11 + 61.0;
        double d22 = ((543.0 - d11) * d11 - 3111.0) * d11 + 1385.0;
        double d23 = ((358.0 - 3.0 * d11) * d11 - 479.0) * d14;
        double d24 = ((1086.0 - 3.0 * d11) * d11 - 3099.0) * d14;
        double d25 = 5.0 + (d11 - 18.0) * d11 + d8 * (this.esp * d15 + 0.023809523809523808 * d * d21);
        double d26 = 0.023809523809523808 * (d17 * d21);
        double d27 = 0.023809523809523808 * (d18 * d21 + d23 * d10) + (2.0 * d11 + 58.0 * d12 - 18.0) * d14 + d15 * d20;
        double d28 = 0.05 * (d17 * d25 + d26 * d10);
        double d29 = 0.05 * (d18 * d25 + d27 * d10) - d14 + d20;
        double d30 = 0.05 * (d10 * d25) - d11 + d12 + 1.0;
        double d31 = 0.16666666666666666 * (d17 * d30 + d28 * d10);
        double d32 = 0.16666666666666666 * (d18 * d30 + d29 * d10);
        double d33 = 0.16666666666666666 * (d10 * d30) + 1.0;
        double d34 = 0.017857142857142856 * (d10 * d22) + (d11 - 58.0) * d11 + d16 * d12 + 61.0;
        double d35 = 0.017857142857142856 * (d18 * d22 + d24 * d10) + 2.0 * (d11 - 145.0 * d12 - 29.0) * d14 + d16 * d20;
        double d36 = 0.03333333333333333 * d17 * (d34 + 0.017857142857142856 * d22 * d10);
        double d37 = 0.03333333333333333 * (d18 * d34 + d35 * d10) + (9.0 + 8.0 * d12) * d20 - d14;
        double d38 = 0.03333333333333333 * (d10 * d34) + (9.0 + 4.0 * d12) * d12 - d11 + 5.0;
        double d39 = 0.08333333333333333 * (d10 * d38) + 1.0;
        double d40 = 0.08333333333333333 * (d17 * d38 + d36 * d10);
        double d41 = 0.08333333333333333 * (d18 * d38 + d37 * d10);
        return new Matrix2((d5 * d33 + d31 * d9) / d13, (d19 * d33 + d32 * d9) / d13, 0.5 * d4 * d9 * (2.0 * d39 + d40 * d2) / d13, 0.5 * ((d10 + d2 * d4 * d19) * d39 + d * d4 * d5 * d41) / d13 + this.dmlfn_d\u03c6(d7, d8));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = this.inv_mlfn(d2);
        if (Math.abs(d3) >= 1.5707963267948966) {
            d2 = Math.copySign(1.5707963267948966, d2);
            d = 0.0;
        } else {
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = Math.abs(d5) > 1.0E-6 ? d4 / d5 : 0.0;
            double d7 = this.esp * d5 * d5;
            double d8 = 1.0 - this.excentricitySquared * (d4 * d4);
            double d9 = d * Math.sqrt(d8);
            d8 *= d6;
            d6 *= d6;
            double d10 = d9 * d9;
            d2 = d3 - d8 * d10 / (1.0 - this.excentricitySquared) * 0.5 * (1.0 - d10 * 0.08333333333333333 * (5.0 + d6 * (3.0 - 9.0 * d7) + d7 * (1.0 - 4.0 * d7) - d10 * 0.03333333333333333 * (61.0 + d6 * (90.0 - 252.0 * d7 + 45.0 * d6) + 46.0 * d7 - d10 * 0.017857142857142856 * (1385.0 + d6 * (3633.0 + d6 * (4095.0 + 1574.0 * d6))))));
            d = d9 * (1.0 - d10 * 0.16666666666666666 * (1.0 + 2.0 * d6 + d7 - d10 * 0.05 * (5.0 + d6 * (28.0 + 24.0 * d6 + 8.0 * d7) + 6.0 * d7 - d10 * 0.023809523809523808 * (61.0 + d6 * (662.0 + d6 * (1320.0 + 720.0 * d6)))))) / d5;
        }
        dArray2[n2] = this.unrollLongitude(d);
        dArray2[n2 + 1] = d2;
    }

    @Immutable
    static final class Spherical
    extends TransverseMercator {
        private static final long serialVersionUID = 8903592710452235162L;

        protected Spherical(Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = d5 / d6;
            double d8 = d6 * d3;
            double d9 = Math.atan2(d7, d4);
            double d10 = XMath.atanh((double)d8);
            Matrix2 matrix2 = null;
            if (bl) {
                double d11 = d4 * d4 + d7 * d7;
                double d12 = d8 * d8 - 1.0;
                matrix2 = new Matrix2(-(d6 * d4) / d12, d5 * d3 / d12, d7 * d3 / d11, d4 / (d6 * d6 * d11));
            }
            assert (!(Math.abs(d) < 0.08726646259971647) || Assertions.checkDerivative(matrix2, super.transform(dArray, n, dArray2, n2, bl)) && Assertions.checkTransform(dArray2, n2, d10, d9));
            if (dArray2 != null) {
                dArray2[n2] = d10;
                dArray2[n2 + 1] = d9;
            }
            return matrix2;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sinh(d);
            double d4 = Math.cos(d2);
            d2 = Math.copySign(Math.asin(Math.sqrt((1.0 - d4 * d4) / (1.0 + d3 * d3))), d2);
            d = this.unrollLongitude(Math.atan2(d3, d4));
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            if (Math.abs(d) < 0.08726646259971647) {
                super.inverseTransform(dArray, n, dArray2, n2);
                return Assertions.checkInverseTransform(dArray2, n2, d, d2);
            }
            return true;
        }
    }

    protected static class Parameters
    extends UnitaryProjection.Parameters {
        private static final long serialVersionUID = -1689301305119562861L;

        public Parameters(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            super(parameterDescriptorGroup, parameterValueGroup);
        }

        private int getZone(double d, double d2) {
            double d3 = Math.abs(360.0 / d2);
            double d4 = d - 0.5 * d2;
            d4 = Math.toDegrees(this.centralMeridian) - d4;
            d4 = Math.floor(d4 / d2 + 1.0E-6);
            d4 -= d3 * Math.floor(d4 / d3);
            return (int)d4 + 1;
        }

        private double getCentralMedirian(double d, double d2) {
            double d3 = d + (double)(this.getZone(d, d2) - 1) * d2;
            d3 -= 360.0 * Math.floor((d3 + 180.0) / 360.0);
            return d3;
        }

        public int getZone() throws IllegalStateException {
            if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
                return this.getZone(-177.0, 6.0);
            }
            if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
                return this.getZone(-52.5, -3.0);
            }
            throw new IllegalStateException(Errors.format((int)225));
        }

        public double getCentralMeridian() throws IllegalStateException {
            if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
                return this.getCentralMedirian(-177.0, 6.0);
            }
            if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
                return this.getCentralMedirian(-52.5, -3.0);
            }
            throw new IllegalStateException(Errors.format((int)225));
        }
    }
}

