/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.sql.SQLBuilder;
import org.geotoolkit.internal.sql.StatementEntry;
import org.geotoolkit.internal.sql.StatementPool;

@ThreadSafe
public abstract class IdentifierGenerator<K, V extends StatementEntry> {
    static final char SEPARATOR = '-';
    final StatementPool<? super K, V> pool;
    private final String column;
    private final SQLBuilder buffer;

    public IdentifierGenerator(StatementPool<? super K, V> statementPool, String string) throws SQLException {
        this(statementPool, string, new SQLBuilder(statementPool.connection().getMetaData()));
    }

    public IdentifierGenerator(StatementPool<? super K, V> statementPool, String string, SQLBuilder sQLBuilder) {
        this.pool = statementPool;
        this.column = string;
        this.buffer = sQLBuilder;
    }

    protected IdentifierGenerator(IdentifierGenerator<? super K, V> identifierGenerator, String string) {
        this(identifierGenerator.pool, string, identifierGenerator.buffer);
    }

    protected abstract K key(String var1, String var2) throws SQLException;

    protected abstract V value(K var1, PreparedStatement var2) throws SQLException;

    protected boolean quoteColumn() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String identifier(String string, String string2, String string3) throws SQLException {
        StatementPool<? super K, V> statementPool = this.pool;
        synchronized (statementPool) {
            String string4;
            K k = this.key(string, string2);
            Object object = this.pool.remove(k);
            if (object == null) {
                boolean bl = this.quoteColumn();
                object = this.value(k, this.pool.connection().prepareStatement(this.buffer.clear().append("SELECT DISTINCT ").appendIdentifier(this.column, bl).append(" FROM ").appendIdentifier(string, string2).append(" WHERE ").appendIdentifier(this.column, bl).append(" LIKE ? ORDER BY ").appendIdentifier(this.column, bl).toString()));
            }
            ((StatementEntry)object).statement.setString(1, this.buffer.clear().appendEscaped(string3).append('%').toString());
            ResultSet resultSet = ((StatementEntry)object).statement.executeQuery();
            if (resultSet.next() && (string4 = resultSet.getString(1)).equals(string3)) {
                int n;
                int n2 = string3.length() + 1;
                int[] nArray = new int[2];
                int n3 = 0;
                block3: while (resultSet.next()) {
                    string4 = resultSet.getString(1);
                    assert (string4.startsWith(string3)) : string4;
                    while (string4.length() > n2 && (n = (int)string4.charAt(n2 - 1)) >= 45) {
                        String string5;
                        if (n > 45) break block3;
                        n = string4.charAt(n2);
                        if (n < 49) continue block3;
                        if (n <= 57 && (string4 = IdentifierGenerator.search(resultSet, string4, string5 = string4.substring(0, n2), ++n3, n2, nArray)) != null) continue;
                        break block3;
                    }
                }
                if ((n = nArray[1]) == 0) {
                    n = nArray[0] + 1;
                }
                string3 = string3 + '-' + n;
            }
            resultSet.close();
            if (this.pool.put(k, object) != null) {
                throw new AssertionError();
            }
        }
        return string3;
    }

    private static String search(ResultSet resultSet, String string, String string2, int n, int n2, int[] nArray) throws SQLException {
        assert (string.startsWith(string2));
        assert (string.length() > string2.length()) : string;
        do {
            int n3;
            try {
                n3 = Integer.parseInt(string.substring(n2));
            }
            catch (NumberFormatException numberFormatException) {
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                    continue;
                }
                return null;
            }
            if (n3 > n) {
                nArray[1] = n;
                return null;
            }
            if (n3 != n) {
                throw new SQLNonTransientException(string);
            }
            ++n;
            if (n3 > nArray[0]) {
                nArray[0] = n3;
            }
            if (!resultSet.next()) {
                return null;
            }
            String string3 = string.substring(0, string2.length() + 1);
            string = resultSet.getString(1);
            if (!string.startsWith(string3) || (string = IdentifierGenerator.search(resultSet, string, string3, n3 * 10, n2, nArray)) != null) continue;
            return null;
        } while (string.startsWith(string2));
        return string;
    }

    @ThreadSafe
    public static final class Simple
    extends IdentifierGenerator<String, StatementEntry> {
        public Simple(StatementPool<? super String, StatementEntry> statementPool, String string) throws SQLException {
            super(statementPool, string);
        }

        public Simple(StatementPool<? super String, StatementEntry> statementPool, String string, SQLBuilder sQLBuilder) {
            super(statementPool, string, sQLBuilder);
        }

        @Override
        protected String key(String string, String string2) {
            return string2;
        }

        @Override
        protected StatementEntry value(String string, PreparedStatement preparedStatement) {
            return new StatementEntry(preparedStatement);
        }
    }
}

