/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DisjointSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = -7933552571588598563L;
    private final Map<E, DisjointSet<E>> map;
    private final DisjointSet<E> trash;

    public DisjointSet() {
        this(false);
    }

    public DisjointSet(boolean bl) {
        this.map = new LinkedHashMap<E, DisjointSet<E>>();
        this.trash = bl ? new DisjointSet<E>(this.map) : null;
    }

    public DisjointSet(DisjointSet<E> disjointSet) {
        this.map = disjointSet.map;
        this.trash = disjointSet.trash;
    }

    private DisjointSet(Map<E, DisjointSet<E>> map) {
        this.map = map;
        this.trash = null;
    }

    public Set<E> getTrash() {
        return this.trash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            int n = 0;
            for (DisjointSet<E> disjointSet : this.map.values()) {
                if (disjointSet != this) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return this.map.get(object) == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return this.map.put(e, this) != this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            if (this.map.get(object) != this) {
                return false;
            }
            if (this.trash != null) {
                DisjointSet<E> disjointSet = this.map.put(object, this.trash);
                boolean bl = disjointSet != this.trash;
                return bl;
            }
            return this.map.remove(object) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.removeAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.retainAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return new Iter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.toArray(TArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        Map<E, DisjointSet<E>> map = this.map;
        synchronized (map) {
            return super.equals(object);
        }
    }

    private final class Iter
    implements Iterator<E> {
        private final Iterator<Map.Entry<E, DisjointSet<E>>> iterator;
        private Map.Entry<E, DisjointSet<E>> prefetch;
        private Map.Entry<E, DisjointSet<E>> toRemove;

        private Iter() {
            this.iterator = DisjointSet.this.map.entrySet().iterator();
        }

        private Map.Entry<E, DisjointSet<E>> prefetch() {
            this.toRemove = null;
            if (this.prefetch == null) {
                while (this.iterator.hasNext()) {
                    Map.Entry entry = this.iterator.next();
                    if (entry.getValue() != DisjointSet.this) continue;
                    this.prefetch = entry;
                    break;
                }
            }
            return this.prefetch;
        }

        @Override
        public boolean hasNext() {
            return this.prefetch() != null;
        }

        @Override
        public E next() {
            this.toRemove = this.prefetch();
            this.prefetch = null;
            if (this.toRemove != null) {
                return this.toRemove.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.toRemove != null) {
                if (DisjointSet.this.trash != null) {
                    this.toRemove.setValue(DisjointSet.this.trash);
                } else {
                    this.iterator.remove();
                }
            } else {
                throw new IllegalStateException();
            }
            this.toRemove = null;
        }
    }
}

