/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.general;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19136.general.GMLObjectType;

public class AppSchemaInfo {
    private Set<GMLObjectType> gmlContentTypes = EnumSet.noneOf(GMLObjectType.class);
    private List<XSElementDeclaration> featureTypes;
    private Set<XSComplexTypeDefinition> featureDefinitions;
    private List<XSElementDeclaration> geometryTypes;
    private List<XSElementDeclaration> topoTypes;
    private List<XSElementDeclaration> timeTypes;
    private List<XSElementDeclaration> crsTypes;
    private List<XSElementDeclaration> coverageTypes;
    private List<XSElementDeclaration> observationTypes;
    private List<XSElementDeclaration> definitionTypes;

    public Set<GMLObjectType> getGMLContentTypes() {
        return this.gmlContentTypes;
    }

    public List<XSElementDeclaration> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(List<XSElementDeclaration> features) {
        if (!features.isEmpty()) {
            this.featureTypes = Collections.unmodifiableList(features);
            this.gmlContentTypes.add(GMLObjectType.FEATURE_TYPE);
        }
    }

    public Set<XSComplexTypeDefinition> getFeatureDefinitions() {
        return this.featureDefinitions;
    }

    public void setFeatureDefinitions(Set<XSComplexTypeDefinition> typeDefs) {
        if (null != typeDefs) {
            this.featureDefinitions = Collections.unmodifiableSet(typeDefs);
        }
    }

    public List<XSElementDeclaration> getGeometryTypes() {
        return this.geometryTypes;
    }

    public void setGeometryTypes(List<XSElementDeclaration> geometries) {
        if (!geometries.isEmpty()) {
            this.geometryTypes = Collections.unmodifiableList(geometries);
            this.gmlContentTypes.add(GMLObjectType.GEOMETRY);
        }
    }

    public List<XSElementDeclaration> getTimeTypes() {
        return this.timeTypes;
    }

    public void setTimeTypes(List<XSElementDeclaration> timeTypes) {
        if (!timeTypes.isEmpty()) {
            this.timeTypes = Collections.unmodifiableList(timeTypes);
            this.gmlContentTypes.add(GMLObjectType.TIME);
        }
    }

    public List<XSElementDeclaration> getTopoTypes() {
        return this.topoTypes;
    }

    public void setTopoTypes(List<XSElementDeclaration> topoTypes) {
        if (!topoTypes.isEmpty()) {
            this.topoTypes = Collections.unmodifiableList(topoTypes);
            this.gmlContentTypes.add(GMLObjectType.TOPOLOGY);
        }
    }

    public List<XSElementDeclaration> getCoverageTypes() {
        return this.coverageTypes;
    }

    public void setCoverageTypes(List<XSElementDeclaration> coverageTypes) {
        if (!coverageTypes.isEmpty()) {
            this.coverageTypes = Collections.unmodifiableList(coverageTypes);
            this.gmlContentTypes.add(GMLObjectType.COVERAGE);
        }
    }

    public List<XSElementDeclaration> getCrsTypes() {
        return this.crsTypes;
    }

    public void setCrsTypes(List<XSElementDeclaration> crsTypes) {
        if (!crsTypes.isEmpty()) {
            this.crsTypes = Collections.unmodifiableList(crsTypes);
            this.gmlContentTypes.add(GMLObjectType.CRS);
        }
    }

    public List<XSElementDeclaration> getDefinitionTypes() {
        return this.definitionTypes;
    }

    public void setDefinitionTypes(List<XSElementDeclaration> definitionTypes) {
        if (!definitionTypes.isEmpty()) {
            this.definitionTypes = Collections.unmodifiableList(definitionTypes);
            this.gmlContentTypes.add(GMLObjectType.DEFINITION);
        }
    }

    public List<XSElementDeclaration> getObservationTypes() {
        return this.observationTypes;
    }

    public void setObservationTypes(List<XSElementDeclaration> obsTypes) {
        if (!obsTypes.isEmpty()) {
            this.observationTypes = Collections.unmodifiableList(obsTypes);
            this.gmlContentTypes.add(GMLObjectType.OBSERVATION);
        }
    }

    public boolean conforms() {
        return !this.gmlContentTypes.isEmpty();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("AppSchemaInfo [\n");
        str.append("featureTypes: ").append(this.featureTypes).append('\n');
        str.append("geometryTypes: ").append(this.geometryTypes).append('\n');
        str.append("topoTypes: ").append(this.topoTypes).append('\n');
        str.append("timeTypes: ").append(this.timeTypes).append('\n');
        str.append("crsTypes: ").append(this.crsTypes).append('\n');
        str.append("coverageTypes: ").append(this.coverageTypes).append('\n');
        str.append("observationTypes: ").append(this.observationTypes).append('\n');
        str.append("definitionTypes: ").append(this.definitionTypes).append('\n');
        str.append("]\n");
        return str.toString();
    }
}

