/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BuiltinException;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Drop
extends BaseBuiltin {
    @Override
    public String getName() {
        return "drop";
    }

    @Override
    public void headAction(Node[] args, int length, RuleContext context) {
        InfGraph inf = context.getGraph();
        Graph raw = inf.getRawGraph();
        Graph deductions = inf.getDeductionsGraph();
        for (int i = 0; i < length; ++i) {
            ClauseEntry clause;
            Node clauseN = this.getArg(i, args, context);
            if (Util.isNumeric(clauseN)) {
                int clauseIndex = Util.getIntValue(clauseN);
                clause = context.getRule().getBodyElement(clauseIndex);
                if (!(clause instanceof TriplePattern)) {
                    throw new BuiltinException(this, context, "illegal triple to remove non-triple clause");
                }
            } else {
                throw new BuiltinException(this, context, "illegal arg to remove (" + clauseN + "), must be an integer");
            }
            Triple t2 = context.getEnv().instantiate((TriplePattern)clause);
            raw.delete(t2);
            deductions.delete(t2);
        }
    }

    @Override
    public boolean isMonotonic() {
        return false;
    }
}

