/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.coverage.grid.CoordinateOperationFinder;
import org.apache.sis.coverage.grid.DimensionReducer;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundAdjustment;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridDerivation {
    protected final GridGeometry base;
    private GridRoundingMode rounding;
    private GridClippingMode clipping;
    private int[] margin;
    private int[] chunkSize;
    private int[] maximumSubsampling;
    private boolean isBaseExtentExpanded;
    private GridExtent baseExtent;
    private GridExtent scaledExtent;
    private LinearTransform toBase;
    private int[] modifiedDimensions;
    private String subGridSetter;
    private GeneralEnvelope intersection;

    protected GridDerivation(GridGeometry base) {
        ArgumentChecks.ensureNonNull("base", base);
        this.base = base;
        this.baseExtent = base.extent;
        this.rounding = GridRoundingMode.NEAREST;
        this.clipping = GridClippingMode.STRICT;
    }

    private void ensureSubgridNotSet() {
        if (this.subGridSetter != null) {
            throw new IllegalStateException(Resources.format((short)11, this.subGridSetter));
        }
    }

    public GridDerivation rounding(GridRoundingMode mode) {
        ArgumentChecks.ensureNonNull("mode", (Object)mode);
        this.ensureSubgridNotSet();
        this.rounding = mode;
        return this;
    }

    public GridDerivation clipping(GridClippingMode mode) {
        ArgumentChecks.ensureNonNull("mode", (Object)mode);
        this.ensureSubgridNotSet();
        this.clipping = mode;
        return this;
    }

    public GridDerivation margin(int ... cellCounts) {
        this.ensureSubgridNotSet();
        this.margin = GridDerivation.validateCellCounts("cellCounts", cellCounts, 0);
        return this;
    }

    public GridDerivation chunkSize(int ... cellCounts) {
        this.ensureSubgridNotSet();
        this.chunkSize = GridDerivation.validateCellCounts("cellCounts", cellCounts, 1);
        return this;
    }

    public GridDerivation maximumSubsampling(int ... subsampling) {
        this.ensureSubgridNotSet();
        this.maximumSubsampling = GridDerivation.validateCellCounts("subsampling", subsampling, Integer.MAX_VALUE);
        return this;
    }

    private static int[] validateCellCounts(String property, int[] values, int defaultValue) {
        ArgumentChecks.ensureNonNull(property, values);
        int[] copy = null;
        int i = values.length;
        while (--i >= 0) {
            int n = values[i];
            if (n == defaultValue) continue;
            if (defaultValue == 0) {
                ArgumentChecks.ensurePositive(property, n);
            } else {
                ArgumentChecks.ensureStrictlyPositive(property, n);
            }
            if (copy == null) {
                copy = new int[i + 1];
                Arrays.fill(copy, defaultValue);
            }
            copy[i] = n;
        }
        return copy;
    }

    public GridDerivation subgrid(GridGeometry areaOfInterest) {
        double[] scales;
        this.ensureSubgridNotSet();
        ArgumentChecks.ensureNonNull("areaOfInterest", areaOfInterest);
        if (areaOfInterest.isEnvelopeOnly()) {
            return this.subgrid(areaOfInterest.envelope, (double[])null);
        }
        if (areaOfInterest.isExtentOnly()) {
            if (this.baseExtent != null) {
                this.baseExtent = this.baseExtent.intersect(areaOfInterest.extent);
                this.subGridSetter = "subgrid";
            }
            scales = areaOfInterest.resolution;
        } else {
            MathTransform mapCenters;
            if (this.base.equals(areaOfInterest)) {
                return this;
            }
            GridExtent domain = areaOfInterest.extent;
            CoordinateOperationFinder finder = new CoordinateOperationFinder(areaOfInterest, this.base);
            finder.verifyPresenceOfCRS(false);
            try {
                MathTransform mapCorners = domain != null ? finder.gridToGrid() : null;
                finder.setAnchor(PixelInCell.CELL_CENTER);
                finder.nowraparound();
                mapCenters = finder.gridToGrid();
                if (domain != null) {
                    GeneralEnvelope[] envelopes = mapCorners != null ? domain.toEnvelopes(mapCorners, mapCenters, null) : new GeneralEnvelope[]{domain.toEnvelope()};
                    this.setBaseExtentClipped(envelopes);
                    if (this.baseExtent != this.base.extent && this.baseExtent.equals(domain)) {
                        this.baseExtent = domain;
                    }
                }
                this.subGridSetter = "subgrid";
            }
            catch (TransformException | FactoryException e) {
                throw new IllegalGridGeometryException(e, "areaOfInterest");
            }
            scales = GridGeometry.resolution(mapCenters, domain, PixelInCell.CELL_CENTER);
        }
        if (scales == null) {
            return this;
        }
        int[] subsampling = new int[scales.length];
        for (int i = 0; i < subsampling.length; ++i) {
            subsampling[i] = this.roundSubsampling(scales[i], i);
        }
        return this.subsample(subsampling);
    }

    public GridDerivation subgrid(Envelope areaOfInterest, double ... resolution) {
        this.ensureSubgridNotSet();
        boolean isEnvelopeOnly = this.base.isEnvelopeOnly() && (resolution == null || resolution.length == 0);
        MathTransform cornerToCRS = isEnvelopeOnly ? MathTransforms.identity(this.base.envelope.getDimension()) : this.base.requireGridToCRS(false);
        this.subGridSetter = "subgrid";
        try {
            CoordinateReferenceSystem crs;
            MathTransform baseToAOI = null;
            if (areaOfInterest != null && (crs = areaOfInterest.getCoordinateReferenceSystem()) != null) {
                areaOfInterest = new DimensionReducer(this.base, crs).apply(areaOfInterest);
                baseToAOI = this.findBaseToAOI(areaOfInterest.getCoordinateReferenceSystem());
                cornerToCRS = MathTransforms.concatenate(cornerToCRS, baseToAOI);
            }
            if (isEnvelopeOnly) {
                if (areaOfInterest != null) {
                    this.intersection = new GeneralEnvelope(this.base.envelope);
                    if (baseToAOI != null && !baseToAOI.isIdentity()) {
                        areaOfInterest = Envelopes.transform(baseToAOI.inverse(), areaOfInterest);
                    }
                    this.intersection.intersect(areaOfInterest);
                }
                return this;
            }
            int dimension = cornerToCRS.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("areaOfInterest", dimension, areaOfInterest);
            cornerToCRS = this.dropUnusedDimensions(cornerToCRS, dimension);
            dimension = this.baseExtent.getDimension();
            GeneralEnvelope indices = null;
            if (areaOfInterest != null) {
                indices = this.wraparound(baseToAOI, cornerToCRS).shift(areaOfInterest);
                this.setBaseExtentClipped(indices);
            }
            if (indices == null || indices.getDimension() != dimension) {
                indices = new GeneralEnvelope(dimension);
            }
            GridExtent extent = this.getBaseExtentExpanded(true);
            for (int i = 0; i < dimension; ++i) {
                long high = extent.getHigh(i);
                if (high != Long.MAX_VALUE) {
                    ++high;
                }
                indices.setRange(i, extent.getLow(i), high);
            }
            if (resolution != null && resolution.length != 0) {
                int i;
                double s2;
                int k;
                resolution = ArraysExt.resize(resolution, cornerToCRS.getTargetDimensions());
                Matrix affine = cornerToCRS.derivative(new DirectPositionView.Double(this.getPointOfInterest()));
                double[] subsampling = Matrices.inverse(affine).multiply(resolution);
                int[] modifiedDimensions = this.modifiedDimensions;
                boolean scaled = false;
                for (k = 0; k < subsampling.length; ++k) {
                    s2 = Math.abs(subsampling[k]);
                    if (s2 > 1.0) {
                        scaled = true;
                        int n = i = modifiedDimensions != null ? modifiedDimensions[k] : k;
                        if (this.chunkSize != null && i < this.chunkSize.length && this.chunkSize[i] != 1) {
                            s2 = this.roundSubsampling(s2, i);
                        } else {
                            double max;
                            int accuracy = Math.max(0, Math.getExponent(indices.getSpan(i))) + 1;
                            s2 = Math.scalb(Math.rint(Math.scalb(s2, accuracy)), -accuracy);
                            if (this.maximumSubsampling != null && i < this.maximumSubsampling.length && s2 > (max = (double)this.maximumSubsampling[i])) {
                                s2 = max;
                            }
                        }
                        indices.setRange(i, indices.getLower(i) / s2, indices.getUpper(i) / s2);
                    }
                    subsampling[k] = s2;
                }
                if (scaled) {
                    this.scaledExtent = new GridExtent(indices, this.rounding, this.clipping, null, null, null, modifiedDimensions);
                    if (extent.equals(this.scaledExtent)) {
                        this.scaledExtent = extent;
                    }
                    affine = Matrices.createIdentity(dimension + 1);
                    for (k = 0; k < subsampling.length; ++k) {
                        s2 = subsampling[k];
                        if (!(s2 > 1.0)) continue;
                        i = modifiedDimensions != null ? modifiedDimensions[k] : k;
                        affine.setElement(i, i, s2);
                        affine.setElement(i, dimension, Math.fma(-s2, (double)this.scaledExtent.getLow(i), (double)extent.getLow(i)));
                    }
                    this.toBase = MathTransforms.linear(affine);
                }
            }
        }
        catch (TransformException | FactoryException e) {
            throw new IllegalGridGeometryException(e, "areaOfInterest");
        }
        this.modifiedDimensions = null;
        return this;
    }

    private MathTransform findBaseToAOI(CoordinateReferenceSystem target) throws FactoryException {
        CoordinateReferenceSystem gridCRS = this.base.getCoordinateReferenceSystem();
        return CRS.findOperation(gridCRS, target, this.base.getGeographicExtent().orElse(null)).getMathTransform();
    }

    private WraparoundAdjustment wraparound(MathTransform baseToAOI, MathTransform gridToCRS) throws TransformException {
        return new WraparoundAdjustment(this.base.envelope, baseToAOI, gridToCRS.inverse());
    }

    private MathTransform dropUnusedDimensions(MathTransform gridToCRS, int dimension) throws FactoryException, TransformException {
        if (dimension < gridToCRS.getSourceDimensions()) {
            TransformSeparator sep = new TransformSeparator(gridToCRS);
            gridToCRS = sep.separate();
            this.modifiedDimensions = sep.getSourceDimensions();
            if (this.modifiedDimensions.length != dimension) {
                throw new TransformException(Resources.format((short)8));
            }
        }
        return gridToCRS;
    }

    private double[] getPointOfInterest() {
        double[] pointOfInterest = this.baseExtent.getPointOfInterest(PixelInCell.CELL_CORNER);
        if (this.modifiedDimensions == null) {
            return pointOfInterest;
        }
        double[] filtered = new double[this.modifiedDimensions.length];
        for (int i = 0; i < filtered.length; ++i) {
            filtered[i] = pointOfInterest[this.modifiedDimensions[i]];
        }
        return filtered;
    }

    private void setBaseExtentClipped(GeneralEnvelope ... indices) {
        GridExtent sub = null;
        DisjointExtentException error = null;
        int i = 0;
        do {
            try {
                GridExtent c = new GridExtent(indices[i], this.rounding, this.clipping, this.margin, this.chunkSize, this.baseExtent, this.modifiedDimensions);
                sub = sub == null ? c : sub.union(c);
            }
            catch (DisjointExtentException e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        } while (++i < indices.length);
        if (sub == null) {
            throw error;
        }
        if (!sub.equals(this.baseExtent)) {
            this.baseExtent = sub;
        }
        this.isBaseExtentExpanded = true;
    }

    public GridDerivation subgrid(GridExtent areaOfInterest, int ... subsampling) {
        int actual;
        this.ensureSubgridNotSet();
        int n = this.base.getDimension();
        if (areaOfInterest != null && (actual = areaOfInterest.getDimension()) != n) {
            throw new IllegalArgumentException(Errors.format((short)81, "extent", n, actual));
        }
        if (areaOfInterest != null && this.baseExtent != null) {
            this.baseExtent = this.baseExtent.intersect(areaOfInterest);
            this.subGridSetter = "subgrid";
        }
        if (subsampling == null) {
            return this;
        }
        if (this.chunkSize != null || this.maximumSubsampling != null) {
            subsampling = (int[])subsampling.clone();
            for (int i = 0; i < subsampling.length; ++i) {
                subsampling[i] = this.roundSubsampling(subsampling[i], i);
            }
        }
        return this.subsample(subsampling);
    }

    private GridDerivation subsample(int ... subsampling) {
        if (this.toBase != null) {
            throw new IllegalStateException(Errors.format((short)164, "subsampling"));
        }
        if (this.subGridSetter == null) {
            this.subGridSetter = "subsample";
        }
        GridExtent extent = this.getBaseExtentExpanded(true);
        MatrixSIS affine = null;
        int dimension = extent.getDimension();
        int i = Math.min(dimension, subsampling.length);
        while (--i >= 0) {
            int s2 = subsampling[i];
            if (s2 == 1) continue;
            if (affine == null) {
                affine = Matrices.createIdentity(dimension + 1);
                this.scaledExtent = extent.subsample(subsampling);
            }
            long offset = Math.subtractExact(extent.getLow(i), Math.multiplyExact(this.scaledExtent.getLow(i), s2));
            affine.setElement(i, i, s2);
            affine.setElement(i, dimension, offset);
        }
        if (affine != null) {
            this.toBase = MathTransforms.linear(affine);
        }
        return this;
    }

    public GridDerivation slice(DirectPosition slicePoint) {
        ArgumentChecks.ensureNonNull("slicePoint", slicePoint);
        MathTransform gridToCRS = this.base.requireGridToCRS(true);
        this.subGridSetter = "slice";
        try {
            MathTransform baseToPOI;
            CoordinateReferenceSystem sliceCRS;
            if (this.toBase != null) {
                gridToCRS = MathTransforms.concatenate(this.toBase, gridToCRS);
            }
            if ((sliceCRS = slicePoint.getCoordinateReferenceSystem()) == null) {
                baseToPOI = null;
            } else {
                slicePoint = new DimensionReducer(this.base, sliceCRS).apply(slicePoint);
                baseToPOI = this.findBaseToAOI(sliceCRS);
                gridToCRS = MathTransforms.concatenate(gridToCRS, baseToPOI);
            }
            int dimension = gridToCRS.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("slicePoint", dimension, slicePoint);
            gridToCRS = this.dropUnusedDimensions(gridToCRS, dimension);
            DirectPosition gridPoint = this.wraparound(baseToPOI, gridToCRS).shift(slicePoint);
            if (this.scaledExtent != null) {
                this.scaledExtent = this.scaledExtent.slice(gridPoint, this.modifiedDimensions);
            }
            if (this.toBase != null) {
                gridPoint = this.toBase.transform(gridPoint, gridPoint);
            }
            this.baseExtent = this.getBaseExtentExpanded(true).slice(gridPoint, this.modifiedDimensions);
        }
        catch (FactoryException e) {
            throw new IllegalGridGeometryException(Resources.format((short)8), e);
        }
        catch (TransformException e) {
            throw new IllegalGridGeometryException(e, "slicePoint");
        }
        this.modifiedDimensions = null;
        return this;
    }

    public GridDerivation sliceByRatio(double sliceRatio, int ... dimensionsToKeep) {
        ArgumentChecks.ensureBetween("sliceRatio", 0.0, 1.0, sliceRatio);
        ArgumentChecks.ensureNonNull("dimensionsToKeep", dimensionsToKeep);
        this.subGridSetter = "sliceByRatio";
        GridExtent extent = this.getBaseExtentExpanded(true);
        GeneralDirectPosition slicePoint = new GeneralDirectPosition(extent.getDimension());
        this.baseExtent = extent.sliceByRatio(slicePoint, sliceRatio, dimensionsToKeep);
        if (this.scaledExtent != null) {
            this.scaledExtent = this.scaledExtent.sliceByRatio(slicePoint, sliceRatio, dimensionsToKeep);
        }
        return this;
    }

    public GridGeometry build() {
        GridExtent extent = this.scaledExtent != null ? this.scaledExtent : this.getBaseExtentExpanded(false);
        try {
            if (this.toBase != null || extent != this.base.extent) {
                return new GridGeometry(this.base, extent, this.toBase);
            }
            if (this.intersection != null) {
                return new GridGeometry(PixelInCell.CELL_CENTER, this.base.gridToCRS, this.intersection, this.rounding);
            }
            GridExtent resized = this.getBaseExtentExpanded(false);
            if (resized != this.baseExtent) {
                return new GridGeometry(this.base, resized, null);
            }
        }
        catch (TransformException e) {
            throw new IllegalGridGeometryException(e, "envelope");
        }
        return this.base;
    }

    private GridExtent getBaseExtentExpanded(boolean nonNull) {
        if (nonNull && this.baseExtent == null) {
            this.baseExtent = this.base.getExtent();
        }
        if (!this.isBaseExtentExpanded) {
            if (this.baseExtent != null && (this.margin != null || this.chunkSize != null)) {
                GridExtent resized = this.baseExtent;
                if (this.margin != null) {
                    resized = resized.expand(ArraysExt.copyAsLongs(this.margin));
                }
                if (this.chunkSize != null) {
                    resized = resized.forChunkSize(this.chunkSize);
                }
                if (this.clipping == GridClippingMode.STRICT) {
                    resized = resized.intersect(this.base.extent);
                }
                if (!resized.equals(this.baseExtent)) {
                    this.baseExtent = resized;
                }
            }
            this.isBaseExtentExpanded = true;
        }
        return this.baseExtent;
    }

    public GridExtent getIntersection() {
        return this.getBaseExtentExpanded(true);
    }

    public int[] getSubsampling() {
        int[] subsampling;
        if (this.toBase == null) {
            subsampling = new int[this.base.getDimension()];
            Arrays.fill(subsampling, 1);
        } else {
            subsampling = new int[this.toBase.getTargetDimensions()];
            Matrix affine = this.toBase.getMatrix();
            for (int j = 0; j < subsampling.length; ++j) {
                double e = affine.getElement(j, j);
                subsampling[j] = (int)e;
                if ((double)subsampling[j] == e) continue;
                throw new IllegalStateException(Errors.format((short)171, e));
            }
        }
        return subsampling;
    }

    private int roundSubsampling(double scale, int dimension) {
        int size;
        int r;
        int subsampling;
        switch (this.rounding) {
            default: {
                throw new AssertionError((Object)this.rounding);
            }
            case NEAREST: {
                subsampling = (int)Math.min(Math.round(scale), Integer.MAX_VALUE);
                break;
            }
            case CONTAINED: {
                subsampling = (int)Math.ceil(scale - this.tolerance(dimension));
                break;
            }
            case ENCLOSING: {
                subsampling = (int)(scale + this.tolerance(dimension));
            }
        }
        int max = Integer.MAX_VALUE;
        if (this.maximumSubsampling != null && dimension < this.maximumSubsampling.length && subsampling > (max = this.maximumSubsampling[dimension])) {
            subsampling = max;
        }
        if (subsampling <= 1) {
            return 1;
        }
        if (this.chunkSize != null && dimension < this.chunkSize.length && (r = subsampling % (size = this.chunkSize[dimension])) > 1 && size % r != 0) {
            int[] divisors = MathFunctions.divisors(size);
            int i = ~Arrays.binarySearch(divisors, r);
            int s2 = divisors[i - 1];
            int offset = subsampling - r;
            if (this.rounding != GridRoundingMode.ENCLOSING && i < divisors.length) {
                int above = divisors[i];
                if (!(max != Integer.MAX_VALUE && above > max - offset || this.rounding != GridRoundingMode.CONTAINED && above - r >= r - s2)) {
                    s2 = above;
                }
            }
            return s2 + offset;
        }
        return subsampling;
    }

    private double tolerance(int dimension) {
        return this.base.extent != null ? 0.5 / this.base.extent.getSize(dimension, false) : 0.0;
    }

    public int[] getSubsamplingOffsets() {
        int[] offsets;
        if (this.toBase == null) {
            offsets = new int[this.base.getDimension()];
        } else {
            int srcDim = this.toBase.getSourceDimensions();
            offsets = new int[this.toBase.getTargetDimensions()];
            Matrix affine = this.toBase.getMatrix();
            for (int j = 0; j < offsets.length; ++j) {
                double e = affine.getElement(j, srcDim);
                offsets[j] = (int)e;
                if ((double)offsets[j] == e) continue;
                throw new IllegalStateException(Errors.format((short)171, e));
            }
        }
        return offsets;
    }

    private TreeTable toTree(Locale locale) {
        TreeTable.Node section;
        TableColumn<CharSequence> column = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable tree = new DefaultTreeTable(column);
        TreeTable.Node root = tree.getRoot();
        root.setValue(column, Classes.getShortClassName(this));
        StringBuilder buffer = new StringBuilder(256);
        if (this.baseExtent != null) {
            section = root.newChild();
            section.setValue(column, "Intersection");
            try {
                this.baseExtent.appendTo(buffer, Vocabulary.getResources(locale));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            for (CharSequence line : CharSequences.splitOnEOL(buffer)) {
                String text = line.toString().trim();
                if (text.isEmpty()) continue;
                section.newChild().setValue(column, text);
            }
        }
        if (this.toBase != null) {
            section = root.newChild();
            section.setValue(column, "Subsampling");
            boolean offsets = false;
            do {
                buffer.setLength(0);
                buffer.append(offsets ? (char)'+' : '\u00d7').append(" {");
                int srcDim = this.toBase.getSourceDimensions();
                int tgtDim = this.toBase.getTargetDimensions();
                Matrix affine = this.toBase.getMatrix();
                for (int j = 0; j < tgtDim; ++j) {
                    if (j != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(affine.getElement(j, offsets ? srcDim : j));
                    StringBuilders.trimFractionalPart(buffer);
                }
                section.newChild().setValue(column, buffer.append('}').toString());
            } while (offsets = !offsets);
        }
        return tree;
    }

    public String toString() {
        return this.toTree(null).toString();
    }
}

