/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.Feature;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyType;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

final class LinkOperation
extends AbstractOperation {
    private static final long serialVersionUID = 765096861589501215L;
    private static final ParameterDescriptorGroup PARAMETERS = FeatureUtilities.parameters("Link", new ParameterDescriptor[0]);
    final PropertyType result;
    final String referentName;

    LinkOperation(Map<String, ?> identification, PropertyType referent) {
        super(identification);
        if (referent instanceof LinkOperation) {
            referent = ((LinkOperation)referent).result;
        }
        this.result = referent;
        this.referentName = referent.getName().toString();
        if (this.referentName.equals(this.getName().toString())) {
            throw new IllegalArgumentException(Errors.format((short)18));
        }
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return PARAMETERS;
    }

    @Override
    public IdentifiedType getResult() {
        return this.result;
    }

    @Override
    public Set<String> getDependencies() {
        return Set.of(this.referentName);
    }

    @Override
    public Property apply(Feature feature, ParameterValueGroup parameters) {
        ArgumentChecks.ensureNonNull("feature", feature);
        return feature.getProperty(this.referentName);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.referentName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.referentName.equals(((LinkOperation)obj).referentName);
    }

    @Override
    void formatResultFormula(Appendable buffer) throws IOException {
        buffer.append(this.referentName);
    }
}

