/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.util.Static;
import org.opengis.feature.PropertyType;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;

public final class FeatureUtilities
extends Static {
    private FeatureUtilities() {
    }

    public static ParameterDescriptorGroup parameters(String name, ParameterDescriptor<?> ... parameters) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", name);
        properties.put("authority", Citations.SIS);
        return new DefaultParameterDescriptorGroup(properties, 1, 1, new GeneralParameterDescriptor[0]);
    }

    public static String[] getNames(Collection<? extends PropertyType> properties) {
        if (properties == null) {
            return null;
        }
        String[] names = new String[properties.size()];
        Iterator<? extends PropertyType> it = properties.iterator();
        for (int i = 0; i < names.length; ++i) {
            GenericName name;
            PropertyType property = it.next();
            if (property == null || (name = property.getName()) == null) continue;
            names[i] = name.toString();
        }
        if (it.hasNext()) {
            throw new ConcurrentModificationException();
        }
        return names;
    }
}

