/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.awt.Shape;
import java.util.Map;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.jts.GeometryCoordinateTransform;
import org.apache.sis.internal.feature.jts.ShapeAdapter;
import org.apache.sis.internal.feature.jts.ShapeConverter;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class JTS
extends Static {
    public static final String CRS_KEY = "CRS";

    private JTS() {
    }

    static boolean isSameCRS(Geometry first, Geometry second) {
        Object c2;
        int id2;
        int id1 = first.getSRID();
        if ((id1 | (id2 = second.getSRID())) != 0) {
            return id1 == id2;
        }
        Object c1 = first.getUserData();
        if (c1 != null && !(c1 instanceof CoordinateReferenceSystem)) {
            Object object = c1 = c1 instanceof Map ? (Object)((Map)c1).get(CRS_KEY) : null;
        }
        if (c1 == (c2 = second.getUserData())) {
            return true;
        }
        if (c2 != null && !(c2 instanceof CoordinateReferenceSystem)) {
            c2 = c2 instanceof Map ? ((Map)c2).get(CRS_KEY) : null;
        }
        return c1 == c2;
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(Geometry source) throws FactoryException {
        if (source != null) {
            Map map;
            Object value;
            Object userData = source.getUserData();
            if (userData instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)userData;
            }
            if (userData instanceof Map && (value = (map = (Map)userData).get(CRS_KEY)) instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)value;
            }
            int srid = source.getSRID();
            if (srid > 0) {
                return CRS.forCode("EPSG:" + srid);
            }
        }
        return null;
    }

    static void setCoordinateReferenceSystem(Geometry target, CoordinateReferenceSystem crs) {
        target.setUserData(crs);
        int epsg = 0;
        Identifier id = IdentifiedObjects.getIdentifier(crs, Citations.EPSG);
        if (id != null) {
            try {
                epsg = Integer.parseInt(id.getCode());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        target.setSRID(epsg);
    }

    static void copyMetadata(Geometry source, Geometry target) {
        target.setSRID(source.getSRID());
        Object crs = source.getUserData();
        if (!(crs instanceof CoordinateReferenceSystem)) {
            if (!(crs instanceof Map)) {
                return;
            }
            if (!((crs = ((Map)crs).get(CRS_KEY)) instanceof CoordinateReferenceSystem)) {
                return;
            }
        }
        target.setUserData(crs);
    }

    private static CoordinateOperation findOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Geometry areaOfInterest) throws FactoryException {
        DefaultGeographicBoundingBox bbox = null;
        if (!areaOfInterest.isEmpty()) {
            bbox = new DefaultGeographicBoundingBox();
            try {
                Envelope e = areaOfInterest.getEnvelopeInternal();
                GeneralEnvelope env = new GeneralEnvelope(sourceCRS);
                env.setRange(0, e.getMinX(), e.getMaxX());
                env.setRange(1, e.getMinY(), e.getMaxY());
                bbox.setBounds(env);
            }
            catch (TransformException ex) {
                bbox = null;
                Logging.ignorableException(Geometries.LOGGER, JTS.class, "transform", ex);
            }
        }
        return CRS.findOperation(sourceCRS, targetCRS, bbox);
    }

    public static Geometry transform(Geometry geometry, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (geometry != null && targetCRS != null && (sourceCRS = JTS.getCoordinateReferenceSystem(geometry)) != null && !Utilities.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            geometry = JTS.transform(geometry, JTS.findOperation(sourceCRS, targetCRS, geometry), false);
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, CoordinateOperation operation, boolean validate) throws FactoryException, TransformException {
        if (geometry != null && operation != null) {
            CoordinateReferenceSystem crs;
            CoordinateReferenceSystem sourceCRS;
            if (validate && (sourceCRS = operation.getSourceCRS()) != null && (crs = JTS.getCoordinateReferenceSystem(geometry)) != null && !Utilities.equalsIgnoreMetadata(sourceCRS, crs)) {
                operation = JTS.findOperation(crs, operation.getTargetCRS(), geometry);
            }
            geometry = JTS.transform(geometry, operation.getMathTransform());
            geometry.setUserData(operation.getTargetCRS());
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, MathTransform transform) throws TransformException {
        if (geometry != null && transform != null && !transform.isIdentity()) {
            GeometryCoordinateTransform gct = new GeometryCoordinateTransform(transform, geometry.getFactory());
            geometry = gct.transform(geometry);
        }
        return geometry;
    }

    public static Shape asShape(Geometry geometry) {
        ArgumentChecks.ensureNonNull("geometry", geometry);
        return new ShapeAdapter(geometry);
    }

    public static Geometry fromAWT(GeometryFactory factory, Shape shape, double flatness) {
        ArgumentChecks.ensureNonNull("shape", shape);
        return ShapeConverter.create(factory, shape, flatness);
    }
}

