/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.jaxb.metadata.replace.Parameter;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.Names;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDirection;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;
import org.opengis.util.TypeName;

@XmlType(name="SV_Parameter_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"memberName", "legacyName", "direction", "description", "optionality", "optionalityLabel", "repeatability", "legacyValueType"})
@XmlRootElement(name="SV_Parameter", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public final class ServiceParameter
extends Parameter {
    @XmlElement(required=true, name="name")
    @XmlJavaTypeAdapter(value=GO_GenericName.Since2014.class)
    MemberName memberName;
    @XmlElement(required=true)
    ParameterDirection direction;
    @XmlElement
    InternationalString description;
    boolean optionality;
    @XmlElement(required=true)
    boolean repeatability;

    ServiceParameter() {
    }

    private ServiceParameter(ParameterDescriptor<?> parameter) {
        super(parameter);
        this.memberName = ServiceParameter.getMemberName(parameter);
        this.direction = parameter.getDirection();
        this.description = parameter.getDescription();
        this.optionality = parameter.getMinimumOccurs() > 0;
        this.repeatability = parameter.getMaximumOccurs() > 1;
    }

    public static ServiceParameter castOrCopy(ParameterDescriptor<?> parameter) {
        if (parameter == null || parameter instanceof ServiceParameter) {
            return (ServiceParameter)parameter;
        }
        return new ServiceParameter(parameter);
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameter) {
        if (parameter != null) {
            String code;
            Identifier id = parameter.getName();
            if (id instanceof MemberName) {
                return (MemberName)((Object)id);
            }
            for (GenericName alias : CollectionsExt.nonNull(parameter.getAlias())) {
                if (!(alias instanceof MemberName)) continue;
                return (MemberName)alias;
            }
            if (id != null && (code = id.getCode()) != null) {
                String namespace = id.getCodeSpace();
                TypeName type = parameter.getValueType();
                if (type != null) {
                    return Names.createMemberName((CharSequence)namespace, null, (CharSequence)code, type);
                }
                Class<?> valueClass = parameter.getValueClass();
                if (valueClass != null) {
                    return Names.createMemberName((CharSequence)namespace, null, (CharSequence)code, valueClass);
                }
            }
        }
        return null;
    }

    @Override
    public synchronized Identifier getName() {
        if (this.name == null && this.memberName != null) {
            this.name = this.memberName instanceof Identifier ? (Identifier)((Object)this.memberName) : new NameToIdentifier(this.memberName);
        }
        return this.name;
    }

    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/srv")
    private DefaultMemberName getLegacyName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? DefaultMemberName.castOrCopy(this.memberName) : null;
    }

    private void setLegacyName(DefaultMemberName value) {
        if (this.memberName == null) {
            this.memberName = value;
        }
    }

    @XmlElement(name="valueType", namespace="http://www.isotc211.org/2005/srv")
    @XmlJavaTypeAdapter(value=GO_GenericName.class)
    private TypeName getLegacyValueType() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.getValueType() : null;
    }

    @Override
    public TypeName getValueType() {
        TypeName type = super.getValueType();
        if (type == null && this.memberName != null) {
            type = this.memberName.getAttributeType();
        }
        return type;
    }

    @Override
    public Class<?> getValueClass() {
        Class type = super.getValueClass();
        return type != null ? type : Names.toClass(this.getValueType());
    }

    @Override
    public ParameterDirection getDirection() {
        return this.direction;
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    @XmlElement(name="optionality", required=true)
    final Boolean getOptionality() {
        return FilterByVersion.CURRENT_METADATA.accept() ? Boolean.valueOf(this.optionality) : null;
    }

    final void setOptionality(Boolean optional) {
        if (optional != null) {
            this.optionality = optional;
        }
    }

    @XmlElement(name="optionality", namespace="http://www.isotc211.org/2005/srv")
    final String getOptionalityLabel() {
        return FilterByVersion.LEGACY_METADATA.accept() ? (this.optionality ? "Optional" : "Mandatory") : null;
    }

    final void setOptionalityLabel(String optional) {
        if (optional != null) {
            this.optionality = Boolean.parseBoolean(optional) || optional.equalsIgnoreCase("Optional");
        }
    }

    @Override
    public int getMinimumOccurs() {
        return this.optionality ? 0 : 1;
    }

    @Override
    public int getMaximumOccurs() {
        return this.repeatability ? Integer.MAX_VALUE : 1;
    }
}

