/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.sis.util.logging.Logging;

public final class AxisNames {
    public static final String LONGITUDE = "Longitude";
    public static final String LATITUDE = "Latitude";
    public static final String GEODETIC_LONGITUDE = "Geodetic longitude";
    public static final String GEODETIC_LATITUDE = "Geodetic latitude";
    public static final String PLANETODETIC_LONGITUDE = "Planetodetic longitude";
    public static final String PLANETODETIC_LATITUDE = "Planetodetic latitude";
    public static final String SPHERICAL_LONGITUDE = "Spherical longitude";
    public static final String SPHERICAL_LATITUDE = "Spherical latitude";
    public static final String ELLIPSOIDAL_HEIGHT = "Ellipsoidal height";
    public static final String GRAVITY_RELATED_HEIGHT = "Gravity-related height";
    public static final String DEPTH = "Depth";
    public static final String GEOCENTRIC_X = "Geocentric X";
    public static final String GEOCENTRIC_Y = "Geocentric Y";
    public static final String GEOCENTRIC_Z = "Geocentric Z";
    public static final String GEOCENTRIC_RADIUS = "Geocentric radius";
    public static final String EASTING = "Easting";
    public static final String WESTING = "Westing";
    public static final String NORTHING = "Northing";
    public static final String SOUTHING = "Southing";
    public static final String TIME = "Time";
    private static final Map<String, String> VALUES;

    private AxisNames() {
    }

    private static String toUpperCase(String name, StringBuilder buffer) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            buffer.append(Character.toUpperCase(c));
        }
        return buffer.toString();
    }

    public static String toCamelCase(String name) {
        return VALUES.getOrDefault(AxisNames.toUpperCase(name, new StringBuilder(name.length())), name);
    }

    static {
        HashMap<String, String> values = new HashMap<String, String>(22);
        StringBuilder buffer = new StringBuilder(22);
        try {
            for (Field f : AxisNames.class.getFields()) {
                String name = (String)f.get(null);
                values.put(AxisNames.toUpperCase(name, buffer).intern(), name);
                buffer.setLength(0);
            }
        }
        catch (IllegalAccessException e) {
            Logging.unexpectedException(Logger.getLogger("org.apache.sis.referencing"), AxisNames.class, "<cinit>", e);
        }
        VALUES = values;
    }
}

