/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Wraparound
extends AbstractProvider {
    private static final long serialVersionUID = -7464255385789611569L;
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptor<Integer> WRAPAROUND_DIMENSION;
    public static final ParameterDescriptor<Double> PERIOD;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Wraparound() {
        super(Conversion.class, PARAMETERS, CoordinateSystem.class, 2, false, CoordinateSystem.class, 2, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        Parameters pg = Parameters.castOrWrap(values);
        return WraparoundTransform.create(pg.intValue(DIMENSION), pg.intValue(WRAPAROUND_DIMENSION), pg.doubleValue(PERIOD), Double.NaN, 0.0);
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)Wraparound.builder().setCodeSpace(Citations.SIS, "SIS");
        DIMENSION = ((ParameterBuilder)builder.addName(Molodensky.DIMENSION.getName())).createBounded(Integer.class, Integer.valueOf(1), null, null);
        WRAPAROUND_DIMENSION = ((ParameterBuilder)builder.addName("wraparound_dim")).createBounded(Integer.class, Integer.valueOf(0), null, null);
        PERIOD = ((ParameterBuilder)builder.addName("period")).createStrictlyPositive(Double.NaN, null);
        PARAMETERS = ((ParameterBuilder)builder.addName("Wraparound")).createGroup(DIMENSION, WRAPAROUND_DIMENSION, PERIOD);
    }
}

