/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Collection;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureType;

public class MemoryFeatureSet
extends AbstractFeatureSet {
    private final FeatureType type;
    private final Collection<Feature> features;

    public MemoryFeatureSet(Resource parent, FeatureType type, Collection<Feature> features) {
        super(parent);
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("features", features);
        this.type = type;
        this.features = features;
    }

    @Override
    public FeatureType getType() {
        return this.type;
    }

    @Override
    public OptionalLong getFeatureCount() {
        return OptionalLong.of(this.features.size());
    }

    @Override
    public Stream<Feature> features(boolean parallel) {
        return parallel ? this.features.parallelStream() : this.features.stream();
    }
}

