/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.RangeArgument;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ObservableImage;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Statistics;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.operation.TransformException;

abstract class RasterStore
extends PRJDataStore
implements GridCoverageResource {
    private static final int VISIBLE_BAND = 0;
    static final String NROWS = "NROWS";
    static final String NCOLS = "NCOLS";
    static final String STX = "stx";
    static final String CLR = "clr";
    private ColorModel colorModel;
    private List<SampleDimension> sampleDimensions;
    double nodataValue = Double.NaN;
    Metadata metadata;
    private static final short[] RGB_BAND_NAMES = new short[]{167, 96, 18, 201};

    RasterStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.listeners.useReadOnlyEvents();
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        return this.listComponentFiles("prj", STX, CLR);
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.ofNullable(this.getGridGeometry().getEnvelope());
    }

    final void createMetadata(String formatName, String formatKey) throws DataStoreException {
        GridGeometry gridGeometry = this.getGridGeometry();
        MetadataBuilder builder = new MetadataBuilder();
        try {
            builder.setPredefinedFormat(formatKey);
        }
        catch (MetadataStoreException e) {
            builder.addFormatName(formatName);
            this.listeners.warning(e);
        }
        builder.addResourceScope(ScopeCode.COVERAGE, null);
        builder.addEncoding(this.encoding, MetadataBuilder.Scope.METADATA);
        builder.addSpatialRepresentation(null, gridGeometry, true);
        try {
            builder.addExtent(gridGeometry.getEnvelope());
        }
        catch (TransformException e) {
            this.listeners.warning(e);
        }
        if (this.sampleDimensions != null) {
            for (SampleDimension band : this.sampleDimensions) {
                builder.addNewBand(band);
            }
        }
        this.addTitleOrIdentifier(builder);
        builder.setISOStandards(false);
        this.metadata = builder.buildAndFreeze();
    }

    private ColorModel readColorMap(int dataType, int mapSize, int numBands) throws DataStoreException, IOException {
        int maxSize;
        switch (dataType) {
            case 0: {
                maxSize = 255;
                break;
            }
            case 1: {
                maxSize = 65535;
                break;
            }
            default: {
                return null;
            }
        }
        int count = 0;
        long[] indexAndColors = ArraysExt.EMPTY_LONG;
        for (CharSequence line : CharSequences.splitOnEOL(this.readAuxiliaryFile(CLR))) {
            int end = CharSequences.skipTrailingWhitespaces(line, 0, line.length());
            int start = CharSequences.skipLeadingWhitespaces(line, 0, end);
            if (start >= end || !Character.isDigit(Character.codePointAt(line, start))) continue;
            int column = 0;
            long code = 0L;
            for (CharSequence item : CharSequences.split(line.subSequence(start, end), ' ')) {
                if (item.length() == 0) continue;
                int value = Integer.parseInt(item.toString());
                if (column == 0) {
                    code = (long)value << 32;
                } else {
                    value = Math.max(0, Math.min(255, value));
                    code |= (long)(value << (3 - column) * 8);
                }
                if (++column >= 4) break;
            }
            if (count >= indexAndColors.length) {
                indexAndColors = Arrays.copyOf(indexAndColors, Math.max(count * 2, 64));
            }
            indexAndColors[count++] = code | 0xFF000000L;
        }
        if (count <= 1) {
            return null;
        }
        Arrays.sort(indexAndColors, 0, count);
        int[] ARGB = new int[Math.max(mapSize, Math.toIntExact((indexAndColors[count - 1] >>> 32) + 1L))];
        int[] colors = new int[2];
        for (int i = 1; i < count; ++i) {
            int upper = (int)(indexAndColors[i] >>> 32);
            int lower = (int)(indexAndColors[i - 1] >>> 32);
            if (upper >= lower) {
                colors[0] = (int)indexAndColors[i - 1];
                colors[1] = (int)indexAndColors[i];
                ColorModelFactory.expand(colors, ARGB, lower, upper + 1);
            }
            if (upper <= maxSize) continue;
            ARGB = Arrays.copyOf(ARGB, maxSize + 1);
            break;
        }
        return ColorModelFactory.createIndexColorModel(numBands, 0, ARGB, true, -1);
    }

    private Statistics[] readStatistics(String name, SampleModel sm) throws DataStoreException, IOException {
        Statistics[] stats = new Statistics[sm.getNumBands()];
        for (CharSequence line : CharSequences.splitOnEOL(this.readAuxiliaryFile(STX))) {
            int end = CharSequences.skipTrailingWhitespaces(line, 0, line.length());
            int start = CharSequences.skipLeadingWhitespaces(line, 0, end);
            if (start >= end || !Character.isDigit(Character.codePointAt(line, start))) continue;
            int column = 0;
            int band = 0;
            double minimum = Double.NaN;
            double maximum = Double.NaN;
            double mean = Double.NaN;
            double stdev = Double.NaN;
            for (CharSequence item : CharSequences.split(line.subSequence(start, end), ' ')) {
                if (item.length() == 0) continue;
                if (column == 0) {
                    band = Integer.parseInt(item.toString());
                } else if (item.charAt(0) != '#') {
                    double value = Double.parseDouble(item.toString());
                    switch (column) {
                        case 1: {
                            minimum = value;
                            break;
                        }
                        case 2: {
                            maximum = value;
                            break;
                        }
                        case 3: {
                            mean = value;
                            break;
                        }
                        case 4: {
                            stdev = value;
                        }
                    }
                }
                ++column;
            }
            if (band < true || band > stats.length) continue;
            int count = Math.multiplyExact(sm.getWidth(), sm.getHeight());
            stats[band - 1] = new Statistics(name, 0, count, minimum, maximum, mean, stdev, false);
        }
        return stats;
    }

    final void loadBandDescriptions(String name, SampleModel sm, Statistics ... stats) throws DataStoreException {
        SampleDimension[] bands = new SampleDimension[sm.getNumBands()];
        try {
            stats = this.readStatistics(name, sm);
        }
        catch (IOException | NumberFormatException e) {
            this.canNotReadAuxiliaryFile(STX, e);
        }
        int dataType = sm.getDataType();
        boolean isInteger = ImageUtilities.isIntegerType(dataType);
        boolean isUnsigned = isInteger && ImageUtilities.isUnsignedType(sm);
        boolean isRGB = isInteger && (bands.length == 3 || bands.length == 4);
        SampleDimension.Builder builder = new SampleDimension.Builder();
        for (int band = 0; band < bands.length; ++band) {
            Statistics s2;
            double minimum = Double.NaN;
            double maximum = Double.NaN;
            if (band < stats.length && (s2 = stats[band]) != null) {
                minimum = s2.minimum();
                maximum = s2.maximum();
            }
            if (!(minimum <= maximum)) {
                minimum = 0.0;
                maximum = 1.0;
                if (isInteger) {
                    long max = Numerics.bitmask(sm.getSampleSize(band)) - 1L;
                    if (!isUnsigned) {
                        minimum = (max >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    maximum = max;
                }
            }
            if (isRGB) {
                builder.setName(Vocabulary.formatInternational(RGB_BAND_NAMES[band]));
            } else {
                if (name != null) {
                    builder.setName(name);
                    name = null;
                }
                builder.addQuantitative(null, minimum, maximum, null);
                if (this.nodataValue < minimum || this.nodataValue > maximum) {
                    builder.mapQualitative(null, this.nodataValue, Float.NaN);
                }
            }
            bands[band] = builder.build().forConvertedValues(!isInteger);
            builder.clear();
            if (band != 0) continue;
            if (isRGB) {
                this.colorModel = ColorModelFactory.createRGB(sm);
                continue;
            }
            try {
                this.colorModel = this.readColorMap(dataType, (int)(maximum + 1.0), bands.length);
            }
            catch (IOException | NumberFormatException e) {
                this.canNotReadAuxiliaryFile(CLR, e);
            }
            if (this.colorModel != null) continue;
            this.colorModel = ColorModelFactory.createGrayScale(dataType, bands.length, band, minimum, maximum);
        }
        this.sampleDimensions = UnmodifiableArrayList.wrap(bands);
    }

    private void canNotReadAuxiliaryFile(String suffix, Exception exception) {
        Level level = Level.WARNING;
        if (exception instanceof NoSuchFileException || exception instanceof FileNotFoundException) {
            level = Level.FINE;
        }
        this.listeners.warning(level, Resources.format((short)66, suffix), exception);
    }

    final GridCoverage2D createCoverage(GridGeometry domain, RangeArgument range, WritableRaster data, Statistics stats) {
        SampleDimension[] bands = range.select(this.sampleDimensions);
        Hashtable<String, Object[]> properties = null;
        if (stats != null) {
            Object[] as = new Statistics[range.getNumBands()];
            Arrays.fill(as, stats);
            properties = new Hashtable<String, Object[]>();
            properties.put("org.apache.sis.Statistics", as);
            properties.put("org.apache.sis.SampleDimensions", bands);
        }
        ColorModel cm = this.colorModel;
        if (!range.isIdentity() && (cm = range.select(cm)) == null) {
            SampleDimension band = bands[0];
            cm = ColorModelFactory.createGrayScale(data.getSampleModel(), 0, band.getSampleRange().orElse(null));
        }
        return new GridCoverage2D(domain, Arrays.asList(bands), new ObservableImage(cm, data, false, properties));
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.sampleDimensions;
    }

    @Override
    public void close() throws DataStoreException {
        this.metadata = null;
    }
}

