/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.awt.image.RenderedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.internal.storage.image.FormatFinder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;

enum FormatFilter {
    NAME(ImageReaderWriterSpi::getFormatNames),
    SUFFIX(ImageReaderWriterSpi::getFileSuffixes),
    MIME(ImageReaderWriterSpi::getMIMETypes);

    private final Function<ImageReaderWriterSpi, String[]> property;
    private static final Class<?>[] VALID_INPUTS;
    private static final Class<?>[] VALID_OUTPUTS;

    private FormatFilter(Function<ImageReaderWriterSpi, String[]> property) {
        this.property = property;
    }

    private <T extends ImageReaderWriterSpi> Iterator<T> getServiceProviders(Class<T> category, String identifier) {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        if (identifier != null) {
            ServiceRegistry.Filter filter = provider -> {
                Object[] identifiers = this.property.apply((ImageReaderWriterSpi)provider);
                return ArraysExt.contains(identifiers, identifier);
            };
            return registry.getServiceProviders(category, filter, true);
        }
        return registry.getServiceProviders(category, true);
    }

    final ImageReaderSpi findProvider(String identifier, StorageConnector connector, Set<ImageReaderSpi> done) throws IOException, DataStoreException {
        Iterator<ImageReaderSpi> it = SUFFIX.getServiceProviders(ImageReaderSpi.class, identifier);
        block0: while (it.hasNext()) {
            ImageReaderSpi provider = it.next();
            if (!done.add(provider)) continue;
            for (Class<?> type : provider.getInputTypes()) {
                Object input;
                if (!ArraysExt.contains(VALID_INPUTS, type) || (input = connector.getStorageAs(type)) == null) continue;
                if (!provider.canDecodeInput(input)) continue block0;
                return provider;
            }
        }
        return null;
    }

    final ImageReader createReader(String identifier, FormatFinder format, Map<ImageReaderSpi, Boolean> deferred) throws IOException, DataStoreException {
        Iterator<ImageReaderSpi> it = this.getServiceProviders(ImageReaderSpi.class, identifier);
        block0: while (it.hasNext()) {
            ImageReaderSpi provider = it.next();
            if (deferred.putIfAbsent(provider, Boolean.FALSE) != null) continue;
            for (Class<?> type : provider.getInputTypes()) {
                if (!ArraysExt.contains(VALID_INPUTS, type)) continue;
                Object input = format.connector.getStorageAs(type);
                if (input != null) {
                    if (!provider.canDecodeInput(input)) continue block0;
                    ImageReader reader = provider.createReaderInstance();
                    reader.setInput(input, false, true);
                    format.keepOpen = input;
                    return reader;
                }
                if (type != ImageInputStream.class) continue;
                deferred.put(provider, Boolean.TRUE);
            }
        }
        return null;
    }

    final ImageWriter createWriter(String identifier, FormatFinder format, RenderedImage image, Map<ImageWriterSpi, Boolean> deferred) throws IOException, DataStoreException {
        Iterator<ImageWriterSpi> it = this.getServiceProviders(ImageWriterSpi.class, identifier);
        while (it.hasNext()) {
            ImageWriterSpi provider = it.next();
            if (deferred.putIfAbsent(provider, Boolean.FALSE) != null || image != null && !provider.canEncodeImage(image)) continue;
            for (Class<?> type : provider.getOutputTypes()) {
                Object output;
                if (ArraysExt.contains(VALID_OUTPUTS, type) && (output = format.connector.getStorageAs(type)) != null) {
                    ImageWriter writer = provider.createWriterInstance();
                    writer.setOutput(output);
                    format.keepOpen = output;
                    return writer;
                }
                if (type != ImageOutputStream.class) continue;
                deferred.put(provider, Boolean.TRUE);
            }
        }
        return null;
    }

    static {
        VALID_INPUTS = new Class[]{ImageInputStream.class, DataInput.class, InputStream.class, File.class, Path.class, URL.class, URI.class};
        VALID_OUTPUTS = new Class[]{DataOutput.class, OutputStream.class, File.class, Path.class, URL.class, URI.class};
    }
}

