/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.CharConversionException;
import java.io.IOException;
import org.apache.sis.io.IO;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;

abstract class Appender
implements Appendable {
    protected final Appendable out;
    private char highSurrogate;

    protected Appender(Appendable out) {
        ArgumentChecks.ensureNonNull("out", out);
        this.out = out;
    }

    final String lineSeparator(CharSequence sequence, int start, int end) {
        if (this.isHighSurrogate()) {
            ++start;
        }
        while (start < end) {
            int c = Character.codePointAt(sequence, start);
            int b = start;
            start += Character.charCount(c);
            if (!Characters.isLineOrParagraphSeparator(c)) continue;
            if (c == 13 && start < end && sequence.charAt(start) == '\n') {
                ++start;
            }
            return sequence.subSequence(b, start).toString();
        }
        return null;
    }

    final int toCodePoint(char c) {
        char h2 = this.highSurrogate;
        if (h2 != '\u0000') {
            this.highSurrogate = '\u0000';
            if (Character.isLowSurrogate(c)) {
                return Character.toCodePoint(h2, c);
            }
        }
        if (Character.isHighSurrogate(c)) {
            this.highSurrogate = c;
            return -1;
        }
        return c;
    }

    final boolean isHighSurrogate() {
        return this.highSurrogate != '\u0000';
    }

    final int appendSurrogate(CharSequence sequence, int start, int end) throws IOException {
        if (start != end && this.highSurrogate != '\u0000') {
            char c = sequence.charAt(start);
            if (Character.isLowSurrogate(c)) {
                this.append(c);
                ++start;
            } else {
                throw new CharConversionException();
            }
        }
        return start;
    }

    final void appendCodePoint(int c) throws IOException {
        if (Character.isBmpCodePoint(c)) {
            this.out.append((char)c);
        } else if (Character.isSupplementaryCodePoint(c)) {
            this.out.append(Character.highSurrogate(c)).append(Character.lowSurrogate(c));
        } else {
            throw new CharConversionException();
        }
    }

    @Override
    public Appendable append(CharSequence sequence) throws IOException {
        if (sequence == null) {
            sequence = "null";
        }
        return this.append(sequence, 0, sequence.length());
    }

    public String toString() {
        return IO.toString(this);
    }
}

