/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.measure.Dimension;
import org.apache.sis.internal.converter.FractionConverter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.resources.Errors;

final class UnitDimension
implements Dimension,
Serializable {
    private static final long serialVersionUID = 2568769237612674235L;
    static final UnitDimension NONE = new UnitDimension(Map.of());
    final Map<UnitDimension, Fraction> components;
    final char symbol;

    UnitDimension(char symbol) {
        this.symbol = symbol;
        this.components = Map.of(this, new Fraction(1, 1).unique());
        UnitRegistry.init(this.components, this);
    }

    private UnitDimension(Map<UnitDimension, Fraction> components) {
        this.components = components;
        this.symbol = '\u0000';
    }

    private static UnitDimension create(Map<UnitDimension, Fraction> components) {
        switch (components.size()) {
            case 0: {
                return NONE;
            }
            case 1: {
                Map.Entry<UnitDimension, Fraction> entry = components.entrySet().iterator().next();
                Fraction power2 = entry.getValue();
                if (power2.numerator != 1 || power2.denominator != 1) break;
                return entry.getKey();
            }
        }
        UnitDimension dim = (UnitDimension)UnitRegistry.get(components);
        if (dim == null) {
            components.replaceAll((c, power) -> power.unique());
            components = CollectionsExt.unmodifiableOrCopy(components);
            dim = new UnitDimension(components);
            if (!Units.initialized) {
                UnitRegistry.init(components, dim);
            } else {
                UnitDimension c2 = (UnitDimension)UnitRegistry.putIfAbsent(components, dim);
                if (c2 != null) {
                    return c2;
                }
            }
        }
        return dim;
    }

    Object readResolve() throws ObjectStreamException {
        UnitDimension dim;
        if (this.isDimensionless()) {
            return NONE;
        }
        if (Units.initialized && (dim = (UnitDimension)UnitRegistry.putIfAbsent(this.components, this)) != null) {
            return dim;
        }
        return this;
    }

    final boolean isDimensionless() {
        return this.components.isEmpty();
    }

    static boolean isDimensionless(Dimension dim) {
        Map<? extends Dimension, Integer> bases;
        if (dim instanceof UnitDimension) {
            return ((UnitDimension)dim).isDimensionless();
        }
        if (dim != null && (bases = dim.getBaseDimensions()) != null) {
            return bases.isEmpty();
        }
        return false;
    }

    final boolean numeratorIs(char s2) {
        if (this.symbol == s2) {
            assert (this.components.keySet().equals(Set.of(this)));
            return true;
        }
        boolean found = false;
        for (Map.Entry<UnitDimension, Fraction> e : this.components.entrySet()) {
            Fraction value = e.getValue();
            if (e.getKey().symbol == s2) {
                if (value.numerator != value.denominator) {
                    return false;
                }
                found = true;
                continue;
            }
            if (value.signum() < 0) continue;
            return false;
        }
        return found;
    }

    public Map<UnitDimension, Integer> getBaseDimensions() {
        if (this.symbol != '\u0000') {
            return null;
        }
        return ObjectConverters.derivedValues(this.components, UnitDimension.class, FractionConverter.INSTANCE);
    }

    private static Map<? extends Dimension, Fraction> getBaseDimensions(Dimension dimension) {
        if (dimension instanceof UnitDimension) {
            return ((UnitDimension)dimension).components;
        }
        Map<? extends Dimension, Integer> components = dimension.getBaseDimensions();
        if (components == null) {
            return Map.of(dimension, new Fraction(1, 1));
        }
        return ObjectConverters.derivedValues(components, Dimension.class, FractionConverter.FromInteger.INSTANCE);
    }

    @Override
    public UnitDimension multiply(Dimension multiplicand) {
        return this.combine(multiplicand, false);
    }

    @Override
    public UnitDimension divide(Dimension divisor) {
        return this.combine(divisor, true);
    }

    private UnitDimension combine(Dimension other, boolean divide) {
        LinkedHashMap<UnitDimension, Fraction> product = new LinkedHashMap<UnitDimension, Fraction>(this.components);
        for (Map.Entry<? extends Dimension, Fraction> entry : UnitDimension.getBaseDimensions(other).entrySet()) {
            Dimension dim = entry.getKey();
            Fraction p = entry.getValue();
            if (divide) {
                p = p.negate();
            }
            if (dim instanceof UnitDimension) {
                product.merge((UnitDimension)dim, p, (sum, toAdd) -> {
                    sum = sum.add((Fraction)toAdd);
                    return sum.numerator != 0 ? sum : null;
                });
                continue;
            }
            if (p.numerator == 0) continue;
            throw new UnsupportedImplementationException(Errors.format((short)160, dim.getClass()));
        }
        return UnitDimension.create(product);
    }

    private UnitDimension pow(Fraction n) {
        LinkedHashMap<UnitDimension, Fraction> product = new LinkedHashMap<UnitDimension, Fraction>(this.components);
        product.replaceAll((dim, power) -> power.multiply(n));
        return UnitDimension.create(product);
    }

    @Override
    public UnitDimension pow(int n) {
        switch (n) {
            case 0: {
                return NONE;
            }
            case 1: {
                return this;
            }
        }
        return this.pow(new Fraction(n, 1));
    }

    @Override
    public UnitDimension root(int n) {
        switch (n) {
            case 0: {
                throw new ArithmeticException(Errors.format((short)45, "n", 0));
            }
            case 1: {
                return this;
            }
        }
        return this.pow(new Fraction(1, n));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof UnitDimension) {
            UnitDimension that = (UnitDimension)other;
            if (this.symbol == that.symbol) {
                return this.symbol != '\u0000' || this.components.equals(that.components);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.symbol != '\u0000' ? this.symbol ^ 0xFDDABCBB : this.components.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(8);
        try {
            UnitFormat.formatComponents(this.components, UnitFormat.Style.SYMBOL, buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toString();
    }
}

