/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.Individual;
import org.opengis.metadata.citation.Organisation;
import org.opengis.metadata.citation.Party;
import org.opengis.util.InternationalString;

@TitleProperty(name="name")
@XmlType(name="AbstractCI_Party_Type", propOrder={"name", "contactInfo", "identifiers"})
@XmlRootElement(name="AbstractCI_Party")
@XmlSeeAlso(value={DefaultIndividual.class, DefaultOrganisation.class})
public class AbstractParty
extends ISOMetadata
implements Party {
    private static final long serialVersionUID = 1486981243884830979L;
    private InternationalString name;
    private Collection<Contact> contactInfo;

    public AbstractParty() {
    }

    public AbstractParty(CharSequence name, Contact contactInfo) {
        this.name = Types.toInternationalString(name);
        this.contactInfo = this.singleton(contactInfo, Contact.class);
    }

    public AbstractParty(Party object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.contactInfo = this.copyList(object.getContactInfo(), Contact.class);
        }
    }

    public static AbstractParty castOrCopy(Party object) {
        if (object instanceof Individual) {
            return DefaultIndividual.castOrCopy((Individual)object);
        }
        if (object instanceof Organisation) {
            return DefaultOrganisation.castOrCopy((Organisation)object);
        }
        if (object == null || object instanceof AbstractParty) {
            return (AbstractParty)object;
        }
        return new AbstractParty(object);
    }

    @Override
    @XmlElement(name="name")
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @Override
    @XmlElement(name="partyIdentifier")
    public Collection<Identifier> getIdentifiers() {
        return NonMarshalledAuthority.filterOnMarshalling(super.getIdentifiers());
    }

    public void setIdentifiers(Collection<? extends Identifier> newValues) {
        newValues = NonMarshalledAuthority.setMarshallables(this.identifiers, newValues);
        this.identifiers = this.writeCollection(newValues, this.identifiers, Identifier.class);
    }

    @XmlElement(name="contactInfo")
    public Collection<Contact> getContactInfo() {
        this.contactInfo = this.nonNullCollection(this.contactInfo, Contact.class);
        return this.contactInfo;
    }

    public void setContactInfo(Collection<? extends Contact> newValues) {
        this.contactInfo = this.writeCollection(newValues, this.contactInfo, Contact.class);
    }
}

