/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.jaxb.gco.UnitAdapter;
import org.apache.sis.internal.jaxb.gmi.MI_Band;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.BandDefinition;
import org.opengis.metadata.content.PolarisationOrientation;
import org.opengis.metadata.content.TransferFunctionType;

@XmlType(name="MD_Band_Type", propOrder={"boundMax", "boundMin", "boundUnits", "peakResponse", "toneGradation", "bandBoundaryDefinition", "nominalSpatialResolution", "transferFunctionType", "transmittedPolarisation", "detectedPolarisation"})
@XmlRootElement(name="MD_Band")
@XmlSeeAlso(value={MI_Band.class})
public class DefaultBand
extends DefaultSampleDimension
implements Band {
    private static final long serialVersionUID = 2492553738885938445L;
    private Double boundMin;
    private Double boundMax;
    private Unit<Length> boundUnits;
    private BandDefinition bandBoundaryDefinition;
    private Double peakResponse;
    private Integer toneGradation;
    private PolarisationOrientation transmittedPolarisation;
    private PolarisationOrientation detectedPolarisation;

    public DefaultBand() {
    }

    public DefaultBand(Band object) {
        super(object);
        if (object != null) {
            this.boundMin = object.getBoundMin();
            this.boundMax = object.getBoundMax();
            this.boundUnits = object.getBoundUnits();
            this.peakResponse = object.getPeakResponse();
            this.toneGradation = object.getToneGradation();
            this.bandBoundaryDefinition = object.getBandBoundaryDefinition();
            this.transmittedPolarisation = object.getTransmittedPolarisation();
            this.detectedPolarisation = object.getDetectedPolarisation();
        }
    }

    public static DefaultBand castOrCopy(Band object) {
        if (object == null || object instanceof DefaultBand) {
            return (DefaultBand)object;
        }
        return new DefaultBand(object);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="boundMin")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    public Double getBoundMin() {
        return this.boundMin;
    }

    public void setBoundMin(Double newValue) {
        this.checkWritePermission(this.boundMin);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "boundMin", false, newValue)) {
            this.boundMin = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="boundMax")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    public Double getBoundMax() {
        return this.boundMax;
    }

    public void setBoundMax(Double newValue) {
        this.checkWritePermission(this.boundMax);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "boundMax", false, newValue)) {
            this.boundMax = newValue;
        }
    }

    @Override
    @XmlElement(name="boundUnits")
    @XmlJavaTypeAdapter(value=UnitAdapter.Since2014.class)
    public Unit<Length> getBoundUnits() {
        return this.boundUnits;
    }

    public void setBoundUnits(Unit<Length> newValue) {
        this.checkWritePermission(this.boundUnits);
        this.boundUnits = newValue;
    }

    @Override
    @XmlElement(name="bandBoundaryDefinition")
    public BandDefinition getBandBoundaryDefinition() {
        return this.bandBoundaryDefinition;
    }

    public void setBandBoundaryDefinition(BandDefinition newValue) {
        this.checkWritePermission(this.bandBoundaryDefinition);
        this.bandBoundaryDefinition = newValue;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="peakResponse")
    public Double getPeakResponse() {
        return this.peakResponse;
    }

    public void setPeakResponse(Double newValue) {
        this.checkWritePermission(this.peakResponse);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "peakResponse", false, newValue)) {
            this.peakResponse = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="toneGradation")
    public Integer getToneGradation() {
        return this.toneGradation;
    }

    public void setToneGradation(Integer newValue) {
        this.checkWritePermission(this.toneGradation);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "toneGradation", false, newValue)) {
            this.toneGradation = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="nominalSpatialResolution")
    public Double getNominalSpatialResolution() {
        return super.getNominalSpatialResolution();
    }

    @Override
    public void setNominalSpatialResolution(Double newValue) {
        super.setNominalSpatialResolution(newValue);
    }

    @Override
    @XmlElement(name="transferFunctionType")
    public TransferFunctionType getTransferFunctionType() {
        return super.getTransferFunctionType();
    }

    @Override
    public void setTransferFunctionType(TransferFunctionType newValue) {
        super.setTransferFunctionType(newValue);
    }

    @Override
    @XmlElement(name="transmittedPolarisation")
    public PolarisationOrientation getTransmittedPolarisation() {
        return this.transmittedPolarisation;
    }

    public void setTransmittedPolarisation(PolarisationOrientation newValue) {
        this.checkWritePermission(this.transmittedPolarisation);
        this.transmittedPolarisation = newValue;
    }

    @Override
    @XmlElement(name="detectedPolarisation")
    public PolarisationOrientation getDetectedPolarisation() {
        return this.detectedPolarisation;
    }

    public void setDetectedPolarisation(PolarisationOrientation newValue) {
        this.checkWritePermission(this.detectedPolarisation);
        this.detectedPolarisation = newValue;
    }
}

