/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.identification.OperationChainMetadata;
import org.opengis.metadata.identification.OperationMetadata;
import org.opengis.util.InternationalString;

@TitleProperty(name="name")
@XmlType(name="SV_OperationChainMetadata_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"name", "description", "operations"})
@XmlRootElement(name="SV_OperationChainMetadata", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public class DefaultOperationChainMetadata
extends ISOMetadata
implements OperationChainMetadata {
    private static final long serialVersionUID = 4132508877114835287L;
    private InternationalString name;
    private InternationalString description;
    private List<OperationMetadata> operations;

    public DefaultOperationChainMetadata() {
    }

    public DefaultOperationChainMetadata(CharSequence name) {
        this.name = Types.toInternationalString(name);
    }

    public DefaultOperationChainMetadata(OperationChainMetadata object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.description = object.getDescription();
            this.operations = this.copyList(object.getOperations(), OperationMetadata.class);
        }
    }

    public static DefaultOperationChainMetadata castOrCopy(OperationChainMetadata object) {
        if (object == null || object instanceof DefaultOperationChainMetadata) {
            return (DefaultOperationChainMetadata)object;
        }
        return new DefaultOperationChainMetadata(object);
    }

    @Override
    @XmlElement(name="name", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", required=true)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @Override
    @XmlElement(name="description", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="operation", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", required=true)
    public List<OperationMetadata> getOperations() {
        this.operations = this.nonNullList(this.operations, OperationMetadata.class);
        return this.operations;
    }

    public void setOperations(List<? extends OperationMetadata> newValues) {
        this.operations = this.writeList(newValues, this.operations, OperationMetadata.class);
    }
}

