/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.MD_Scope;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.util.InternationalString;

@XmlType(name="LI_Lineage_Type", propOrder={"statement", "scope", "documentation", "processSteps", "sources"})
@XmlRootElement(name="LI_Lineage")
public class DefaultLineage
extends ISOMetadata
implements Lineage {
    private static final long serialVersionUID = 6214461492323186254L;
    private InternationalString statement;
    private Scope scope;
    private Collection<Citation> additionalDocumentation;
    private Collection<ProcessStep> processSteps;
    private Collection<Source> sources;

    public DefaultLineage() {
    }

    public DefaultLineage(Lineage object) {
        super(object);
        if (object != null) {
            this.statement = object.getStatement();
            this.scope = object.getScope();
            this.additionalDocumentation = this.copyCollection(object.getAdditionalDocumentation(), Citation.class);
            this.processSteps = this.copyCollection(object.getProcessSteps(), ProcessStep.class);
            this.sources = this.copyCollection(object.getSources(), Source.class);
        }
    }

    public static DefaultLineage castOrCopy(Lineage object) {
        if (object == null || object instanceof DefaultLineage) {
            return (DefaultLineage)object;
        }
        return new DefaultLineage(object);
    }

    @Override
    @XmlElement(name="statement")
    public InternationalString getStatement() {
        return this.statement;
    }

    public void setStatement(InternationalString newValue) {
        this.checkWritePermission(this.statement);
        this.statement = newValue;
    }

    @Override
    @XmlElement(name="scope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        this.checkWritePermission(this.scope);
        this.scope = newValue;
    }

    public Collection<Citation> getAdditionalDocumentation() {
        this.additionalDocumentation = this.nonNullCollection(this.additionalDocumentation, Citation.class);
        return this.additionalDocumentation;
    }

    public void setAdditionalDocumentation(Collection<? extends Citation> newValues) {
        this.additionalDocumentation = this.writeCollection(newValues, this.additionalDocumentation, Citation.class);
    }

    @XmlElement(name="processStep")
    public Collection<ProcessStep> getProcessSteps() {
        this.processSteps = this.nonNullCollection(this.processSteps, ProcessStep.class);
        return this.processSteps;
    }

    public void setProcessSteps(Collection<? extends ProcessStep> newValues) {
        this.processSteps = this.writeCollection(newValues, this.processSteps, ProcessStep.class);
    }

    @XmlElement(name="source")
    public Collection<Source> getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public void setSources(Collection<? extends Source> newValues) {
        this.sources = this.writeCollection(newValues, this.sources, Source.class);
    }

    @XmlElement(name="additionalDocumentation")
    private Collection<Citation> getDocumentation() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAdditionalDocumentation() : null;
    }
}

