/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.metadata.replace.QualityParameter;
import org.apache.sis.internal.jaxb.referencing.CC_OperationParameter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.util.TypeName;

@XmlType(name="OperationParameterType")
@XmlRootElement(name="OperationParameter")
public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -1978932430298071693L;
    private Class<T> valueClass;
    private final Set<T> validValues;
    private Range<?> valueDomain;
    private final T defaultValue;

    public DefaultParameterDescriptor(Map<String, ?> properties, int minimumOccurs, int maximumOccurs, Class<T> valueClass, Range<?> valueDomain, T[] validValues, T defaultValue) {
        super(properties, minimumOccurs, maximumOccurs);
        Verifier error;
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        ArgumentChecks.ensureCanCast("defaultValue", valueClass, defaultValue);
        if (valueDomain != null) {
            Class<Object> componentType = valueClass.getComponentType();
            componentType = componentType != null ? Numbers.primitiveToWrapper(componentType) : valueClass;
            Class<?> elementType = valueDomain.getElementType();
            if (elementType != componentType) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)42, "valueDomain", "Range<" + Classes.getShortName(elementType) + ">"));
            }
            if (valueDomain.isEmpty()) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)60, valueDomain.getMinValue(), valueDomain.getMaxValue()));
            }
        }
        this.valueClass = valueClass;
        this.valueDomain = valueDomain;
        this.defaultValue = Numerics.cached(defaultValue);
        if (validValues != null) {
            Set<T> valids = CollectionsExt.createSetForType(valueClass, validValues.length);
            for (T value : validValues) {
                if (value == null) continue;
                Verifier error2 = Verifier.ensureValidValue(valueClass, null, valueDomain, value = Numerics.cached(value));
                if (error2 != null) {
                    throw new IllegalArgumentException(error2.message(properties, super.getName().getCode(), value));
                }
                valids.add(value);
            }
            this.validValues = CollectionsExt.unmodifiableOrCopy(valids);
        } else {
            this.validValues = null;
        }
        if (defaultValue != null && (error = Verifier.ensureValidValue(valueClass, this.validValues, valueDomain, defaultValue)) != null) {
            throw new IllegalArgumentException(error.message(properties, super.getName().getCode(), defaultValue));
        }
    }

    protected DefaultParameterDescriptor(ParameterDescriptor<T> descriptor) {
        super(descriptor);
        this.valueClass = descriptor.getValueClass();
        this.validValues = descriptor.getValidValues();
        this.defaultValue = descriptor.getDefaultValue();
        this.valueDomain = Parameters.getValueDomain(descriptor);
    }

    public static <T> DefaultParameterDescriptor<T> castOrCopy(ParameterDescriptor<T> object) {
        return object == null || object instanceof DefaultParameterDescriptor ? (DefaultParameterDescriptor<T>)object : new DefaultParameterDescriptor<T>(object);
    }

    public Class<? extends ParameterDescriptor<T>> getInterface() {
        return ParameterDescriptor.class;
    }

    @Override
    public TypeName getValueType() {
        return QualityParameter.getValueType(this.valueClass);
    }

    @Override
    public final Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Set<T> getValidValues() {
        return this.validValues;
    }

    public final Range<?> getValueDomain() {
        return this.valueDomain;
    }

    @Override
    public Comparable<T> getMinimumValue() {
        Range<?> valueDomain = this.valueDomain;
        return valueDomain != null && valueDomain.getElementType() == this.valueClass ? (Comparable<T>)valueDomain.getMinValue() : null;
    }

    @Override
    public Comparable<T> getMaximumValue() {
        Range<?> valueDomain = this.valueDomain;
        return valueDomain != null && valueDomain.getElementType() == this.valueClass ? (Comparable<T>)valueDomain.getMaxValue() : null;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Unit<?> getUnit() {
        Range<?> valueDomain = this.valueDomain;
        return valueDomain instanceof MeasurementRange ? ((MeasurementRange)valueDomain).unit() : null;
    }

    @Override
    public ParameterValue<T> createValue() {
        return new DefaultParameterValue(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            switch (mode) {
                default: {
                    ParameterDescriptor that = (ParameterDescriptor)object;
                    return this.getValueClass() == that.getValueClass() && Objects.deepEquals(this.getDefaultValue(), that.getDefaultValue()) && Utilities.deepEquals(this.getUnit(), that.getUnit(), mode) && (this.isHeuristicMatchForName(that.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName(that, this.getName().getCode()));
                }
                case BY_CONTRACT: {
                    ParameterDescriptor that = (ParameterDescriptor)object;
                    return this.getMinimumOccurs() == that.getMinimumOccurs() && this.getMaximumOccurs() == that.getMaximumOccurs() && this.getValueClass() == that.getValueClass() && Utilities.deepEquals(this.getValueType(), that.getValueType(), mode) && Objects.equals(this.getValidValues(), that.getValidValues()) && Objects.equals(this.getMinimumValue(), that.getMinimumValue()) && Objects.equals(this.getMaximumValue(), that.getMaximumValue()) && Objects.deepEquals(this.getDefaultValue(), that.getDefaultValue()) && Utilities.deepEquals(this.getUnit(), that.getUnit(), mode);
                }
                case STRICT: 
            }
            DefaultParameterDescriptor that = (DefaultParameterDescriptor)object;
            return this.valueClass == that.valueClass && Objects.equals(this.validValues, that.validValues) && Objects.equals(this.valueDomain, that.valueDomain) && Objects.deepEquals(this.defaultValue, that.defaultValue);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return (long)Arrays.deepHashCode(new Object[]{this.valueClass, this.valueDomain, this.defaultValue}) + super.computeHashCode();
    }

    private DefaultParameterDescriptor() {
        PropertyType<?, ?> wrapper = Context.getWrapper(Context.current());
        if (wrapper instanceof CC_OperationParameter) {
            CC_OperationParameter param = (CC_OperationParameter)wrapper;
            this.valueClass = param.valueClass;
            this.valueDomain = param.valueDomain;
        }
        this.validValues = null;
        this.defaultValue = null;
    }

    final void setValueClass(DefaultParameterValue<?> param) {
        this.valueClass = Classes.findCommonClass(this.valueClass, CC_OperationParameter.valueClass(param));
        if (this.valueDomain == null) {
            this.valueDomain = CC_OperationParameter.valueDomain(param);
        }
    }
}

