/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.datum.PrimeMeridian;

@XmlType(name="PrimeMeridianType")
@XmlRootElement(name="PrimeMeridian")
public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    private double greenwichLongitude;
    private Unit<Angle> angularUnit;

    public DefaultPrimeMeridian(Map<String, ?> properties, double greenwichLongitude, Unit<Angle> angularUnit) {
        super(properties);
        ArgumentChecks.ensureFinite("greenwichLongitude", greenwichLongitude);
        ArgumentChecks.ensureNonNull("angularUnit", angularUnit);
        this.greenwichLongitude = greenwichLongitude;
        this.angularUnit = angularUnit;
    }

    protected DefaultPrimeMeridian(PrimeMeridian meridian) {
        super(meridian);
        this.greenwichLongitude = meridian.getGreenwichLongitude();
        this.angularUnit = meridian.getAngularUnit();
    }

    public static DefaultPrimeMeridian castOrCopy(PrimeMeridian object) {
        return object == null || object instanceof DefaultPrimeMeridian ? (DefaultPrimeMeridian)object : new DefaultPrimeMeridian(object);
    }

    public Class<? extends PrimeMeridian> getInterface() {
        return PrimeMeridian.class;
    }

    @Override
    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit<Angle> unit) {
        return this.getAngularUnit().getConverterTo(unit).convert(this.getGreenwichLongitude());
    }

    @Override
    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            switch (mode) {
                case STRICT: {
                    DefaultPrimeMeridian that = (DefaultPrimeMeridian)object;
                    return Numerics.equals(this.greenwichLongitude, that.greenwichLongitude) && Objects.equals(this.angularUnit, that.angularUnit);
                }
                case BY_CONTRACT: {
                    PrimeMeridian that = (PrimeMeridian)object;
                    return Numerics.equals(this.getGreenwichLongitude(), that.getGreenwichLongitude()) && Objects.equals(this.getAngularUnit(), that.getAngularUnit());
                }
            }
            double v1 = this.getGreenwichLongitude(Units.DEGREE);
            double v2 = ReferencingUtilities.getGreenwichLongitude((PrimeMeridian)object, Units.DEGREE);
            if (mode == ComparisonMode.IGNORE_METADATA) {
                return Numerics.equals(v1, v2);
            }
            if (Numerics.epsilonEqual(v1, v2, 8.999280057595393E-8)) {
                return true;
            }
            assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference("greenwichLongitude", v1, v2);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.greenwichLongitude) + (long)Objects.hashCode(this.angularUnit);
    }

    private static boolean isElementOfBaseCRS(Formatter formatter) {
        return formatter.getEnclosingElement(2) instanceof GeneralDerivedCRS;
    }

    private static boolean beConservative(Formatter formatter, Unit<Angle> contextualUnit) {
        return !contextualUnit.equals(Units.DEGREE) && !DefaultPrimeMeridian.isElementOfBaseCRS(formatter);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Unit<Angle> contextualUnit;
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        Unit<Angle> unit = contextualUnit = formatter.toContextualUnit(Units.DEGREE);
        if (!isWKT1) {
            unit = this.getAngularUnit();
            if (convention != Convention.INTERNAL) {
                unit = WKTUtilities.toFormattable(unit);
            }
        }
        formatter.append(this.getGreenwichLongitude(unit));
        if (isWKT1) {
            return "PrimeM";
        }
        if (!convention.isSimplified() || !contextualUnit.equals(unit) || DefaultPrimeMeridian.beConservative(formatter, contextualUnit)) {
            formatter.append(unit);
        }
        return formatter.shortOrLong("PrimeM", "PrimeMeridian");
    }

    private DefaultPrimeMeridian() {
        super(NilReferencingObject.INSTANCE);
    }

    @XmlElement(name="greenwichLongitude", required=true)
    private Measure getGreenwichMeasure() {
        return new Measure(this.greenwichLongitude, this.angularUnit);
    }

    private void setGreenwichMeasure(Measure measure) {
        if (this.greenwichLongitude == 0.0 && this.angularUnit == null) {
            this.greenwichLongitude = measure.value;
            this.angularUnit = measure.getUnit(Angle.class);
            if (this.angularUnit == null) {
                this.angularUnit = Units.DEGREE;
                if (this.greenwichLongitude != 0.0) {
                    Measure.missingUOM(DefaultPrimeMeridian.class, "setGreenwichMeasure");
                }
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultPrimeMeridian.class, "setGreenwichMeasure", "greenwichLongitude");
        }
    }
}

