/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.Fallback;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class InstallationScriptProvider
extends InstallationResources {
    protected static final String PREPARE = "Prepare";
    protected static final String FINISH = "Finish";
    private final Set<String> authorities;
    private final String[] resources;

    protected InstallationScriptProvider(String authority, String ... resources) {
        ArgumentChecks.ensureNonNull("resources", resources);
        this.authorities = CollectionsExt.singletonOrEmpty(authority);
        this.resources = resources;
    }

    @Override
    public Set<String> getAuthorities() {
        return this.authorities;
    }

    private void verifyAuthority(String authority) {
        if (!this.authorities.contains(authority)) {
            throw new IllegalArgumentException(Errors.format((short)45, "authority", authority));
        }
    }

    @Override
    public String[] getResourceNames(String authority) throws IOException {
        this.verifyAuthority(authority);
        return (String[])this.resources.clone();
    }

    @Override
    public BufferedReader openScript(String authority, int resource) throws IOException {
        InputStream in;
        this.verifyAuthority(authority);
        ArgumentChecks.ensureValidIndex(this.resources.length, resource);
        if (!"EPSG".equals(authority)) {
            throw new IllegalStateException(Resources.format((short)66, authority));
        }
        Object name = this.resources[resource];
        if (PREPARE.equals(name) || FINISH.equals(name)) {
            name = authority + "_" + (String)name + ".sql";
            in = InstallationScriptProvider.class.getResourceAsStream((String)name);
        } else {
            in = this.openStream((String)name);
            name = ((String)name).concat(".sql");
        }
        if (in == null) {
            throw new FileNotFoundException(Errors.format((short)39, name));
        }
        return new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    protected abstract InputStream openStream(String var1) throws IOException;

    static void log(LogRecord record) {
        Logging.completeAndLog(EPSGDataAccess.LOGGER, EPSGFactory.class, "install", record);
    }

    @Fallback
    static final class Default
    extends InstallationScriptProvider {
        private Path directory;
        private static final int FIRST_FILE = 1;

        Default(Locale locale) throws IOException {
            super("EPSG", InstallationScriptProvider.PREPARE, "Tables", "Data", "FKeys", InstallationScriptProvider.FINISH);
            Path dir = DataDirectory.DATABASES.getDirectory();
            if (dir != null && Files.isDirectory(dir = dir.resolve("ExternalSources"), new LinkOption[0])) {
                String[] resources = this.resources;
                String[] found = new String[resources.length - 1 - 1];
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "EPSG_*.sql");){
                    for (Path path : stream) {
                        String name = path.getFileName().toString();
                        for (int i = 0; i < found.length; ++i) {
                            String part = resources[1 + i];
                            if (!name.contains(part)) continue;
                            if (found[i] != null) {
                                Default.log(Errors.getResources(locale).getLogRecord(Level.WARNING, (short)186, part));
                                return;
                            }
                            found[i] = name;
                        }
                    }
                }
                for (int i = 0; i < found.length; ++i) {
                    String file = found[i];
                    if (file != null) {
                        resources[1 + i] = file;
                        continue;
                    }
                    dir = null;
                }
                this.directory = dir;
            }
        }

        @Override
        public Set<String> getAuthorities() {
            return this.directory != null ? super.getAuthorities() : Set.of();
        }

        @Override
        public String getLicense(String authority, Locale locale, String mimeType) {
            return null;
        }

        @Override
        protected InputStream openStream(String name) throws IOException {
            return this.directory != null ? Files.newInputStream(this.directory.resolve(name), new OpenOption[0]) : null;
        }
    }
}

