/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class UnmodifiableMatrix
extends MatrixSIS
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 7239828819464047564L;
    final Matrix matrix;

    UnmodifiableMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    final ExtendedPrecisionMatrix asExtendePrecision() {
        return this.matrix instanceof ExtendedPrecisionMatrix ? (ExtendedPrecisionMatrix)this.matrix : this;
    }

    @Override
    public int getNumRow() {
        return this.matrix.getNumRow();
    }

    @Override
    public int getNumCol() {
        return this.matrix.getNumCol();
    }

    @Override
    public boolean isIdentity() {
        return this.matrix.isIdentity();
    }

    @Override
    public double getElement(int row, int column) {
        return this.matrix.getElement(row, column);
    }

    @Override
    public double[] getElements() {
        if (this.matrix instanceof MatrixSIS) {
            return ((MatrixSIS)this.matrix).getElements();
        }
        return super.getElements();
    }

    @Override
    public Number[] getElementAsNumbers(boolean writable) {
        if (this.matrix instanceof ExtendedPrecisionMatrix) {
            return ((ExtendedPrecisionMatrix)this.matrix).getElementAsNumbers(writable);
        }
        return ExtendedPrecisionMatrix.super.getElementAsNumbers(writable);
    }

    @Override
    public Number getElementOrNull(int row, int column) {
        if (this.matrix instanceof ExtendedPrecisionMatrix) {
            return ((ExtendedPrecisionMatrix)this.matrix).getElementOrNull(row, column);
        }
        double element = this.matrix.getElement(row, column);
        return element != 0.0 ? Double.valueOf(element) : null;
    }

    private UnsupportedOperationException canNotModify() {
        return new UnsupportedOperationException(Errors.format((short)153, this.getClass()));
    }

    @Override
    public void setElements(double[] elements) {
        throw this.canNotModify();
    }

    @Override
    public void setElement(int row, int column, double value) {
        throw this.canNotModify();
    }

    @Override
    public void transpose() {
        throw this.canNotModify();
    }

    @Override
    public MatrixSIS clone() {
        return UnmodifiableMatrix.castOrCopy(this.matrix.clone());
    }
}

