/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedFeatureSet;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureType;
import org.opengis.feature.Operation;
import org.opengis.feature.PropertyType;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ComparisonOperator;
import org.opengis.filter.Expression;
import org.opengis.filter.FilterFactory;
import org.opengis.util.GenericName;

public class JoinFeatureSet
extends AggregatedFeatureSet {
    private final FeatureType type;
    public final FeatureSet left;
    public final FeatureSet right;
    private final String leftName;
    private final String rightName;
    private final boolean swapSides;
    private final boolean isOuterJoin;
    public final BinaryComparisonOperator<Feature> condition;
    private final FilterFactory<Feature, ?, ?> factory;

    public JoinFeatureSet(Resource parent, FeatureSet left, String leftAlias, FeatureSet right, String rightAlias, Type joinType, BinaryComparisonOperator<Feature> condition, Map<String, ?> featureInfo) throws DataStoreException {
        super(parent);
        FeatureType leftType = left.getType();
        FeatureType rightType = right.getType();
        GenericName leftName = leftType.getName();
        GenericName rightName = rightType.getName();
        if (leftAlias == null) {
            leftAlias = leftName.toString();
        }
        if (rightAlias == null) {
            rightAlias = rightName.toString();
        }
        this.left = left;
        this.right = right;
        this.leftName = leftAlias;
        this.rightName = rightAlias;
        this.swapSides = joinType.swapSides;
        this.isOuterJoin = joinType.isOuterJoin;
        this.condition = condition;
        this.factory = DefaultFilterFactory.forFeatures();
        PropertyType[] properties = new PropertyType[]{new DefaultAssociationRole(JoinFeatureSet.properties(leftAlias), leftType, joinType.minimumOccurs(false), 1), new DefaultAssociationRole(JoinFeatureSet.properties(rightAlias), rightType, joinType.minimumOccurs(true), 1)};
        String identifierDelimiter = Containers.property(featureInfo, "identifierDelimiter", String.class);
        if (identifierDelimiter != null && AttributeConvention.hasIdentifier(leftType) && AttributeConvention.hasIdentifier(rightType)) {
            Operation identifier = FeatureOperations.compound(JoinFeatureSet.properties(AttributeConvention.IDENTIFIER_PROPERTY), identifierDelimiter, Containers.property(featureInfo, "identifierPrefix", String.class), Containers.property(featureInfo, "identifierSuffix", String.class), properties);
            properties = ArraysExt.insert(properties, 0, 1);
            properties[0] = identifier;
        }
        if (featureInfo == null) {
            featureInfo = JoinFeatureSet.properties(leftName.tip().toString() + "-" + String.valueOf(rightName.tip()));
        }
        this.type = new DefaultFeatureType(featureInfo, false, null, properties);
    }

    private static Map<String, ?> properties(Object name) {
        return Map.of("name", name);
    }

    final List<FeatureSet> dependencies() {
        Object[] sets = new FeatureSet[]{this.left, this.right};
        if (this.swapSides) {
            ArraysExt.swap(sets, 0, 1);
        }
        return Arrays.asList(sets);
    }

    public Type getJoinType() {
        return Type.valueOf(this.isOuterJoin, this.swapSides);
    }

    @Override
    public FeatureType getType() {
        return this.type;
    }

    @Override
    public Stream<Feature> features(boolean parallel) throws DataStoreException {
        Iterator it = new Iterator();
        return (Stream)StreamSupport.stream(it, parallel).onClose(it);
    }

    private Feature join(Feature main, Feature filtered) {
        if (this.swapSides) {
            Feature t2 = main;
            main = filtered;
            filtered = t2;
        }
        Feature f = this.type.newInstance();
        f.setPropertyValue(this.leftName, main);
        f.setPropertyValue(this.rightName, filtered);
        return f;
    }

    public static enum Type {
        INNER(false, false),
        LEFT_OUTER(true, false),
        RIGHT_OUTER(true, true);

        final boolean isOuterJoin;
        final boolean swapSides;

        private Type(boolean isOuterJoin, boolean swapSides) {
            this.isOuterJoin = isOuterJoin;
            this.swapSides = swapSides;
        }

        final int minimumOccurs(boolean right) {
            return !this.isOuterJoin | this.swapSides == right ? 1 : 0;
        }

        static Type valueOf(boolean isOuterJoin, boolean swapSides) {
            return isOuterJoin ? (swapSides ? RIGHT_OUTER : LEFT_OUTER) : INNER;
        }
    }

    private final class Iterator
    implements Spliterator<Feature>,
    Consumer<Feature>,
    Runnable {
        private Runnable mainCloseHandler;
        private final Spliterator<Feature> mainIterator;
        private Feature mainFeature;
        private Stream<Feature> filteredStream;
        private Spliterator<Feature> filteredIterator;
        private Feature filteredFeature;

        Iterator() throws DataStoreException {
            Stream<Feature> mainStream = (JoinFeatureSet.this.swapSides ? JoinFeatureSet.this.right : JoinFeatureSet.this.left).features(false);
            this.mainCloseHandler = mainStream::close;
            this.mainIterator = mainStream.spliterator();
        }

        private Iterator(Spliterator<Feature> it) {
            this.mainIterator = it;
        }

        @Override
        public Spliterator<Feature> trySplit() {
            Spliterator<Feature> s2 = this.mainIterator.trySplit();
            if (s2 == null) {
                return null;
            }
            Iterator it = new Iterator(s2);
            it.mainCloseHandler = this.mainCloseHandler;
            this.mainCloseHandler = it;
            return it;
        }

        @Override
        public int characteristics() {
            return this.mainIterator.characteristics() & 0x10 | 0x100;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public void run() {
            this.closeFilteredIterator();
            Runnable toClose = this.mainCloseHandler;
            if (toClose != null) {
                this.mainCloseHandler = null;
                toClose.run();
            }
        }

        private void closeFilteredIterator() {
            Stream<Feature> stream = this.filteredStream;
            this.filteredStream = null;
            this.filteredIterator = null;
            this.filteredFeature = null;
            this.mainFeature = null;
            if (stream != null) {
                stream.close();
            }
        }

        private void createFilteredIterator() {
            FeatureSet filteredSet;
            Expression<Feature, ?> expression2;
            Expression<Feature, ?> expression1;
            if (JoinFeatureSet.this.swapSides) {
                expression1 = JoinFeatureSet.this.condition.getOperand2();
                expression2 = JoinFeatureSet.this.condition.getOperand1();
                filteredSet = JoinFeatureSet.this.left;
            } else {
                expression1 = JoinFeatureSet.this.condition.getOperand1();
                expression2 = JoinFeatureSet.this.condition.getOperand2();
                filteredSet = JoinFeatureSet.this.right;
            }
            Object mainValue = expression1.apply(this.mainFeature);
            ComparisonOperator<Feature> filter = mainValue != null ? JoinFeatureSet.this.factory.equal(expression2, JoinFeatureSet.this.factory.literal(mainValue), JoinFeatureSet.this.condition.isMatchingCase(), JoinFeatureSet.this.condition.getMatchAction()) : JoinFeatureSet.this.factory.isNull(expression2);
            FeatureQuery query = new FeatureQuery();
            query.setSelection(filter);
            try {
                this.filteredStream = filteredSet.subset(query).features(false);
            }
            catch (DataStoreException e) {
                throw new BackingStoreException(e);
            }
            this.filteredIterator = this.filteredStream.spliterator();
        }

        @Override
        public void forEachRemaining(Consumer<? super Feature> action) {
            Consumer<Feature> forFiltered = feature -> {
                if (feature != null) {
                    this.filteredFeature = feature;
                    action.accept(JoinFeatureSet.this.join(this.mainFeature, this.filteredFeature));
                }
            };
            Consumer<Feature> forMain = feature -> {
                if (feature != null) {
                    this.mainFeature = feature;
                    this.createFilteredIterator();
                    this.filteredIterator.forEachRemaining(forFiltered);
                    boolean none = this.filteredFeature == null;
                    this.closeFilteredIterator();
                    if (none && JoinFeatureSet.this.isOuterJoin) {
                        action.accept(JoinFeatureSet.this.join((Feature)feature, null));
                    }
                }
            };
            forMain.accept(this.mainFeature);
            this.mainIterator.forEachRemaining(forMain);
        }

        @Override
        public void accept(Feature feature) {
            this.filteredFeature = feature;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Feature> action) {
            Feature feature;
            boolean none;
            do {
                if (this.mainFeature == null) {
                    do {
                        if (this.mainIterator.tryAdvance(this)) continue;
                        return false;
                    } while (this.filteredFeature == null);
                    this.mainFeature = this.filteredFeature;
                    this.filteredFeature = null;
                }
                if (this.filteredIterator == null) {
                    this.createFilteredIterator();
                }
                boolean bl = none = this.filteredFeature == null;
                while (this.filteredIterator.tryAdvance(this)) {
                    if (this.filteredFeature == null) continue;
                    action.accept(JoinFeatureSet.this.join(this.mainFeature, this.filteredFeature));
                    return true;
                }
                feature = this.mainFeature;
                this.closeFilteredIterator();
            } while (!none || !JoinFeatureSet.this.isOuterJoin);
            action.accept(JoinFeatureSet.this.join(feature, null));
            return true;
        }
    }
}

