/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.AbstractName;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.iso.GlobalNameSpace;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public class DefaultNameSpace
implements NameSpace,
Serializable {
    private static final long serialVersionUID = 8272640747799127007L;
    public static final char DEFAULT_SEPARATOR = ':';
    static final String DEFAULT_SEPARATOR_STRING = ":";
    private final DefaultNameSpace parent;
    private final CharSequence name;
    private final String headSeparator;
    final String separator;
    private transient AbstractName path;
    private transient WeakValueHashMap<String, Object> childs;

    DefaultNameSpace() {
        this.parent = null;
        this.name = "global";
        this.headSeparator = DEFAULT_SEPARATOR_STRING;
        this.separator = DEFAULT_SEPARATOR_STRING;
        this.init();
    }

    protected DefaultNameSpace(DefaultNameSpace parent, CharSequence name, String headSeparator, String separator) {
        this.parent = parent != GlobalNameSpace.GLOBAL ? parent : null;
        ArgumentChecks.ensureNonNull("name", name);
        ArgumentChecks.ensureNonNull("headSeparator", headSeparator);
        ArgumentChecks.ensureNonNull("separator", separator);
        this.name = DefaultNameSpace.simplify(name);
        this.headSeparator = headSeparator;
        this.separator = separator;
        this.init();
    }

    private static CharSequence simplify(CharSequence name) {
        if (!(name instanceof InternationalString) || name.getClass() == SimpleInternationalString.class) {
            name = name.toString();
        }
        return name;
    }

    private void init() {
        this.childs = new WeakValueHashMap(String.class);
    }

    static DefaultNameSpace castOrCopy(NameSpace ns) {
        if (ns == null) {
            return GlobalNameSpace.GLOBAL;
        }
        if (ns instanceof DefaultNameSpace) {
            return (DefaultNameSpace)ns;
        }
        return DefaultNameSpace.forName(ns.name(), DEFAULT_SEPARATOR_STRING, DEFAULT_SEPARATOR_STRING);
    }

    static DefaultNameSpace forName(GenericName name, String headSeparator, String separator) {
        NameSpace scope;
        if (name == null) {
            return null;
        }
        List<? extends LocalName> parsedNames = name.getParsedNames();
        ListIterator<? extends LocalName> it = parsedNames.listIterator(parsedNames.size());
        do {
            if (it.hasPrevious()) continue;
            scope = GlobalNameSpace.GLOBAL;
            break;
        } while (!((scope = it.previous().scope()) instanceof DefaultNameSpace));
        DefaultNameSpace ns = scope;
        while (it.hasNext()) {
            LocalName tip = it.next();
            ns = ns.child(tip.toString(), tip.toInternationalString(), headSeparator, separator);
        }
        return ns;
    }

    public static String getSeparator(NameSpace ns, boolean head) {
        if (ns instanceof DefaultNameSpace) {
            DefaultNameSpace ds = (DefaultNameSpace)ns;
            return head ? ds.headSeparator : ds.separator;
        }
        return DEFAULT_SEPARATOR_STRING;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    final DefaultNameSpace parent() {
        return this.parent != null ? this.parent : GlobalNameSpace.GLOBAL;
    }

    private static int depth(DefaultNameSpace ns) {
        int depth = 0;
        if (ns != null) {
            do {
                ++depth;
            } while ((ns = ns.parent) != null && !ns.isGlobal());
        }
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericName name() {
        int depth;
        DefaultNameSpace defaultNameSpace = this;
        synchronized (defaultNameSpace) {
            if (this.path != null) {
                return this.path;
            }
            depth = DefaultNameSpace.depth(this);
            DefaultLocalName[] names = new DefaultLocalName[depth];
            DefaultNameSpace scan = this;
            int i = depth;
            while (--i >= 0) {
                names[i] = new DefaultLocalName(scan.parent, scan.name);
                scan = scan.parent;
            }
            assert (DefaultNameSpace.depth(scan) == 0 || scan.isGlobal());
            AbstractName truncated = this.path = DefaultScopedName.create(UnmodifiableArrayList.wrap(names));
            int i2 = depth;
            while (--i2 >= 0) {
                names[i2].fullyQualified = truncated;
                truncated = truncated instanceof ScopedName ? ((ScopedName)((Object)truncated)).path() : null;
            }
        }
        AbstractName truncated = this.path;
        DefaultNameSpace scan = this.parent;
        while (scan != null && !scan.isGlobal()) {
            truncated = (AbstractName)((ScopedName)((Object)truncated)).path();
            DefaultNameSpace defaultNameSpace2 = scan;
            synchronized (defaultNameSpace2) {
                if (scan.path == null || scan.path.arraySize() < depth) {
                    scan.path = truncated;
                }
            }
            scan = scan.parent;
        }
        return this.path;
    }

    final DefaultNameSpace child(CharSequence name, String sep) {
        return this.child(DefaultNameSpace.key(name), name, sep, sep);
    }

    private static String key(CharSequence name) {
        return name instanceof InternationalString ? ((InternationalString)name).toString(Locale.ROOT) : name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultNameSpace child(String key, CharSequence name, String headSeparator, String separator) {
        DefaultNameSpace child;
        WeakValueHashMap<String, Object> childs;
        ArgumentChecks.ensureNonNull("key", key);
        name = name == null ? key : DefaultNameSpace.simplify(name);
        WeakValueHashMap<String, Object> weakValueHashMap = childs = this.childs;
        synchronized (weakValueHashMap) {
            Object existing = childs.get(key);
            if (existing instanceof DefaultNameSpace) {
                child = (DefaultNameSpace)existing;
                if (!(child.separator.equals(separator) && child.headSeparator.equals(headSeparator) && child.name.equals(name))) {
                    child = new DefaultNameSpace(this, name, headSeparator, separator);
                }
            } else {
                child = new DefaultNameSpace(this, name, headSeparator, separator);
                if (childs.put(key, child) != existing) {
                    throw new AssertionError();
                }
            }
        }
        assert (child.parent() == this);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DefaultLocalName local(CharSequence name, DefaultLocalName candidate) {
        DefaultLocalName child;
        WeakValueHashMap<String, Object> childs;
        ArgumentChecks.ensureNonNull("name", name);
        String key = name.toString();
        WeakValueHashMap<String, Object> weakValueHashMap = childs = this.childs;
        synchronized (weakValueHashMap) {
            Object existing = childs.get(key);
            if (existing instanceof DefaultLocalName) {
                child = (DefaultLocalName)existing;
                if (DefaultNameSpace.simplify(name).equals(child.name)) {
                    assert ((child.scope != null ? child.scope : GlobalNameSpace.GLOBAL) == this);
                    return child;
                }
            }
            child = candidate != null ? candidate : new DefaultLocalName(this, name);
            if (!(existing instanceof DefaultNameSpace) && childs.put(key, child) != existing) {
                throw new AssertionError();
            }
        }
        return child;
    }

    public String toString() {
        return new StringBuilder(this.name.length() + 2).append('{').append(this.name).append('}').toString();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DefaultNameSpace that = (DefaultNameSpace)object;
            return this.equalsIgnoreParent(that) && Objects.equals(this.parent, that.parent);
        }
        return false;
    }

    private boolean equalsIgnoreParent(DefaultNameSpace that) {
        return Objects.equals(this.headSeparator, that.headSeparator) && Objects.equals(this.separator, that.separator) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readResolve() throws ObjectStreamException {
        WeakValueHashMap<String, Object> pool;
        DefaultNameSpace p = this.parent();
        String key = DefaultNameSpace.key(this.name);
        WeakValueHashMap<String, Object> weakValueHashMap = pool = p.childs;
        synchronized (weakValueHashMap) {
            Object existing = pool.get(key);
            if (existing instanceof DefaultNameSpace) {
                if (this.equalsIgnoreParent((DefaultNameSpace)existing)) {
                    return existing;
                }
            } else {
                this.init();
                if (pool.put(key, this) != existing) {
                    throw new AssertionError();
                }
                return this;
            }
        }
        this.init();
        return this;
    }
}

