/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry;

import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSSurfacePatch;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.complex.Composite;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.PrimitiveBoundary;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfaceInterpolation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlType(name="PolygonType", namespace="http://www.opengis.net/gml")
public class JTSPolygon
extends JTSSurfacePatch
implements Polygon,
Primitive {
    private List spanningSurface;

    public JTSPolygon() {
        this((SurfaceBoundary)null, (List)null);
    }

    public JTSPolygon(SurfaceBoundary boundary) {
        this(boundary, null);
    }

    public JTSPolygon(SurfaceBoundary boundary, List spanningSurface) {
        super(SurfaceInterpolation.PLANAR, boundary);
        this.spanningSurface = spanningSurface;
    }

    @Override
    public int getNumDerivativesOnBoundary() {
        return 0;
    }

    @Override
    public Geometry computeJTSPeer() {
        PrimitiveBoundary boundary = this.getBoundary();
        Ring exterior = boundary.getExterior();
        List<Ring> interiors = boundary.getInteriors();
        if (exterior != null) {
            Geometry g2 = ((JTSGeometry)((Object)exterior)).getJTSGeometry();
            int numHoles = interiors != null ? interiors.size() : 0;
            LinearRing jtsExterior = JTSUtils.GEOMETRY_FACTORY.createLinearRing(g2.getCoordinates());
            LinearRing[] jtsInterior = new LinearRing[numHoles];
            for (int i = 0; i < numHoles; ++i) {
                Geometry g22 = ((JTSGeometry)((Object)interiors.get(i))).getJTSGeometry();
                jtsInterior[i] = JTSUtils.GEOMETRY_FACTORY.createLinearRing(g22.getCoordinates());
            }
            org.locationtech.jts.geom.Polygon result = JTSUtils.GEOMETRY_FACTORY.createPolygon(jtsExterior, jtsInterior);
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
            if (crs != null) {
                int srid = SRIDGenerator.toSRID(crs, SRIDGenerator.Version.V1);
                result.setSRID(srid);
            }
            return result;
        }
        return null;
    }

    @Override
    public PolyhedralSurface getSurface() {
        return (PolyhedralSurface)super.getSurface();
    }

    public List getSpanningSurface() {
        return this.spanningSurface;
    }

    public boolean isValid() {
        org.locationtech.jts.geom.Polygon poly = (org.locationtech.jts.geom.Polygon)this.getJTSGeometry();
        return poly.isValid();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JTSPolygon && super.equals(object)) {
            JTSPolygon that = (JTSPolygon)object;
            return Objects.equals(this.spanningSurface, that.spanningSurface);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 59 * hash + (this.spanningSurface != null ? this.spanningSurface.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.spanningSurface != null) {
            sb.append("spanningSurface:").append('\n');
            for (Object o : this.spanningSurface) {
                sb.append(o).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public Set<Primitive> getContainedPrimitives() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Primitive> getContainingPrimitives() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Complex> getComplexes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Composite getComposite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OrientablePrimitive[] getProxy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

