/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSSurfacePatch;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.complex.CompositeSurface;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSSurface
extends AbstractJTSGeometry
implements Surface {
    protected List<JTSSurfacePatch> patches = new ArrayList<JTSSurfacePatch>();

    public JTSSurface() {
        this(null);
    }

    public JTSSurface(CoordinateReferenceSystem crs) {
        super(crs);
    }

    public List<JTSSurfacePatch> getPatches() {
        return this.patches;
    }

    @Override
    public SurfaceBoundary getBoundary() {
        return (SurfaceBoundary)super.getBoundary();
    }

    @Override
    public double[] getUpNormal(DirectPosition point) {
        return new double[]{0.0, 0.0, 1.0};
    }

    @Override
    public double getPerimeter() {
        return this.getJTSGeometry().getBoundary().getLength();
    }

    @Override
    public double getArea() {
        return this.getJTSGeometry().getArea();
    }

    @Override
    public CompositeSurface getComposite() {
        return null;
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public Surface getPrimitive() {
        return this;
    }

    public Set getComplexes() {
        return null;
    }

    public Set getContainingPrimitives() {
        return null;
    }

    @Override
    public OrientableSurface[] getProxy() {
        return null;
    }

    public Set getContainedPrimitives() {
        return null;
    }

    @Override
    protected Geometry computeJTSPeer() {
        if (this.patches.size() > 1) {
            Polygon[] polygons = new Polygon[this.patches.size()];
            for (int i = 0; i < this.patches.size(); ++i) {
                JTSGeometry jtsGeometry = this.patches.get(i);
                polygons[i] = (Polygon)jtsGeometry.getJTSGeometry();
            }
            return JTSUtils.GEOMETRY_FACTORY.createMultiPolygon(polygons);
        }
        return ((JTSGeometry)this.patches.get(0)).getJTSGeometry();
    }
}

