/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Vector;

public class Vector3f
implements Vector {
    public float x;
    public float y;
    public float z;

    public Vector3f() {
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public double get(int indice) {
        switch (indice) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index " + indice);
    }

    @Override
    public void set(int indice, double value) {
        switch (indice) {
            case 0: {
                this.x = (float)value;
                break;
            }
            case 1: {
                this.y = (float)value;
                break;
            }
            case 2: {
                this.z = (float)value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index " + indice);
            }
        }
    }

    @Override
    public void set(double[] values) {
        if (this.getDimension() != values.length) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + values.length);
        }
        this.x = (float)values[0];
        this.y = (float)values[1];
        this.z = (float)values[2];
    }

    public void set(Tuple v) {
        if (this.getDimension() != v.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + v.getDimension());
        }
        this.x = (float)v.get(0);
        this.y = (float)v.get(1);
        this.z = (float)v.get(2);
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double lengthSquare() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public void normalize() {
        double s2 = 1.0 / this.length();
        this.x = (float)((double)this.x * s2);
        this.y = (float)((double)this.y * s2);
        this.z = (float)((double)this.z * s2);
    }

    @Override
    public void add(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x = (float)((double)this.x + other.get(0));
        this.y = (float)((double)this.y + other.get(1));
        this.z = (float)((double)this.z + other.get(2));
    }

    @Override
    public void subtract(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x = (float)((double)this.x - other.get(0));
        this.y = (float)((double)this.y - other.get(1));
        this.z = (float)((double)this.z - other.get(2));
    }

    @Override
    public void scale(double scale) {
        this.x = (float)((double)this.x * scale);
        this.y = (float)((double)this.y * scale);
        this.z = (float)((double)this.z * scale);
    }

    @Override
    public int[] toArrayInt() {
        return new int[]{(int)this.x, (int)this.y, (int)this.z};
    }

    @Override
    public float[] toArrayFloat() {
        return new float[]{this.x, this.y, this.z};
    }

    @Override
    public double[] toArrayDouble() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public void toArrayInt(int[] buffer, int offset) {
        buffer[offset] = (int)this.x;
        buffer[offset + 1] = (int)this.y;
        buffer[offset + 2] = (int)this.z;
    }

    @Override
    public void toArrayFloat(float[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
        buffer[offset + 2] = this.z;
    }

    @Override
    public void toArrayDouble(double[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
        buffer[offset + 2] = this.z;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.toArrayDouble());
    }
}

