/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DirectPositionType", propOrder={"value"})
public class DirectPositionType
implements DirectPosition {
    @XmlValue
    private List<Double> value;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    private Integer srsDimension;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String srsName;
    @XmlAttribute
    private List<String> axisLabels;
    @XmlAttribute
    private List<String> uomLabels;

    DirectPositionType() {
    }

    public DirectPositionType(String srsName, Integer srsDimension, List<String> axisLabels, List<Double> value, List<String> uomLabels) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.axisLabels = axisLabels;
        this.value = value;
        this.uomLabels = uomLabels;
    }

    public DirectPositionType(String srsName, Integer srsDimension, List<String> axisLabels, List<Double> value) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.axisLabels = axisLabels;
        this.value = value;
    }

    public DirectPositionType(String srsName, Integer srsDimension, List<Double> value) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.value = value;
    }

    public DirectPositionType(List<Double> value) {
        this.value = value;
        this.srsDimension = null;
    }

    public DirectPositionType(double ... values) {
        this.value = new ArrayList<Double>();
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double pt = dArray[i];
            if (pt == null || pt.equals(Double.NaN)) continue;
            this.value.add(pt);
        }
        this.srsDimension = null;
    }

    public DirectPositionType(org.opengis.geometry.DirectPosition position) {
        this(position, true);
    }

    public DirectPositionType(org.opengis.geometry.DirectPosition position, boolean srsInfo) {
        if (position != null) {
            this.value = new ArrayList<Double>();
            for (double d : position.getCoordinate()) {
                this.value.add(d);
            }
            if (srsInfo) {
                CoordinateReferenceSystem crs = position.getCoordinateReferenceSystem();
                if (crs != null) {
                    try {
                        this.srsName = IdentifiedObjects.lookupURN(crs, null);
                    }
                    catch (FactoryException ex) {
                        Logger.getLogger("org.geotoolkit.gml.xml.v311").log(Level.WARNING, null, ex);
                    }
                }
                this.srsDimension = position.getDimension();
            }
        }
    }

    @Override
    public List<Double> getValue() {
        if (this.value == null) {
            this.value = new ArrayList<Double>();
        }
        return this.value;
    }

    public void setValue(List<Double> value) {
        this.value = value;
    }

    public void setValue(Double value) {
        if (this.value == null) {
            this.value = new ArrayList<Double>();
        }
        this.value.add(value);
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String value) {
        this.srsName = value;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    @Override
    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.srsName != null) {
            try {
                return CRS.forCode(this.srsName);
            }
            catch (FactoryException ex) {
                Logger.getLogger("org.geotoolkit.gml.xml.v311").log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    @Override
    public int getDimension() {
        if (this.srsDimension != null) {
            return this.srsDimension;
        }
        return this.value.size();
    }

    @Override
    public double[] getCoordinate() {
        double[] coords = new double[this.value.size()];
        int n = this.value.size();
        for (int i = 0; i < n; ++i) {
            coords[i] = this.value.get(i);
        }
        return coords;
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.value.get(dimension);
    }

    @Override
    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.value.remove(dimension);
        this.value.add(dimension, value);
    }

    @Override
    public org.opengis.geometry.DirectPosition getDirectPosition() {
        return this;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("[DirectPositionType]:");
        if (this.srsName != null) {
            s2.append("srsName = ").append(this.srsName).append('\n');
        }
        if (this.srsDimension != null) {
            s2.append(" srsDimension = ").append(this.srsDimension).append('\n');
        }
        if (this.value != null) {
            s2.append(" value: ").append('\n');
            Iterator<Object> iterator = this.value.iterator();
            while (iterator.hasNext()) {
                double v = (Double)iterator.next();
                s2.append(v).append(", ");
            }
        }
        if (this.axisLabels != null) {
            s2.append(" axisLabels: ").append('\n');
            for (String v : this.axisLabels) {
                s2.append(v).append(", ");
            }
        }
        if (this.uomLabels != null) {
            s2.append(" uomLabels: ").append('\n');
            for (String v : this.uomLabels) {
                s2.append(v).append(", ");
            }
        }
        return s2.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DirectPositionType) {
            DirectPositionType that = (DirectPositionType)object;
            return Utilities.listNullEquals(this.axisLabels, that.axisLabels) && Objects.equals(this.srsDimension, that.srsDimension) && Objects.equals(this.srsName, that.srsName) && Utilities.listNullEquals(this.uomLabels, that.uomLabels) && Objects.equals(this.value, that.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 71 * hash + (this.srsDimension != null ? this.srsDimension : 0);
        hash = 71 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 71 * hash + (this.axisLabels != null ? this.axisLabels.hashCode() : 0);
        hash = 71 * hash + (this.uomLabels != null ? this.uomLabels.hashCode() : 0);
        return hash;
    }
}

