/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Objects;
import org.geotoolkit.gml.xml.v321.AngleType;
import org.geotoolkit.gml.xml.v321.AreaType;
import org.geotoolkit.gml.xml.v321.GridLengthType;
import org.geotoolkit.gml.xml.v321.LengthType;
import org.geotoolkit.gml.xml.v321.Quantity;
import org.geotoolkit.gml.xml.v321.ScaleType;
import org.geotoolkit.gml.xml.v321.SpeedType;
import org.geotoolkit.gml.xml.v321.TimeType;
import org.geotoolkit.gml.xml.v321.VolumeType;
import org.opengis.observation.BaseUnit;
import org.opengis.observation.Measure;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"value"})
@XmlSeeAlso(value={LengthType.class, AngleType.class, Quantity.class, VolumeType.class, GridLengthType.class, SpeedType.class, ScaleType.class, AreaType.class, TimeType.class})
public class MeasureType
implements Measure {
    @XmlValue
    private double value;
    @XmlAttribute(required=true)
    private String uom;

    public MeasureType() {
    }

    public MeasureType(String uom, double value) {
        this.uom = uom;
        this.value = value;
    }

    @Override
    public float getValue() {
        return (float)this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public BaseUnit getUom() {
        return null;
    }

    public String getUomStr() {
        return this.uom;
    }

    public void setUom(String value) {
        this.uom = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MeasureType)) return false;
        MeasureType that = (MeasureType)object;
        if (!Objects.equals(this.uom, that.uom)) return false;
        if (!Objects.equals(this.value, that.value)) return false;
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        hash = 89 * hash + Objects.hashCode(this.uom);
        return hash;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("[MeasureType]");
        if (this.uom != null) {
            s2.append("uom =").append(this.uom).append('\n');
        }
        s2.append(" value=").append(this.value).append('\n');
        return s2.toString();
    }
}

