/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.nio;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Console;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Errors;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.nio.CopyFileVisitor;

public final class IOUtilities
extends Static {
    private static final Logger LOGGER = Logger.getLogger("org.geotoolkit.io");
    private static final int BUFFER_SIZE = 8192;
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static Writer stdout;
    private static PrintWriter printer;
    private static final Set<Path> DELETE_ON_EXIT_PATHS;

    private IOUtilities() {
    }

    public static void deleteOnExit(Path path) {
        DELETE_ON_EXIT_PATHS.add(path);
    }

    public static synchronized Writer standardWriter() {
        if (stdout == null) {
            Console console = System.console();
            if (console != null) {
                printer = console.writer();
                stdout = printer;
            } else {
                stdout = new OutputStreamWriter(System.out);
            }
        }
        return stdout;
    }

    public static synchronized PrintWriter standardPrintWriter() {
        if (printer == null) {
            Writer writer = IOUtilities.standardWriter();
            if (printer == null) {
                printer = new PrintWriter(writer, true);
            }
        }
        return printer;
    }

    public static Path commonParent(Path root, Path file) {
        while (root != null) {
            Path nfile;
            root = root.normalize();
            if (file == null) continue;
            for (Path candidate = nfile = file.normalize(); candidate != null; candidate = candidate.getParent()) {
                if (!root.equals(candidate)) continue;
                return root;
            }
            root = root.getParent();
        }
        return null;
    }

    public static Object tryToFile(Object path) throws IOException {
        if (path == null) {
            return null;
        }
        if (path instanceof File) {
            return (File)path;
        }
        if (path instanceof CharSequence) {
            return org.apache.sis.internal.storage.io.IOUtilities.toFileOrURL(path.toString(), null);
        }
        if (path instanceof URL) {
            URL url = (URL)path;
            if (url.getProtocol().equalsIgnoreCase("file")) {
                return org.apache.sis.internal.storage.io.IOUtilities.toFile(url, null);
            }
        } else if (path instanceof URI) {
            URI uri = (URI)path;
            String scheme = uri.getScheme();
            if (scheme != null && scheme.equalsIgnoreCase("file")) {
                try {
                    return new File(uri);
                }
                catch (IllegalArgumentException cause) {
                    MalformedURLException e = new MalformedURLException(IOUtilities.concatenate(org.geotoolkit.resources.Errors.format((short)53, "URI", path), cause));
                    e.initCause(cause);
                    throw e;
                }
            }
        } else if (path instanceof Path) {
            return ((Path)path).toFile();
        }
        return path;
    }

    public static Object tryToPath(Object path) {
        try {
            return IOUtilities.toPath(path);
        }
        catch (IOException | IllegalArgumentException ex) {
            return path;
        }
    }

    public static Path toPath(Object candidate) throws IOException, IllegalArgumentException {
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof Path) {
            return (Path)candidate;
        }
        if (candidate instanceof CharSequence) {
            URI uri = URI.create(IOUtilities.toSafeURI(String.valueOf(candidate)));
            if (uri.getScheme() != null) {
                return Paths.get(uri);
            }
            return Paths.get(candidate.toString(), new String[0]);
        }
        if (candidate instanceof URL) {
            URL url = (URL)candidate;
            return org.apache.sis.internal.storage.io.IOUtilities.toPath(url, null);
        }
        if (candidate instanceof File) {
            return ((File)candidate).toPath();
        }
        if (candidate instanceof URI) {
            URI uri = (URI)candidate;
            try {
                if (uri.getScheme() == null) {
                    return Paths.get(uri.toString(), new String[0]);
                }
                return Paths.get(uri);
            }
            catch (IllegalArgumentException | FileSystemNotFoundException cause) {
                IOException e;
                String message = Exceptions.formatChainedMessages(null, Errors.format((short)45, "URI", uri), cause);
                if (cause instanceof IllegalArgumentException) {
                    e = new MalformedURLException(message);
                    e.initCause(cause);
                } else {
                    e = new IOException(message, cause);
                }
                throw e;
            }
        }
        throw new IllegalArgumentException("Can't convert " + candidate.getClass() + " into a Path.Supported candidate type are CharSequence, URL, URI, File and Path");
    }

    private static String toSafeURI(String candidate) {
        StringBuilder sb = new StringBuilder();
        for (char ch : candidate.toCharArray()) {
            if (IOUtilities.isUnsafe(ch)) {
                sb.append('%');
                sb.append(Integer.toHexString(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean isUnsafe(char ch) {
        return ch > '\u0080' || " <>".indexOf(ch) >= 0;
    }

    public static boolean canProcessAsPath(Object path) {
        return path instanceof File || path instanceof URL || path instanceof URI || path instanceof Path;
    }

    public static boolean isFileSystemSupported(Object path) {
        if (!IOUtilities.canProcessAsPath(path)) {
            return false;
        }
        URI uri = null;
        if (path instanceof URL) {
            try {
                uri = org.apache.sis.internal.storage.io.IOUtilities.toURI((URL)path, "UTF-8");
            }
            catch (IOException e) {
                return false;
            }
        } else if (path instanceof URI) {
            uri = (URI)path;
        } else {
            return true;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return true;
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!provider.getScheme().equalsIgnoreCase(scheme)) continue;
            try {
                provider.getPath(uri);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    public static String filename(Object input) {
        return org.apache.sis.internal.storage.io.IOUtilities.filename(input);
    }

    public static String extension(Object input) {
        return org.apache.sis.internal.storage.io.IOUtilities.extension(input);
    }

    public static String filenameWithoutExtension(Object path) {
        boolean isPath = IOUtilities.canProcessAsPath(path);
        if (!isPath) {
            return null;
        }
        try {
            return IOUtilities.filenameWithoutExtension(IOUtilities.toPath(path));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String filenameWithoutExtension(Path path) {
        ArgumentChecks.ensureNonNull("path", path);
        String fileName = path.getFileName().toString();
        int dot = fileName.lastIndexOf(46);
        if (dot > 0) {
            return fileName.substring(0, dot);
        }
        return fileName;
    }

    public static Object changeExtension(Object path, String extension) throws MalformedURLException, IOException {
        boolean isPath = IOUtilities.canProcessAsPath(path);
        if (!isPath) {
            if (path instanceof CharSequence) {
                String pathStr = (String)path;
                int dotIdx = pathStr.lastIndexOf(46);
                if (dotIdx > 0) {
                    pathStr = pathStr.substring(0, dotIdx);
                }
                return pathStr + "." + extension;
            }
            return null;
        }
        Path realPath = IOUtilities.toPath(path);
        Path outPath = IOUtilities.changeExtension(realPath, extension);
        if (path instanceof Path) {
            return outPath;
        }
        if (path instanceof String) {
            return outPath.toString();
        }
        if (path instanceof File) {
            return outPath.toFile();
        }
        if (path instanceof URL || path instanceof URI) {
            return outPath.toUri().toURL();
        }
        return null;
    }

    public static Path changeExtension(Path path, String extension) {
        String previousExt = org.apache.sis.internal.storage.io.IOUtilities.extension(path);
        if (previousExt == null && extension == null || previousExt != null && previousExt.equals(extension)) {
            return path;
        }
        String siblingName = IOUtilities.filenameWithoutExtension(path) + "." + extension;
        return path.resolveSibling(siblingName);
    }

    public static URI relativize(URI source, URI target) {
        String str;
        String filename;
        URI relativePath = (source = IOUtilities.reformat(source)).relativize(target = IOUtilities.reformat(target));
        if (relativePath.equals(target) && (filename = org.apache.sis.internal.storage.io.IOUtilities.filename(source)) != null) {
            str = source.toString();
            try {
                URI r = new URI(str.substring(0, str.length() - filename.length()));
                relativePath = r.relativize(target);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (relativePath != null && !relativePath.isAbsolute()) {
            return relativePath;
        }
        filename = org.apache.sis.internal.storage.io.IOUtilities.filename(source);
        if (filename != null) {
            str = source.toString();
            try {
                source = new URI(str.substring(0, str.length() - filename.length()));
            }
            catch (URISyntaxException r) {
                // empty catch block
            }
        }
        String[] sourceParts = source.toString().split("/");
        String[] targetParts = target.toString().split("/");
        int div = 0;
        while (true) {
            if (sourceParts.length <= div && targetParts.length <= div) {
                try {
                    return new URI(".");
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException("should not happen");
                }
            }
            if (sourceParts.length <= div) {
                String str2 = String.join((CharSequence)"/", Arrays.copyOfRange(targetParts, div, targetParts.length));
                try {
                    return new URI("./" + str2);
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException("should not happen");
                }
            }
            if (targetParts.length <= div) {
                StringBuilder sb = new StringBuilder();
                for (int i = div; i < sourceParts.length; ++i) {
                    sb.append("../");
                }
                try {
                    return new URI(sb.toString());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException("should not happen");
                }
            }
            if (!sourceParts[div].equals(targetParts[div])) break;
            ++div;
        }
        if (div == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = div; i < sourceParts.length; ++i) {
            sb.append("../");
        }
        sb.append(String.join((CharSequence)"/", Arrays.copyOfRange(targetParts, div, targetParts.length)));
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("should not happen");
        }
    }

    public static URI resolve(URI source, URI target) {
        String filename;
        URI resolvedPath = (source = IOUtilities.reformat(source)).resolve(target = IOUtilities.reformat(target));
        if (resolvedPath.equals(target) && (filename = org.apache.sis.internal.storage.io.IOUtilities.filename(source)) != null) {
            String str = source.toString();
            try {
                URI base = new URI(str.substring(0, str.length() - filename.length()));
                resolvedPath = base.resolve(target);
                if (resolvedPath.equals(target)) {
                    resolvedPath = new URI(IOUtilities.stringResolve(base.toString(), target.toString()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return resolvedPath.isAbsolute() ? resolvedPath : null;
    }

    private static URI reformat(URI uri) {
        try {
            if (uri.isOpaque()) {
                return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), uri.getFragment());
            }
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Unsupported URI " + uri.toString(), ex);
        }
    }

    private static String stringResolve(String base, String target) {
        String[] parts;
        Object resolvedPath = base;
        for (String part : parts = target.toString().split("/")) {
            if (".".equals(part)) continue;
            if ("..".equals(part)) {
                String bstr = base.toString();
                int sep = ((String)resolvedPath).substring(0, ((String)resolvedPath).length() - 1).lastIndexOf(47);
                if (sep > 0) {
                    resolvedPath = base.toString().substring(0, sep + 1);
                    continue;
                }
                resolvedPath = "./";
                continue;
            }
            resolvedPath = (String)resolvedPath + part;
        }
        return resolvedPath;
    }

    public static InputStream open(Object resource) throws IOException {
        return IOUtilities.open(resource, StandardOpenOption.READ);
    }

    public static InputStream open(Object resource, OpenOption ... options) throws IOException {
        ArgumentChecks.ensureNonNull("resource", resource);
        if (resource instanceof InputStream) {
            return (InputStream)resource;
        }
        if (!IOUtilities.canProcessAsPath(resource)) {
            throw new IOException("Can not handle input type : " + resource.getClass());
        }
        try {
            Path realPath = IOUtilities.toPath(resource);
            return Files.newInputStream(realPath, options);
        }
        catch (IOException e) {
            URL url = null;
            if (resource instanceof URL) {
                url = (URL)resource;
            }
            if (resource instanceof URI) {
                URI uri = (URI)resource;
                try {
                    url = uri.toURL();
                }
                catch (MalformedURLException e2) {
                    e.addSuppressed(e2);
                }
            }
            if (url != null) {
                URLConnection cnx = url.openConnection();
                if (cnx instanceof HttpURLConnection) {
                    cnx.setRequestProperty("Accept-Encoding", "gzip");
                    if ("gzip".equals(cnx.getContentEncoding())) {
                        return new GZIPInputStream(cnx.getInputStream());
                    }
                    return cnx.getInputStream();
                }
                return cnx.getInputStream();
            }
            throw e;
        }
    }

    public static LineNumberReader openLatin(Object path) throws IOException {
        return new LineNumberReader(new InputStreamReader(IOUtilities.open(path), "ISO-8859-1"));
    }

    public static OutputStream openWrite(Object resource) throws IOException {
        return IOUtilities.openWrite(resource, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    public static OutputStream openWrite(Object resource, OpenOption ... options) throws IOException {
        ArgumentChecks.ensureNonNull("resource", resource);
        if (resource instanceof OutputStream) {
            return (OutputStream)resource;
        }
        if (!IOUtilities.canProcessAsPath(resource)) {
            throw new IOException("Can not handle input type : " + resource.getClass());
        }
        try {
            Path realPath = IOUtilities.toPath(resource);
            return Files.newOutputStream(realPath, options);
        }
        catch (IOException e) {
            URL url = null;
            if (resource instanceof URL) {
                url = (URL)resource;
            }
            if (resource instanceof URI) {
                URI uri = (URI)resource;
                try {
                    url = uri.toURL();
                }
                catch (MalformedURLException e2) {
                    e.addSuppressed(e2);
                }
            }
            if (url != null) {
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                return connection.getOutputStream();
            }
            throw e;
        }
    }

    public static void close(Object stream) throws IOException {
        if (stream instanceof Closeable) {
            ((Closeable)stream).close();
        }
    }

    public static void readMatrixRow(BufferedReader in, double[] grid, int offset, int numCol) throws IOException {
        String line = in.readLine();
        if (line == null) {
            throw new EOFException(org.geotoolkit.resources.Errors.format((short)41));
        }
        StringTokenizer tokens = new StringTokenizer(line);
        for (int i = 0; i < numCol; ++i) {
            double value;
            if (!tokens.hasMoreTokens()) {
                throw new ContentFormatException(org.geotoolkit.resources.Errors.format((short)88, i, numCol));
            }
            String token = tokens.nextToken();
            try {
                value = Double.parseDouble(token);
            }
            catch (NumberFormatException e) {
                throw new ContentFormatException(IOUtilities.concatenate(org.geotoolkit.resources.Errors.format((short)196, token), e), e);
            }
            grid[offset + i] = value;
        }
        if (tokens.hasMoreElements()) {
            throw new ContentFormatException(org.geotoolkit.resources.Errors.format((short)87, numCol + tokens.countTokens(), numCol, tokens.nextToken()));
        }
    }

    public static void readMatrixRow(BufferedReader in, float[] grid, int offset, int numCol) throws IOException {
        String line = in.readLine();
        if (line == null) {
            throw new EOFException(org.geotoolkit.resources.Errors.format((short)41));
        }
        StringTokenizer tokens = new StringTokenizer(line);
        for (int i = 0; i < numCol; ++i) {
            float value;
            if (!tokens.hasMoreTokens()) {
                throw new ContentFormatException(org.geotoolkit.resources.Errors.format((short)88, i, numCol));
            }
            String token = tokens.nextToken();
            try {
                value = Float.parseFloat(token);
            }
            catch (NumberFormatException e) {
                throw new ContentFormatException(IOUtilities.concatenate(org.geotoolkit.resources.Errors.format((short)196, token), e), e);
            }
            grid[offset + i] = value;
        }
        if (tokens.hasMoreElements()) {
            throw new ContentFormatException(org.geotoolkit.resources.Errors.format((short)87, numCol + tokens.countTokens(), numCol, tokens.nextToken()));
        }
    }

    private static String concatenate(String message, Exception exception) {
        String cause = exception.getLocalizedMessage();
        if (cause != null) {
            message = (String)message + " " + cause;
        }
        return message;
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = input.read(buffer)) >= 0) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(Path sourcePath, Path targetPath, CopyOption ... copyOption) throws IOException {
        ArgumentChecks.ensureNonNull("sourcePath", sourcePath);
        ArgumentChecks.ensureNonNull("targetPath", targetPath);
        if (Files.isDirectory(sourcePath, new LinkOption[0])) {
            Files.walkFileTree(sourcePath, new CopyFileVisitor(targetPath, copyOption));
        } else {
            Files.copy(sourcePath, targetPath, copyOption);
        }
    }

    public static void deleteRecursively(Path root) throws IOException {
        ArgumentChecks.ensureNonNull("root", root);
        if (Files.exists(root, new LinkOption[0])) {
            if (!Files.isDirectory(root, new LinkOption[0])) {
                Files.deleteIfExists(root);
            } else {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!Files.isDirectory(file, new LinkOption[0])) {
                            Files.deleteIfExists(file);
                        } else {
                            IOUtilities.deleteRecursively(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.deleteIfExists(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    public static boolean deleteSilently(Path path) {
        try {
            IOUtilities.deleteRecursively(path);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public static void appendToFile(String text, Path filePath) throws IOException {
        try (BufferedWriter output = Files.newBufferedWriter(filePath, UTF8_CHARSET, StandardOpenOption.APPEND);){
            output.newLine();
            output.write(text);
            output.flush();
        }
    }

    public static void emptyFile(Path filePath) throws IOException {
        if (Files.exists(filePath, new LinkOption[0])) {
            Files.delete(filePath);
        }
        Files.createFile(filePath, new FileAttribute[0]);
    }

    public static List<Path> listChildren(Path directory) throws IllegalArgumentException, IOException {
        return IOUtilities.listChildren(directory, "*");
    }

    public static List<Path> listChildren(Path directory, String glob) throws IllegalArgumentException, IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Input Path is not a directory or doesn't exist");
        }
        if (glob == null || glob.isEmpty()) {
            glob = "*";
        }
        LinkedList<Path> children = new LinkedList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, glob);){
            for (Path child : stream) {
                children.add(child);
            }
        }
        Collections.sort(children);
        return children;
    }

    public static String toString(Path filePath) throws IOException {
        return IOUtilities.toString(filePath, UTF8_CHARSET);
    }

    public static String toString(Path filePath, Charset encoding) throws IOException {
        List<String> lines = Files.readAllLines(filePath, encoding);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    public static String toString(InputStream stream) throws IOException {
        return IOUtilities.toString(stream, UTF8_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream stream, Charset encoding) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, encoding));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            stream.close();
        }
        return sb.toString();
    }

    public static void writeString(String content, Path outputPath) throws IOException {
        IOUtilities.writeString(content, outputPath, UTF8_CHARSET);
    }

    public static void writeString(String content, Path outputPath, Charset encoding) throws IOException {
        ArgumentChecks.ensureNonNull("content", content);
        ArgumentChecks.ensureNonNull("outputPath", outputPath);
        try (BufferedWriter bw = Files.newBufferedWriter(outputPath, encoding, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            bw.write(content);
        }
    }

    public static void writeStream(InputStream stream, Path outputPath) throws IOException {
        ArgumentChecks.ensureNonNull("stream", stream);
        ArgumentChecks.ensureNonNull("outputPath", outputPath);
        try (OutputStream outputStream = Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            IOUtilities.copy(stream, outputStream);
        }
    }

    public static Properties getPropertiesFromFile(Path path) throws IOException {
        ArgumentChecks.ensureNonNull("path", path);
        Properties prop = new Properties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            prop.load(in);
        }
        return prop;
    }

    public static void storeProperties(Properties prop, Path path, String comment) throws IOException {
        ArgumentChecks.ensureNonNull("prop", prop);
        ArgumentChecks.ensureNonNull("path", path);
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            prop.store(out, comment != null ? comment : "");
        }
    }

    public static Path getResourceAsPath(String resource) throws URISyntaxException, IOException {
        return IOUtilities.getResourceAsPath(resource, null);
    }

    public static Path getResourceAsPath(String resource, ClassLoader classLoader) throws URISyntaxException, IOException {
        URL systemResource;
        String extension = org.apache.sis.internal.storage.io.IOUtilities.extension(resource);
        int lastDotIdx = ((String)resource).lastIndexOf(46);
        if (lastDotIdx > 0) {
            resource = ((String)resource).substring(0, lastDotIdx);
        }
        resource = ((String)resource).replace('.', '/');
        if (!extension.isEmpty()) {
            resource = (String)resource + "." + extension;
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((systemResource = classLoader.getResource((String)resource)) != null) {
            URI resourceURI = systemResource.toURI();
            if (resourceURI.getScheme().startsWith("jar")) {
                FileSystem fileSystem;
                try {
                    fileSystem = FileSystems.getFileSystem(resourceURI);
                }
                catch (FileSystemNotFoundException ex) {
                    fileSystem = FileSystems.newFileSystem(resourceURI, new HashMap());
                }
                return fileSystem.getPath((String)resource, new String[0]);
            }
            return Paths.get(resourceURI);
        }
        return null;
    }

    public static Path copyResource(String resource, ClassLoader classLoader, Path output, boolean createResourceHierarchy) throws IOException, URISyntaxException, IllegalArgumentException {
        URL resURL;
        ArgumentChecks.ensureNonNull("resource", resource);
        ArgumentChecks.ensureNonNull("output", output);
        output = output.toAbsolutePath();
        if (!Files.exists(output, new LinkOption[0])) {
            Files.createDirectories(output, new FileAttribute[0]);
        }
        if (!Files.isDirectory(output, new LinkOption[0])) {
            throw new IllegalArgumentException("Output is not a directory");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((resURL = classLoader.getResource(resource)) != null) {
            Path resPath;
            URI resURI = resURL.toURI();
            if (resURI.getScheme().startsWith("jar")) {
                FileSystem fileSystem;
                try {
                    fileSystem = FileSystems.getFileSystem(resURI);
                }
                catch (FileSystemNotFoundException ex) {
                    fileSystem = FileSystems.newFileSystem(resURI, new HashMap());
                }
                resPath = fileSystem.getPath(resource, new String[0]);
                if (!resPath.toString().startsWith("/")) {
                    resPath = resPath.getFileSystem().getPath("/", resPath.toString());
                }
            } else {
                resPath = Paths.get(resURI);
            }
            String resourceName = resPath.getFileName().toString();
            Path copyDir = output;
            if (Files.isDirectory(resPath, new LinkOption[0])) {
                copyDir = output.resolve(resourceName);
            }
            if (createResourceHierarchy) {
                if (Files.isDirectory(resPath, new LinkOption[0])) {
                    copyDir = output.resolve(resource);
                } else {
                    String lastDirectory = resource.substring(0, resource.lastIndexOf(47));
                    copyDir = output.resolve(lastDirectory);
                }
            }
            Files.createDirectories(copyDir, new FileAttribute[0]);
            Path outputPath = copyDir;
            if (Files.isRegularFile(resPath, new LinkOption[0])) {
                outputPath = outputPath.resolve(resourceName);
            }
            Files.walkFileTree(resPath, new CopyFileVisitor(copyDir, StandardCopyOption.REPLACE_EXISTING));
            return outputPath;
        }
        throw new FileNotFoundException("Unable to find resource " + resource + " into ClassLoader " + classLoader);
    }

    static {
        DELETE_ON_EXIT_PATHS = Collections.newSetFromMap(new ConcurrentHashMap());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Path path : DELETE_ON_EXIT_PATHS) {
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    try {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            IOUtilities.deleteRecursively(path);
                            continue;
                        }
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Unable to delete on exit file : " + path.toString());
                    }
                }
            }
        });
    }
}

