/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.nio;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class PathFilterVisitor
extends SimpleFileVisitor<Path> {
    private final PathMatcher matcher;
    private final List<Path> matchedPaths = new ArrayList<Path>();
    private boolean fileOnly = true;

    public PathFilterVisitor(PathMatcher matcher) {
        this.matcher = matcher;
    }

    public PathFilterVisitor(PathMatcher matcher, boolean fileOnly) {
        this.matcher = matcher;
        this.fileOnly = fileOnly;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (!this.fileOnly && this.matcher.matches(dir)) {
            this.matchedPaths.add(dir);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.matcher.matches(file)) {
            this.matchedPaths.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    public List<Path> getMatchedPaths() {
        return this.matchedPaths;
    }
}

