/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

@Deprecated
public abstract class AbstractParameter
extends FormattableObject
implements GeneralParameterValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8458179223988766398L;
    protected final GeneralParameterDescriptor descriptor;

    protected AbstractParameter(GeneralParameterDescriptor descriptor) {
        this.descriptor = descriptor;
        ArgumentChecks.ensureNonNull("descriptor", descriptor);
    }

    @Override
    public GeneralParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> descriptor, Object value) throws InvalidParameterValueException {
        String error;
        if (value == null) {
            if (descriptor.getMinimumOccurs() != 0) {
                return descriptor.getDefaultValue();
            }
            return null;
        }
        Class<T> type = descriptor.getValueClass();
        if (!type.isInstance(value)) {
            error = Errors.format((short)69, value.getClass());
        } else {
            T typedValue = type.cast(value);
            Comparable<T> minimum = descriptor.getMinimumValue();
            Comparable<T> maximum = descriptor.getMaximumValue();
            if (minimum != null && minimum.compareTo(typedValue) > 0 || maximum != null && maximum.compareTo(typedValue) < 0) {
                error = Errors.format((short)212, value, minimum, maximum);
            } else {
                Set<T> validValues = descriptor.getValidValues();
                if (validValues != null && !validValues.contains(value)) {
                    error = Errors.format((short)53, AbstractParameter.getName(descriptor), value);
                } else {
                    return typedValue;
                }
            }
        }
        throw new InvalidParameterValueException(error, AbstractParameter.getName(descriptor), value);
    }

    protected static IllegalStateException unitlessParameter(GeneralParameterDescriptor descriptor) {
        return new IllegalStateException(Errors.format((short)180, AbstractParameter.getName(descriptor)));
    }

    protected static String getName(GeneralParameterDescriptor descriptor) {
        return descriptor.getName().getCode();
    }

    static short getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 136;
        }
        if (Units.isAngular(unit)) {
            return 131;
        }
        if (Units.isTemporal(unit)) {
            return 138;
        }
        if (Units.isScale(unit)) {
            return 137;
        }
        return 77;
    }

    @Override
    public AbstractParameter clone() {
        try {
            return (AbstractParameter)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            AbstractParameter that = (AbstractParameter)object;
            return Objects.equals(this.descriptor, that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ 0xDC7086BE;
    }

    @Override
    public String formatTo(Formatter formatter) {
        if (this instanceof ParameterValue) {
            return new Bridge((ParameterValue)((Object)this)).formatTo(formatter);
        }
        return "PARAMETER";
    }

    @Deprecated
    private static final class Bridge<T>
    extends DefaultParameterValue<T> {
        Bridge(ParameterValue<T> param) {
            super(param);
        }

        @Override
        public String formatTo(Formatter formatter) {
            return super.formatTo(formatter);
        }
    }
}

