/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.provider.EllipsoidToGeoid;
import org.geotoolkit.referencing.operation.transform.VerticalTransform;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.util.FactoryException;

public class EarthGravitationalModel
extends VerticalTransform {
    private static final double SQRT_03 = 1.7320508075688772;
    private static final double SQRT_05 = 2.23606797749979;
    private static final double SQRT_13 = 3.605551275463989;
    private static final double SQRT_17 = 4.123105625617661;
    private static final double SQRT_21 = 4.58257569495584;
    public static final int DEFAULT_ORDER = 180;
    private static final WeakValueHashMap<Integer, EarthGravitationalModel> POOL = new WeakValueHashMap(Integer.class);
    private final boolean isWGS84;
    private final int nmax;
    private final double semiMajor;
    private final double esq;
    private final double c2;
    private final double rkm;
    private final double grava;
    private final double star;
    final double[] cnmGeopCoef;
    final double[] snmGeopCoef;
    private final double[] aClenshaw;
    private final double[] bClenshaw;
    private final double[] as;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EarthGravitationalModel create(GeodeticDatum datum, int nmax) throws IllegalArgumentException, FactoryException {
        EarthGravitationalModel model;
        Integer key = EarthGravitationalModel.hashCode(Utilities.equalsApproximately(CommonCRS.WGS84.datum(), datum), nmax);
        WeakValueHashMap<Integer, EarthGravitationalModel> weakValueHashMap = POOL;
        synchronized (weakValueHashMap) {
            model = POOL.get(key);
            if (model == null) {
                model = new EarthGravitationalModel(datum, nmax);
                POOL.put(key, model);
            }
        }
        return model;
    }

    protected EarthGravitationalModel() throws FactoryException {
        this(CommonCRS.WGS84.datum(), 180);
    }

    protected EarthGravitationalModel(GeodeticDatum datum, int nmax) throws IllegalArgumentException, FactoryException {
        this(datum, nmax, true);
        String filename = "EGM180.bnor";
        try {
            this.load("EGM180.bnor");
        }
        catch (IOException e) {
            throw new FactoryException(Errors.format((short)18, "EGM180.bnor"), e);
        }
        this.initialize();
    }

    EarthGravitationalModel(GeodeticDatum datum, int nmax, boolean dummy) throws IllegalArgumentException {
        EarthGravitationalModel.ensureNonNull("datum", datum);
        ArgumentChecks.ensureBetween("nmax", 2, 9999, nmax);
        this.nmax = nmax;
        this.isWGS84 = Utilities.equalsApproximately(CommonCRS.WGS84.datum(), datum);
        if (this.isWGS84) {
            this.semiMajor = 6378137.0;
            this.esq = 0.00669437999013;
            this.c2 = 0.00108262998905;
            this.rkm = 3.986004418E14;
            this.grava = 9.7803267714;
            this.star = 0.001931851386;
        } else if (Utilities.equalsIgnoreMetadata(CommonCRS.WGS72.datum(), datum)) {
            this.semiMajor = 6378135.0;
            this.esq = 0.006694317778;
            this.c2 = 0.00108263;
            this.rkm = 3.986005E14;
            this.grava = 9.7803327;
            this.star = 0.005278994;
        } else {
            throw new IllegalArgumentException(Errors.format((short)205, datum.getName().getCode()));
        }
        int cleanshawLength = EarthGravitationalModel.locatingArray(nmax + 3);
        int geopCoefLength = EarthGravitationalModel.locatingArray(nmax + 1);
        this.aClenshaw = new double[cleanshawLength];
        this.bClenshaw = new double[cleanshawLength];
        this.cnmGeopCoef = new double[geopCoefLength];
        this.snmGeopCoef = new double[geopCoefLength];
        this.as = new double[nmax + 1];
    }

    static int locatingArray(int n) {
        return (n + 1) * n >> 1;
    }

    final void load(String filename) throws IOException {
        InputStream stream = EarthGravitationalModel.class.getResourceAsStream(filename);
        if (stream == null) {
            throw new FileNotFoundException(filename);
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(stream));){
            for (int i = 0; i < this.cnmGeopCoef.length; ++i) {
                this.cnmGeopCoef[i] = in.readDouble();
                this.snmGeopCoef[i] = in.readDouble();
            }
        }
    }

    private void initialize() {
        int i;
        if (this.isWGS84) {
            double[] c2n = new double[6];
            c2n[1] = this.c2;
            int sign = 1;
            double esqi = this.esq;
            for (int i2 = 2; i2 < c2n.length; ++i2) {
                c2n[i2] = (double)(sign *= -1) * (3.0 * (esqi *= this.esq)) / (double)((2 * i2 + 1) * (2 * i2 + 3)) * ((double)(1 - i2) + (double)(5 * i2) * this.c2 / this.esq);
            }
            this.cnmGeopCoef[3] = this.cnmGeopCoef[3] + c2n[1] / 2.23606797749979;
            this.cnmGeopCoef[10] = this.cnmGeopCoef[10] + c2n[2] / 3.0;
            this.cnmGeopCoef[21] = this.cnmGeopCoef[21] + c2n[3] / 3.605551275463989;
            if (this.nmax > 6) {
                this.cnmGeopCoef[36] = this.cnmGeopCoef[36] + c2n[4] / 4.123105625617661;
            }
            if (this.nmax > 9) {
                this.cnmGeopCoef[55] = this.cnmGeopCoef[55] + c2n[5] / 4.58257569495584;
            }
        } else {
            this.cnmGeopCoef[3] = this.cnmGeopCoef[3] + 4.841732E-4;
            this.cnmGeopCoef[10] = this.cnmGeopCoef[10] + -7.8305E-7;
        }
        for (i = 0; i <= this.nmax; ++i) {
            this.as[i] = -Math.sqrt(1.0 + 1.0 / (double)(2 * (i + 1)));
        }
        for (i = 0; i <= this.nmax; ++i) {
            for (int j = i + 1; j <= this.nmax; ++j) {
                int ll = EarthGravitationalModel.locatingArray(j) + i;
                int n = 2 * j + 1;
                int ji = (j - i) * (j + i);
                this.aClenshaw[ll] = Math.sqrt((double)(n * (2 * j - 1)) / (double)ji);
                this.bClenshaw[ll] = Math.sqrt((double)(n * (j + i - 1) * (j - i - 1)) / (double)(ji * (2 * j - 3)));
            }
        }
    }

    @Override
    public double heightOffset(double longitude, double latitude, double height) {
        double \u03c6 = Math.toRadians(latitude);
        double sin\u03c6 = Math.sin(\u03c6);
        double sin2\u03c6 = sin\u03c6 * sin\u03c6;
        double rni = Math.sqrt(1.0 - this.esq * sin2\u03c6);
        double rn = this.semiMajor / rni;
        double t22 = (rn + height) * Math.cos(\u03c6);
        double z1 = (rn * (1.0 - this.esq) + height) * sin\u03c6;
        double th = 1.5707963267948966 - Math.atan(z1 / t22);
        double y = Math.sin(th);
        double t2 = Math.cos(th);
        double f1 = this.semiMajor / Math.hypot(t22, z1);
        double f2 = f1 * f1;
        double \u03bb = Math.toRadians(longitude);
        double gravn = this.isWGS84 ? this.grava * (1.0 + this.star * sin2\u03c6) / rni : this.grava * (1.0 + this.star * sin2\u03c6) + 2.3461E-5 * (sin2\u03c6 * sin2\u03c6);
        double[] cr = new double[this.nmax + 1];
        double[] sr = new double[this.nmax + 1];
        double[] s11 = new double[this.nmax + 3];
        double[] s12 = new double[this.nmax + 3];
        sr[0] = 0.0;
        sr[1] = Math.sin(\u03bb);
        cr[0] = 1.0;
        cr[1] = Math.cos(\u03bb);
        for (int j = 2; j <= this.nmax; ++j) {
            sr[j] = 2.0 * cr[1] * sr[j - 1] - sr[j - 2];
            cr[j] = 2.0 * cr[1] * cr[j - 1] - cr[j - 2];
        }
        double sht = 0.0;
        double previousSht = 0.0;
        for (int i = this.nmax; i >= 0; --i) {
            for (int j = this.nmax; j >= i; --j) {
                int ll = EarthGravitationalModel.locatingArray(j) + i;
                int ll2 = ll + j + 1;
                int ll3 = ll2 + j + 2;
                double ta = this.aClenshaw[ll2] * f1 * t2;
                double tb = this.bClenshaw[ll3] * f2;
                s11[j] = ta * s11[j + 1] - tb * s11[j + 2] + this.cnmGeopCoef[ll];
                s12[j] = ta * s12[j + 1] - tb * s12[j + 2] + this.snmGeopCoef[ll];
            }
            previousSht = sht;
            sht = -this.as[i] * y * f1 * sht + s11[i] * cr[i] + s12[i] * sr[i];
        }
        return ((s11[0] + s12[0]) * f1 + previousSht * 1.7320508075688772 * y * f2) * this.rkm / (this.semiMajor * (gravn - height * 3.086E-6));
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return EllipsoidToGeoid.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), new Parameter<String>(EllipsoidToGeoid.DATUM, this.isWGS84 ? "WGS84" : "WGS72"), new Parameter<Integer>(EllipsoidToGeoid.ORDER, this.nmax));
    }

    private static int hashCode(boolean isWGS84, int nmax) {
        if (!isWGS84) {
            nmax ^= 0xFFFFFFFF;
        }
        return nmax;
    }

    @Override
    protected int computeHashCode() {
        return org.geotoolkit.util.Utilities.hash(EarthGravitationalModel.hashCode(this.isWGS84, this.nmax), super.computeHashCode());
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            EarthGravitationalModel that = (EarthGravitationalModel)object;
            return this.isWGS84 == that.isWGS84 && this.nmax == that.nmax;
        }
        return false;
    }
}

