/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class VerticalTransform
extends AbstractMathTransform {
    private static final int DIMENSION = 3;

    protected VerticalTransform() {
    }

    @Override
    public final int getSourceDimensions() {
        return 3;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    protected abstract double heightOffset(double var1, double var3, double var5) throws TransformException;

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        if (dstPts != null) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double z = srcPts[srcOff + 2];
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
            dstPts[dstOff + 2] = z + this.heightOffset(x, y, z);
        }
        return derivate ? Matrices.createDiagonal(this.getTargetDimensions(), this.getSourceDimensions()) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        boolean reverse = false;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 3, dstOff, 3, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    int offset = (numPts - 1) * 3;
                    srcOff += offset;
                    dstOff += offset;
                    reverse = true;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * 3);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            dstPts[dstOff++] = x;
            dstPts[dstOff++] = y;
            dstPts[dstOff++] = z + this.heightOffset(x, y, z);
            if (!reverse) continue;
            srcOff -= 6;
            dstOff -= 6;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        boolean reverse = false;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 3, dstOff, 3, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    int offset = (numPts - 1) * 3;
                    srcOff += offset;
                    dstOff += offset;
                    reverse = true;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * 3);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            float x = srcPts[srcOff++];
            float y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            dstPts[dstOff++] = x;
            dstPts[dstOff++] = y;
            dstPts[dstOff++] = (float)(z + this.heightOffset(x, y, z));
            if (!reverse) continue;
            srcOff -= 6;
            dstOff -= 6;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        while (--numPts >= 0) {
            double y;
            double x;
            dstPts[dstOff++] = x = (double)srcPts[srcOff++];
            dstPts[dstOff++] = y = (double)srcPts[srcOff++];
            int n = dstOff++;
            double z = srcPts[srcOff++];
            dstPts[n] = z + this.heightOffset(x, y, z);
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        while (--numPts >= 0) {
            int n = dstOff++;
            double x = srcPts[srcOff++];
            dstPts[n] = (float)x;
            int n2 = dstOff++;
            double y = srcPts[srcOff++];
            dstPts[n2] = (float)y;
            int n3 = dstOff++;
            double z = srcPts[srcOff++];
            dstPts[n3] = (float)(z + this.heightOffset(x, y, z));
        }
    }
}

