/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.factory;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.geotoolkit.temporal.object.DefaultCalendarDate;
import org.geotoolkit.temporal.object.DefaultClockTime;
import org.geotoolkit.temporal.object.DefaultDateAndTime;
import org.geotoolkit.temporal.object.DefaultInstant;
import org.geotoolkit.temporal.object.DefaultIntervalLength;
import org.geotoolkit.temporal.object.DefaultJulianDate;
import org.geotoolkit.temporal.object.DefaultOrdinalPosition;
import org.geotoolkit.temporal.object.DefaultPeriod;
import org.geotoolkit.temporal.object.DefaultPeriodDuration;
import org.geotoolkit.temporal.object.DefaultTemporalCoordinate;
import org.geotoolkit.temporal.object.DefaultTemporalPosition;
import org.geotoolkit.temporal.reference.DefaultCalendar;
import org.geotoolkit.temporal.reference.DefaultCalendarEra;
import org.geotoolkit.temporal.reference.DefaultClock;
import org.geotoolkit.temporal.reference.DefaultOrdinalEra;
import org.geotoolkit.temporal.reference.DefaultOrdinalReferenceSystem;
import org.geotoolkit.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotoolkit.temporal.reference.DefaultTemporalReferenceSystem;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.temporal.Calendar;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.CalendarEra;
import org.opengis.temporal.Clock;
import org.opengis.temporal.ClockTime;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.Instant;
import org.opengis.temporal.IntervalLength;
import org.opengis.temporal.JulianDate;
import org.opengis.temporal.OrdinalEra;
import org.opengis.temporal.OrdinalPosition;
import org.opengis.temporal.OrdinalReferenceSystem;
import org.opengis.temporal.Period;
import org.opengis.temporal.PeriodDuration;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalCoordinateSystem;
import org.opengis.temporal.TemporalFactory;
import org.opengis.temporal.TemporalPosition;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultTemporalFactory
implements TemporalFactory {
    long periodCount = 0L;
    long instantCount = 0L;

    @Override
    public Period createPeriod(Instant begin, Instant end) {
        HashMap<String, CallSite> prop = new HashMap<String, CallSite>();
        prop.put("name", (CallSite)((Object)("period" + this.periodCount++)));
        return new DefaultPeriod(prop, begin, end);
    }

    @Override
    public Instant createInstant(Date instant) {
        HashMap<String, CallSite> prop = new HashMap<String, CallSite>();
        prop.put("name", (CallSite)((Object)("instant" + this.instantCount++)));
        if (instant != null) {
            return new DefaultInstant(prop, instant);
        }
        DefaultTemporalPosition position = new DefaultTemporalPosition(IndeterminateValue.UNKNOWN);
        return new DefaultInstant(prop, position);
    }

    @Override
    public Calendar createCalendar(Identifier name, Extent domainOfValidity) {
        return this.createCalendar(name, domainOfValidity, null, null);
    }

    @Override
    public Calendar createCalendar(Identifier name, Extent domainOfValidity, Collection<CalendarEra> referenceFrame, Clock timeBasis) {
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("name", name);
        prop.put("domainOfValidity", domainOfValidity);
        return new DefaultCalendar(prop, referenceFrame, timeBasis);
    }

    @Override
    public CalendarDate createCalendarDate(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, InternationalString calendarEraName, int[] calendarDate) {
        return new DefaultCalendarDate(frame, indeterminatePosition, calendarEraName, calendarDate);
    }

    @Override
    public CalendarEra createCalendarEra(InternationalString name, InternationalString referenceEvent, CalendarDate referenceDate, JulianDate julianReference, Period epochOfUse) {
        HashMap<String, CharSequence> calendarEraProperties = new HashMap<String, CharSequence>();
        calendarEraProperties.put("name", name.toString());
        calendarEraProperties.put("referenceEvent", referenceEvent);
        return new DefaultCalendarEra(calendarEraProperties, referenceDate, julianReference, epochOfUse);
    }

    @Override
    public Clock createClock(Identifier name, Extent domainOfValidity, InternationalString referenceEvent, ClockTime referenceTime, ClockTime utcReference) {
        HashMap<String, Object> calendarEraProperties = new HashMap<String, Object>();
        calendarEraProperties.put("name", name);
        calendarEraProperties.put("referenceEvent", referenceEvent);
        calendarEraProperties.put("domainOfValidity", domainOfValidity);
        return new DefaultClock(calendarEraProperties, referenceTime, utcReference, null);
    }

    @Override
    public ClockTime createClockTime(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, Number[] clockTime) {
        return new DefaultClockTime(frame, indeterminatePosition, clockTime);
    }

    @Override
    public DateAndTime createDateAndTime(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, InternationalString calendarEraName, int[] calendarDate, Number[] clockTime) {
        return new DefaultDateAndTime(frame, indeterminatePosition, calendarEraName, calendarDate, clockTime);
    }

    @Override
    public IntervalLength createIntervalLenght(Unit unit, int radix, int factor, int value) {
        return new DefaultIntervalLength(unit, radix, factor, value);
    }

    @Override
    public JulianDate createJulianDate(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, Number coordinateValue) {
        return new DefaultJulianDate(frame, indeterminatePosition, coordinateValue);
    }

    @Override
    public OrdinalEra createOrdinalEra(InternationalString name, Date begin, Date end, Collection<OrdinalEra> composition) {
        HashMap<String, String> ordinalEraProperties = new HashMap<String, String>();
        ordinalEraProperties.put("name", name.toString());
        return new DefaultOrdinalEra(ordinalEraProperties, begin, end, composition);
    }

    @Override
    public OrdinalPosition createOrdinalPosition(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, OrdinalEra ordinalPosition) {
        return new DefaultOrdinalPosition(frame, indeterminatePosition, ordinalPosition);
    }

    @Override
    public OrdinalReferenceSystem createOrdinalReferenceSystem(Identifier name, Extent domainOfValidity, Collection<OrdinalEra> ordinalEraSequence) {
        HashMap<String, Object> ordinalEraProp = new HashMap<String, Object>();
        ordinalEraProp.put("name", name.getCode());
        ordinalEraProp.put("identifiers", name);
        ordinalEraProp.put("domainOfValidity", domainOfValidity);
        return new DefaultOrdinalReferenceSystem(ordinalEraProp, ordinalEraSequence);
    }

    @Override
    public PeriodDuration createPeriodDuration(InternationalString years, InternationalString months, InternationalString week, InternationalString days, InternationalString hours, InternationalString minutes, InternationalString seconds) {
        return new DefaultPeriodDuration(years, months, week, days, hours, minutes, seconds);
    }

    @Override
    public TemporalCoordinate createTemporalCoordinate(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, Number coordinateValue) {
        return new DefaultTemporalCoordinate(frame, indeterminatePosition, coordinateValue);
    }

    @Override
    public TemporalCoordinateSystem createTemporalCoordinateSystem(Identifier name, Extent domainOfValidity, Date origin, Unit<Time> interval) {
        HashMap<String, Object> coordSystemProp = new HashMap<String, Object>();
        coordSystemProp.put("name", name.getCode());
        coordSystemProp.put("identifiers", name);
        coordSystemProp.put("domainOfValidity", domainOfValidity);
        return new DefaultTemporalCoordinateSystem(coordSystemProp, interval, origin);
    }

    @Override
    public TemporalPosition createTemporalPosition(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition) {
        return new DefaultTemporalPosition(frame, indeterminatePosition);
    }

    @Override
    public TemporalReferenceSystem createTemporalReferenceSystem(Identifier name, Extent domainOfValidity) {
        HashMap<String, Object> tempRefSystemProp = new HashMap<String, Object>();
        tempRefSystemProp.put("name", name.getCode());
        tempRefSystemProp.put("identifiers", name);
        tempRefSystemProp.put("domainOfValidity", domainOfValidity);
        return new DefaultTemporalReferenceSystem(tempRefSystemProp);
    }
}

