/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.List;
import java.util.Objects;

public interface DeltaComparable {
    public boolean equals(Object var1, float var2);

    public static boolean equals(List<? extends DeltaComparable> o1, List<? extends DeltaComparable> o2, float delta) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null && o1.size() == o2.size()) {
            for (int i = 0; i < o1.size(); ++i) {
                if (DeltaComparable.equals(o1.get(i), o2.get(i), delta)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Object o1, Object o2, float delta) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null) {
            if (o1 instanceof DeltaComparable && o2 instanceof DeltaComparable) {
                return ((DeltaComparable)o1).equals(o2, delta);
            }
            return Objects.equals(o1, o2);
        }
        return false;
    }

    public static boolean arrayEquals(double[] d1, double[] d2, float eps) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 != null && d2 != null && d1.length == d2.length) {
            for (int i = 0; i < d1.length; ++i) {
                double v1 = d1[i];
                double v2 = d2[i];
                if (DeltaComparable.equals(v1, v2, eps)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean arrayEquals(double[][] d1, double[][] d2, float eps) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 != null && d2 != null && d1.length == d2.length) {
            for (int i = 0; i < d1.length; ++i) {
                if (DeltaComparable.arrayEquals(d1[i], d2[i], eps)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean arrayEquals(double[][][] d1, double[][][] d2, float eps) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 != null && d2 != null && d1.length == d2.length) {
            for (int i = 0; i < d1.length; ++i) {
                if (DeltaComparable.arrayEquals(d1[i], d2[i], eps)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean arrayEquals(double[][][][] d1, double[][][][] d2, float eps) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 != null && d2 != null && d1.length == d2.length) {
            for (int i = 0; i < d1.length; ++i) {
                if (DeltaComparable.arrayEquals(d1[i], d2[i], eps)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(double d1, double d2, float epsilon) {
        return Math.abs(d1 - d2) < (double)epsilon;
    }
}

