/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.nio.IOUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DomUtilities
extends Static {
    private DomUtilities() {
    }

    public static Document read(Object input) throws ParserConfigurationException, SAXException, IOException {
        InputStream stream = DomUtilities.toInputStream(input);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = factory.newDocumentBuilder();
        Document document = constructeur.parse(stream);
        stream.close();
        return document;
    }

    public static void write(Document doc, Object output) throws TransformerException, FileNotFoundException, IOException {
        StreamResult result;
        DOMSource source = new DOMSource(doc);
        if (output instanceof File) {
            result = new StreamResult((File)output);
        } else if (output instanceof Writer) {
            result = new StreamResult((Writer)output);
        } else {
            OutputStream stream = DomUtilities.toOutputStream(output);
            result = new StreamResult(stream);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer trs = factory.newTransformer();
        trs.setOutputProperty("indent", "yes");
        trs.setOutputProperty("encoding", "ISO-8859-1");
        trs.transform(source, result);
    }

    public static Element firstElement(Element parent, String tagName) {
        return DomUtilities.firstElement(parent, tagName, true);
    }

    public static Element firstElement(Element parent, String tagName, boolean recursive) {
        if (recursive) {
            NodeList lst = parent.getElementsByTagName(tagName);
            if (lst.getLength() > 0) {
                return (Element)lst.item(0);
            }
        } else {
            NodeList lst = parent.getChildNodes();
            int n = lst.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = lst.item(i);
                if (!(child instanceof Element) || !tagName.equalsIgnoreCase(child.getLocalName())) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static List<Element> getListElements(Element parent, String tagName) {
        NodeList lst = parent.getElementsByTagName(tagName);
        ArrayList<Element> result = new ArrayList<Element>();
        int n = lst.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = lst.item(i);
            if (!(child instanceof Element) || !tagName.equalsIgnoreCase(child.getNodeName())) continue;
            result.add((Element)child);
        }
        return result;
    }

    public static List<Element> getListElementsNonRecusive(Element parent, String tagName) {
        NodeList lst = parent.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        int n = lst.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = lst.item(i);
            if (!(child instanceof Element) || !tagName.equalsIgnoreCase(child.getLocalName())) continue;
            result.add((Element)child);
        }
        return result;
    }

    public static Node getNodeByLocalName(Node parent, String name) {
        if (name.equalsIgnoreCase(parent.getLocalName())) {
            return parent;
        }
        NodeList lst = parent.getChildNodes();
        int n = lst.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = lst.item(i);
            if (!name.equalsIgnoreCase(child.getLocalName())) continue;
            return child;
        }
        return null;
    }

    public static <T> T textValue(Element parent, String tagName, Class<T> clazz) throws UnconvertibleObjectException {
        Element ele = DomUtilities.firstElement(parent, tagName, true);
        if (ele == null) {
            return null;
        }
        String text = ele.getTextContent();
        if (text == null) {
            return null;
        }
        return ObjectConverters.convert(text, clazz);
    }

    public static <T> T textValue(Element parent, String tagName, Class<T> clazz, boolean recursive) throws UnconvertibleObjectException {
        Element ele = DomUtilities.firstElement(parent, tagName, recursive);
        if (ele == null) {
            return null;
        }
        String text = ele.getTextContent();
        if (text == null) {
            return null;
        }
        return ObjectConverters.convert(text, clazz);
    }

    public static <T> T textAttributeValue(Element parent, String tagName, String attributeName, Class<T> clazz) throws UnconvertibleObjectException {
        Element ele = DomUtilities.firstElement(parent, tagName, true);
        if (ele == null) {
            return null;
        }
        String text = ele.getAttribute(attributeName);
        if (text == null) {
            return null;
        }
        return ObjectConverters.convert(text, clazz);
    }

    public static <T> T textAttributeValue(Element parent, String tagName, String attributeName, Class<T> clazz, boolean recursive) throws UnconvertibleObjectException {
        Element ele = DomUtilities.firstElement(parent, tagName, recursive);
        if (ele == null) {
            return null;
        }
        String text = ele.getAttribute(attributeName);
        if (text == null) {
            return null;
        }
        return ObjectConverters.convert(text, clazz);
    }

    public static <T> T textValueSafe(Element parent, String tagName, Class<T> clazz) {
        try {
            return DomUtilities.textValue(parent, tagName, clazz);
        }
        catch (UnconvertibleObjectException ex) {
            Logger.getLogger("org.geotoolkit.util").log(Level.WARNING, null, ex);
            return null;
        }
    }

    public static <T> T textValueSafe(Element parent, String tagName, Class<T> clazz, boolean recusive) {
        try {
            return DomUtilities.textValue(parent, tagName, clazz, recusive);
        }
        catch (UnconvertibleObjectException ex) {
            Logger.getLogger("org.geotoolkit.util").log(Level.WARNING, null, ex);
            return null;
        }
    }

    public static <T> T textAttributeValueSafe(Element parent, String tagName, String attributeName, Class<T> clazz) {
        try {
            return DomUtilities.textAttributeValue(parent, tagName, attributeName, clazz);
        }
        catch (UnconvertibleObjectException ex) {
            Logger.getLogger("org.geotoolkit.util").log(Level.WARNING, null, ex);
            return null;
        }
    }

    public static <T> T textAttributeValueSafe(Element parent, String tagName, String attributeName, Class<T> clazz, boolean recursive) {
        try {
            return DomUtilities.textAttributeValue(parent, tagName, attributeName, clazz, recursive);
        }
        catch (UnconvertibleObjectException ex) {
            Logger.getLogger("org.geotoolkit.util").log(Level.WARNING, null, ex);
            return null;
        }
    }

    private static OutputStream toOutputStream(Object input) throws FileNotFoundException, IOException {
        return IOUtilities.openWrite(input);
    }

    private static InputStream toInputStream(Object input) throws FileNotFoundException, IOException {
        if (input instanceof String) {
            try {
                URL uRL = new URL((String)input);
            }
            catch (MalformedURLException ex) {
                return new ByteArrayInputStream(input.toString().getBytes());
            }
        }
        return IOUtilities.open(input);
    }

    public static void prettyPrint(Path input, Path output) throws TransformerConfigurationException, ParserConfigurationException, SAXException, IOException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(output.toFile());
        DOMSource source = new DOMSource(DomUtilities.read(input));
        transformer.transform(source, result);
    }
}

