/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.Collection;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class IncrementalDelaunayTriangulator {
    private QuadEdgeSubdivision subdiv;
    private boolean isUsingTolerance = false;

    public IncrementalDelaunayTriangulator(QuadEdgeSubdivision subdiv) {
        this.subdiv = subdiv;
        this.isUsingTolerance = subdiv.getTolerance() > 0.0;
    }

    public void insertSites(Collection vertices) {
        for (Vertex v : vertices) {
            this.insertSite(v);
        }
    }

    public QuadEdge insertSite(Vertex v) {
        QuadEdge e = this.subdiv.locate(v);
        if (this.subdiv.isVertexOfEdge(e, v)) {
            return e;
        }
        if (this.subdiv.isOnEdge(e, v.getCoordinate())) {
            e = e.oPrev();
            this.subdiv.delete(e.oNext());
        }
        QuadEdge base = this.subdiv.makeEdge(e.orig(), v);
        QuadEdge.splice(base, e);
        QuadEdge startEdge = base;
        while ((e = (base = this.subdiv.connect(e, base.sym())).oPrev()).lNext() != startEdge) {
        }
        while (true) {
            QuadEdge t2;
            if ((t2 = e.oPrev()).dest().rightOf(e) && v.isInCircle(e.orig(), t2.dest(), e.dest())) {
                QuadEdge.swap(e);
                e = e.oPrev();
                continue;
            }
            if (e.oNext() == startEdge) {
                return base;
            }
            e = e.oNext().lPrev();
        }
    }
}

