/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.TestResult;
import org.testng.internal.invokers.IInvocationStatus;
import org.testng.internal.invokers.InvokedMethod;
import org.testng.junit.IJUnitTestRunner;
import org.testng.junit.JUnit4TestClass;
import org.testng.junit.JUnit4TestMethod;

@Deprecated
public class JUnit4TestRunner
implements IJUnitTestRunner {
    private final ITestObjectFactory objectFactory;
    private final ITestResultNotifier m_parentRunner;
    private final List<ITestListener> m_listeners;
    private final List<ITestNGMethod> m_methods = Lists.newArrayList();
    private Collection<IInvokedMethodListener> m_invokeListeners = Lists.newArrayList();
    private final Map<Description, ITestResult> m_foundMethods = new WeakHashMap<Description, ITestResult>();
    private final ITestListener m_exitCodeListener;

    public JUnit4TestRunner(ITestObjectFactory objectFactory, ITestResultNotifier tr) {
        this.objectFactory = objectFactory;
        this.m_parentRunner = tr;
        this.m_listeners = this.m_parentRunner.getTestListeners();
        this.m_exitCodeListener = this.m_parentRunner.getExitCodeListener();
    }

    @Override
    public List<ITestNGMethod> getTestMethods() {
        return this.m_methods;
    }

    @Override
    public void setInvokedMethodListeners(Collection<IInvokedMethodListener> listeners) {
        this.m_invokeListeners = listeners;
    }

    public void run(Class testClass, String ... methods) {
        this.start(testClass, methods);
    }

    public Result start(Class testCase, final String ... methods) {
        try {
            JUnitCore core = new JUnitCore();
            core.addListener((RunListener)new RL());
            Request r = Request.aClass((Class)testCase);
            return core.run(r.filterWith(new Filter(){

                public boolean shouldRun(Description description) {
                    if (description == null) {
                        return false;
                    }
                    if (methods.length == 0) {
                        if (description.getTestClass() != null) {
                            ITestResult tr = JUnit4TestRunner.this.createTestResult(JUnit4TestRunner.this.objectFactory, description);
                            JUnit4TestRunner.this.m_foundMethods.put(description, tr);
                        }
                        return true;
                    }
                    for (String m4 : methods) {
                        Pattern p = Pattern.compile(m4);
                        if (!p.matcher(description.getMethodName()).matches()) continue;
                        ITestResult tr = JUnit4TestRunner.this.createTestResult(JUnit4TestRunner.this.objectFactory, description);
                        JUnit4TestRunner.this.m_foundMethods.put(description, tr);
                        return true;
                    }
                    return false;
                }

                public String describe() {
                    return "TestNG method filter";
                }
            }));
        }
        catch (Throwable t2) {
            throw new TestNGException("Failure in JUnit mode for class " + testCase.getName(), t2);
        }
    }

    private ITestResult createTestResult(ITestObjectFactory objectFactory, Description test) {
        JUnit4TestClass tc = new JUnit4TestClass(test);
        JUnit4TestMethod tm = new JUnit4TestMethod(objectFactory, tc, test);
        ITestContext ctx = null;
        if (this.m_parentRunner instanceof ITestContext) {
            ctx = (ITestContext)((Object)this.m_parentRunner);
        }
        TestResult tr = TestResult.newContextAwareTestResult(tm, ctx);
        InvokedMethod im = new InvokedMethod(tr.getStartMillis(), tr);
        if (tr.getMethod() instanceof IInvocationStatus) {
            ((IInvocationStatus)((Object)tr.getMethod())).setInvokedAt(im.getDate());
        }
        for (IInvokedMethodListener l : this.m_invokeListeners) {
            l.beforeInvocation(im, tr);
        }
        return tr;
    }

    private static boolean isAssumptionFailed(Failure failure) {
        Throwable exception = failure.getException();
        if (exception == null) {
            return false;
        }
        return "org.junit.internal.AssumptionViolatedException".equals(exception.getClass().getCanonicalName());
    }

    private class RL
    extends RunListener {
        private List<Description> notified = new LinkedList<Description>();

        private RL() {
        }

        public void testAssumptionFailure(Failure failure) {
            this.notified.add(failure.getDescription());
            ITestResult tr = JUnit4TestRunner.this.m_foundMethods.get(failure.getDescription());
            this.validate(tr, failure.getDescription());
            this.runAfterInvocationListeners(tr);
            tr.setStatus(3);
            tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
            tr.setThrowable(failure.getException());
            JUnit4TestRunner.this.m_parentRunner.addSkippedTest(tr.getMethod(), tr);
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestSkipped(tr);
            }
            JUnit4TestRunner.this.m_exitCodeListener.onTestSkipped(tr);
        }

        public void testFailure(Failure failure) throws Exception {
            if (failure == null) {
                return;
            }
            if (JUnit4TestRunner.isAssumptionFailed(failure)) {
                this.testAssumptionFailure(failure);
                return;
            }
            this.notified.add(failure.getDescription());
            ITestResult tr = JUnit4TestRunner.this.m_foundMethods.get(failure.getDescription());
            if (tr == null) {
                tr = JUnit4TestRunner.this.createTestResult(JUnit4TestRunner.this.objectFactory, failure.getDescription());
                this.runAfterInvocationListeners(tr);
                tr.setStatus(2);
                tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
                tr.setThrowable(failure.getException());
                for (IConfigurationListener l : JUnit4TestRunner.this.m_parentRunner.getConfigurationListeners()) {
                    l.onConfigurationFailure(tr);
                }
                for (Description childDesc : failure.getDescription().getChildren()) {
                    this.testIgnored(childDesc);
                }
            } else {
                this.runAfterInvocationListeners(tr);
                tr.setStatus(2);
                tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
                tr.setThrowable(failure.getException());
                JUnit4TestRunner.this.m_parentRunner.addFailedTest(tr.getMethod(), tr);
                for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                    l.onTestFailure(tr);
                }
                JUnit4TestRunner.this.m_exitCodeListener.onTestFailure(tr);
            }
        }

        public void testFinished(Description description) throws Exception {
            ITestResult tr = JUnit4TestRunner.this.m_foundMethods.get(description);
            this.validate(tr, description);
            this.runAfterInvocationListeners(tr);
            if (!this.notified.contains(description)) {
                tr.setStatus(1);
                tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
                JUnit4TestRunner.this.m_parentRunner.addPassedTest(tr.getMethod(), tr);
                for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                    l.onTestSuccess(tr);
                }
                JUnit4TestRunner.this.m_exitCodeListener.onTestSuccess(tr);
            }
            JUnit4TestRunner.this.m_methods.add(tr.getMethod());
        }

        public void testIgnored(Description description) throws Exception {
            if (!this.notified.contains(description)) {
                this.notified.add(description);
                ITestResult tr = JUnit4TestRunner.this.m_foundMethods.get(description);
                this.validate(tr, description);
                this.runAfterInvocationListeners(tr);
                tr.setStatus(3);
                tr.setEndMillis(tr.getStartMillis());
                JUnit4TestRunner.this.m_parentRunner.addSkippedTest(tr.getMethod(), tr);
                JUnit4TestRunner.this.m_methods.add(tr.getMethod());
                for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                    l.onTestSkipped(tr);
                }
                JUnit4TestRunner.this.m_exitCodeListener.onTestSkipped(tr);
            }
        }

        public void testRunFinished(Result result) throws Exception {
        }

        public void testRunStarted(Description description) throws Exception {
        }

        public void testStarted(Description description) throws Exception {
            ITestResult tr = JUnit4TestRunner.this.m_foundMethods.get(description);
            this.validate(tr, description);
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestStart(tr);
            }
            JUnit4TestRunner.this.m_exitCodeListener.onTestStart(tr);
        }

        private void runAfterInvocationListeners(ITestResult tr) {
            InvokedMethod im = new InvokedMethod(tr.getEndMillis(), tr);
            for (IInvokedMethodListener l : JUnit4TestRunner.this.m_invokeListeners) {
                l.afterInvocation(im, tr);
            }
        }

        private void validate(ITestResult tr, Description description) {
            if (tr == null) {
                throw new TestNGException(this.stringify(description));
            }
        }

        private String stringify(Description description) {
            return description.getClassName() + "." + description.getMethodName() + "()";
        }
    }
}

