/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import org.testng.log4testng.Logger;
import org.testng.reporters.IBuffer;
import org.testng.reporters.RuntimeBehavior;

public class FileStringBuffer
implements IBuffer {
    private static int MAX = 100000;
    private static final boolean VERBOSE = RuntimeBehavior.verboseMode();
    private static final Logger LOGGER = Logger.getLogger(FileStringBuffer.class);
    private File m_file;
    private StringBuilder m_sb = new StringBuilder();
    private final int m_maxCharacters;

    public FileStringBuffer() {
        this(MAX);
    }

    public FileStringBuffer(int maxCharacters) {
        this.m_maxCharacters = maxCharacters;
    }

    @Override
    public FileStringBuffer append(CharSequence s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("CharSequence (Argument 0 of FileStringBuffer#append) should not be null");
        }
        if (this.m_sb.length() > this.m_maxCharacters) {
            this.flushToFile();
        }
        if (s2.length() < MAX) {
            this.m_sb.append(s2);
        } else {
            this.flushToFile();
            try (FileWriter writer = new FileWriter(this.m_file, true);){
                FileStringBuffer.copy(new StringReader(s2.toString()), writer);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public void toWriter(Writer fw) {
        block9: {
            if (fw == null) {
                throw new IllegalArgumentException("Writer (Argument 0 of FileStringBuffer#toWriter) should not be null");
            }
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                if (this.m_file == null) {
                    bw.write(this.m_sb.toString());
                    bw.close();
                    break block9;
                }
                this.flushToFile();
                try (FileReader reader = new FileReader(this.m_file);){
                    FileStringBuffer.copy(reader, bw);
                }
                bw.flush();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    private static void copy(Reader input, Writer output) throws IOException {
        int length;
        char[] buf = new char[MAX];
        while ((length = input.read(buf)) >= 0) {
            output.write(buf, 0, length);
        }
    }

    private void flushToFile() {
        if (this.m_sb.length() == 0) {
            return;
        }
        if (this.m_file == null) {
            try {
                this.m_file = File.createTempFile("testng", "fileStringBuffer");
                this.m_file.deleteOnExit();
                FileStringBuffer.p("Created temp file " + this.m_file);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        FileStringBuffer.p("Size " + this.m_sb.length() + ", flushing to " + this.m_file);
        try (FileWriter fw = new FileWriter(this.m_file, true);){
            fw.append(this.m_sb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_sb = new StringBuilder();
    }

    private static void p(String s2) {
        if (VERBOSE) {
            LOGGER.info("[FileStringBuffer] " + s2);
        }
    }

    public String toString() {
        String result = null;
        if (this.m_file != null) {
            this.flushToFile();
            try {
                result = new String(Files.readAllBytes(this.m_file.toPath()));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        } else {
            result = this.m_sb.toString();
        }
        return result;
    }
}

