/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.Syntax;
import org.apache.sis.internal.metadata.sql.TypeMapper;
import org.apache.sis.util.CharSequences;

public class SQLBuilder
extends Syntax {
    public static final String SELECT = "SELECT ";
    protected final StringBuilder buffer = new StringBuilder(200);

    public SQLBuilder(DatabaseMetaData metadata, boolean quoteSchema) throws SQLException {
        super(metadata, quoteSchema);
    }

    public SQLBuilder(Syntax other) {
        super(other);
    }

    public final boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public final SQLBuilder clear() {
        this.buffer.setLength(0);
        return this;
    }

    public final SQLBuilder append(int n) {
        this.buffer.append(n);
        return this;
    }

    public final SQLBuilder append(long n) {
        this.buffer.append(n);
        return this;
    }

    public final SQLBuilder append(char c) {
        this.buffer.append(c);
        return this;
    }

    public final SQLBuilder append(String keyword) {
        this.buffer.append(keyword);
        return this;
    }

    public final SQLBuilder appendIdentifier(String identifier) {
        this.buffer.append(this.quote).append(identifier).append(this.quote);
        return this;
    }

    public final SQLBuilder appendIdentifier(String schema, String identifier) {
        if (schema != null && !schema.isEmpty()) {
            if (this.quoteSchema) {
                this.appendIdentifier(schema);
            } else {
                this.buffer.append(schema);
            }
            this.buffer.append('.');
        }
        return this.appendIdentifier(identifier);
    }

    public final SQLBuilder appendIdentifier(String catalog, String schema, String identifier) {
        if (catalog != null && !catalog.isEmpty()) {
            this.appendIdentifier(catalog);
            this.buffer.append('.');
            if (schema == null) {
                this.buffer.append(this.quote).append(this.quote).append('.');
            }
        }
        return this.appendIdentifier(schema, identifier);
    }

    public final SQLBuilder appendEqualsValue(Object value) {
        if (value == null) {
            this.buffer.append(" IS NULL");
            return this;
        }
        this.buffer.append('=');
        return this.appendValue(value);
    }

    public final SQLBuilder appendValue(String value) {
        if (value == null) {
            this.buffer.append("NULL");
        } else {
            this.buffer.append('\'').append(value.replace("'", "''")).append('\'');
        }
        return this;
    }

    public final SQLBuilder appendValue(Object value) {
        if (value instanceof Number) {
            this.buffer.append(value);
        } else if (value instanceof Boolean) {
            this.buffer.append((Boolean)value != false ? "TRUE" : "FALSE");
        } else {
            return this.appendValue(value != null ? value.toString() : (String)null);
        }
        return this;
    }

    public final SQLBuilder appendWildcardEscaped(String value) {
        StringTokenizer tokens = new StringTokenizer(value, "_%", true);
        while (tokens.hasMoreTokens()) {
            this.buffer.append(tokens.nextToken());
            if (!tokens.hasMoreTokens()) break;
            this.buffer.append(this.escape).append(tokens.nextToken());
        }
        return this;
    }

    public final SQLBuilder appendFetchPage(long offset, long count) {
        if (offset > 0L) {
            this.buffer.append(" OFFSET ").append(offset).append(" ROW");
            if (offset > 1L) {
                this.buffer.append('S');
            }
        }
        if (count > 0L) {
            this.buffer.append(" FETCH ").append(offset <= 0L ? "FIRST" : "NEXT").append(' ').append(count).append(" ROW");
            if (count > 1L) {
                this.buffer.append('S');
            }
            this.buffer.append(" ONLY");
        }
        return this;
    }

    public final SQLBuilder insertDistinctAfterSelect() {
        assert (CharSequences.startsWith(this.buffer, SELECT, false)) : this.buffer;
        this.buffer.insert(SELECT.length(), "DISTINCT ");
        return this;
    }

    public final String createColumn(String schema, String table, String column, Class<?> type, int maxLength) {
        this.clear().append("ALTER TABLE ").appendIdentifier(schema, table).append(" ADD COLUMN ").appendIdentifier(column).append(' ');
        String sqlType = TypeMapper.keywordFor(type);
        if (sqlType != null) {
            this.append(sqlType);
        } else {
            this.append("VARCHAR(").append(maxLength).append(')');
        }
        return this.toString();
    }

    public final String createForeignKey(String schema, String table, String column, String target, String primaryKey, boolean cascade) {
        if (this.dialect == Dialect.DERBY) {
            cascade = false;
        }
        this.buffer.setLength(0);
        String name = this.buffer.append(table).append('_').append(column).append("_fkey").toString();
        return this.clear().append("ALTER TABLE ").appendIdentifier(schema, table).append(" ADD CONSTRAINT ").appendIdentifier(name).append(" FOREIGN KEY(").appendIdentifier(column).append(") REFERENCES ").appendIdentifier(schema, target).append(" (").appendIdentifier(primaryKey).append(") ON UPDATE ").append(cascade ? "CASCADE" : "RESTRICT").append(" ON DELETE RESTRICT").toString();
    }

    public final String toString() {
        return this.buffer.toString();
    }
}

