/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.apache.sis.internal.jaxb.TypeRegistration;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformedEvent;

abstract class Transformer {
    private static final char TARGET_PREFIX = '*';
    private static final char RENAME_SEPARATOR = '/';
    private static final char EXTENDS = ':';
    static final char NO_NAMESPACE = '!';
    final TransformVersion version;
    private final List<QName> outerElements;
    private Map<String, String> outerElementProperties;
    final List<Attribute> renamedAttributes;
    private final Map<String, String> namespaces;

    Transformer(TransformVersion version) {
        this.version = version;
        this.namespaces = new HashMap<String, String>();
        this.outerElements = new ArrayList<QName>();
        this.renamedAttributes = new ArrayList<Attribute>();
        this.outerElementProperties = Map.of();
    }

    static String removeTrailingSlash(String uri) {
        int end = uri.length() - 1;
        if (uri.charAt(end) == '/') {
            uri = uri.substring(0, end);
        }
        return uri;
    }

    static boolean isNamespace(String candidate) {
        return candidate.length() > 4 && candidate.charAt(4) == ':';
    }

    static Map<String, Map<String, String>> load(boolean export, String filename, Set<String> targets, int capacity) {
        HashMap<String, Map<String, String>> m = new HashMap<String, Map<String, String>>(capacity);
        LinkedHashSet renameLoaders = new LinkedHashSet(8);
        renameLoaders.add(Transformer.class);
        TypeRegistration.getRenameFileLoader(export, renameLoaders);
        for (Class clazz : renameLoaders) {
            try (LineNumberReader in = new LineNumberReader(new InputStreamReader(clazz.getResourceAsStream(filename), "UTF-8"));){
                String line;
                Map<String, String> attributes = null;
                String namespace = null;
                block13: while ((line = in.readLine()) != null) {
                    char firstChar;
                    int length = line.length();
                    int indentation = CharSequences.skipLeadingWhitespaces(line, 0, length);
                    if (indentation >= length || (firstChar = line.charAt(indentation)) == '#') continue;
                    if (firstChar == '*') {
                        targets.add(CharSequences.trimWhitespaces(line, indentation + 1, line.length()).toString());
                        continue;
                    }
                    String element = line.substring(indentation).trim();
                    switch (indentation) {
                        case 0: {
                            if (!Transformer.isNamespace(element)) break;
                            namespace = element.intern();
                            attributes = null;
                            continue block13;
                        }
                        case 1: {
                            int s;
                            if (namespace == null) break;
                            int noNS = element.indexOf(33);
                            if (noNS >= 0) {
                                element = CharSequences.trimWhitespaces(element, 0, noNS).toString();
                            }
                            if ((s = element.indexOf(58)) >= 0) {
                                String parent = CharSequences.trimWhitespaces(element, s + 1, element.length()).toString();
                                element = CharSequences.trimWhitespaces(element, 0, s).toString().intern();
                                attributes = (Map)m.get(parent);
                                if (attributes == null) break;
                                attributes = new HashMap<String, String>(attributes);
                                attributes.remove(parent);
                                if (m.put(element, attributes) != null) {
                                    break;
                                }
                            } else {
                                s = element.indexOf(47);
                                String alias = null;
                                if (s >= 0) {
                                    alias = element.substring(s + 1).trim().intern();
                                    if (!Transformer.isTypeElement(element = element.substring(0, s).trim())) break;
                                }
                                element = element.intern();
                                attributes = m.computeIfAbsent(element, k -> new HashMap());
                                if (alias != null) {
                                    if (attributes.put(element, alias) != null) break;
                                    element = alias;
                                }
                            }
                            if (Transformer.isTypeElement(element) && (noNS >= 0 || attributes.put(element, namespace) == null)) continue block13;
                            break;
                        }
                        case 2: {
                            if (attributes == null || namespace == null) break;
                            int s = element.indexOf(47);
                            if (s >= 0) {
                                String old = element.substring(0, s).trim().intern();
                                element = element.substring(s + 1).trim().intern();
                                if (Transformer.isTypeElement(old) || attributes.put(old, element) != null) {
                                    break;
                                }
                            } else {
                                element = element.intern();
                            }
                            if (!Transformer.isTypeElement(element) && attributes.put(element, namespace) == null) continue block13;
                            break;
                        }
                    }
                    throw new InvalidPropertiesFormatException(Errors.format((short)33, filename, in.getLineNumber()));
                }
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        m.replaceAll((k, v) -> Map.copyOf(v));
        return m;
    }

    final void notify(Namespace namespace) {
        this.namespaces.put(namespace.getPrefix(), namespace.getNamespaceURI());
    }

    final List<Attribute> attributes() {
        List<Attribute> attributes;
        switch (this.renamedAttributes.size()) {
            case 0: {
                attributes = List.of();
                break;
            }
            case 1: {
                attributes = List.of(this.renamedAttributes.remove(0));
                break;
            }
            default: {
                attributes = Arrays.asList((Attribute[])this.renamedAttributes.toArray(Attribute[]::new));
                this.renamedAttributes.clear();
            }
        }
        return attributes;
    }

    final Attribute convert(Attribute attribute) throws XMLStreamException {
        QName originalName = attribute.getName();
        if ("type".equals(originalName.getLocalPart()) && "http://www.w3.org/2001/XMLSchema-instance".equals(originalName.getNamespaceURI())) {
            String prefix;
            String namespace;
            int s;
            String value = attribute.getValue();
            if (value != null && (s = value.indexOf(58)) >= 0 && (namespace = this.namespaces.get(prefix = value.substring(0, s).trim())) != null) {
                String localPart = value.substring(s + 1).trim();
                QName name = new QName(namespace, localPart, prefix);
                Map<String, String> currentMap = this.outerElementProperties;
                this.outerElementProperties = this.renamingMap(namespace).getOrDefault(localPart, Map.of());
                boolean changed = name != (name = this.convert(name));
                this.outerElementProperties = currentMap;
                if (changed) {
                    prefix = name.getPrefix();
                    localPart = name.getLocalPart();
                    namespace = name.getNamespaceURI();
                    TransformedEvent.Type rt = new TransformedEvent.Type(attribute, originalName, prefix + ":" + localPart);
                    if (!namespace.equals(this.namespaces.get(prefix))) {
                        rt.namespace = new TransformedEvent.NS(attribute, prefix, namespace);
                    }
                    return rt;
                }
            }
        } else {
            QName name = this.convert(originalName);
            if (name != originalName) {
                attribute = new TransformedEvent.Attr(attribute, name);
            }
        }
        return attribute;
    }

    private static boolean isTypeElement(String localPart) {
        if (localPart.length() < 4) {
            return false;
        }
        char c = localPart.charAt(0);
        return c >= 'A' && c <= 'Z' && (localPart.charAt(2) == '_' || !CharSequences.isUpperCase(localPart));
    }

    final void open(QName name) {
        String localPart = name.getLocalPart();
        if (Transformer.isTypeElement(localPart)) {
            this.outerElements.add(name);
            this.outerElementProperties = this.renamingMap(name.getNamespaceURI()).getOrDefault(localPart, Map.of());
        }
    }

    final void close(QName name) {
        if (Transformer.isTypeElement(name.getLocalPart())) {
            this.outerElementProperties = null;
            int i = this.outerElements.size();
            while (--i >= 0) {
                String localPart;
                String namespace;
                if (!name.equals(this.outerElements.get(i))) continue;
                this.outerElements.remove(i);
                if (--i >= 0) {
                    QName parent = this.outerElements.get(i);
                    namespace = parent.getNamespaceURI();
                    localPart = parent.getLocalPart();
                } else {
                    namespace = "";
                    localPart = null;
                }
                this.outerElementProperties = this.renamingMap(namespace).getOrDefault(localPart, Map.of());
                break;
            }
        }
    }

    public void close() throws XMLStreamException {
        this.outerElementProperties = null;
        this.outerElements.clear();
    }

    final QName convert(QName name) throws XMLStreamException {
        String localPart = name.getLocalPart();
        String namespace = this.outerElementProperties.get(localPart);
        if (namespace != null && !Transformer.isNamespace(namespace)) {
            localPart = namespace;
            namespace = this.outerElementProperties.get(localPart);
        }
        String oldNS = name.getNamespaceURI();
        if (namespace == null) {
            namespace = this.relocate(oldNS);
        }
        if (!namespace.equals(oldNS) || !localPart.equals(name.getLocalPart())) {
            name = new QName(namespace, localPart, this.prefixReplacement(name.getPrefix(), namespace));
        }
        return name;
    }

    abstract Map<String, Map<String, String>> renamingMap(String var1);

    abstract String relocate(String var1);

    abstract String prefixReplacement(String var1, String var2) throws XMLStreamException;
}

