/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.coverage.grid.GridGeometry;
import org.geotoolkit.gml.xml.v311.AbstractGeometryType;
import org.geotoolkit.gml.xml.v311.GridLimitsType;
import org.geotoolkit.gml.xml.v311.RectifiedGridType;
import org.opengis.coverage.grid.Grid;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.cs.CoordinateSystem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GridType", propOrder={"limits", "axisName"})
@XmlSeeAlso(value={RectifiedGridType.class})
public class GridType
extends AbstractGeometryType {
    @XmlElement(required=true)
    private GridLimitsType limits;
    @XmlElement(required=true)
    private List<String> axisName;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="positiveInteger")
    private Integer dimension;

    GridType() {
    }

    public GridType(GridLimitsType limits, List<String> axisName) {
        this.axisName = axisName;
        if (axisName != null) {
            this.dimension = axisName.size();
        }
        this.limits = limits;
    }

    public GridType(Grid grid) {
        if (grid != null) {
            this.axisName = grid.getAxisNames();
            this.dimension = grid.getDimension();
            this.limits = new GridLimitsType(grid.getExtent());
        }
    }

    public GridType(GridGeometry gg) {
        if (gg != null) {
            this.dimension = gg.getDimension();
            this.limits = new GridLimitsType((GridEnvelope)gg.getExtent());
            if (gg.isDefined(1)) {
                CoordinateSystem cs = gg.getCoordinateReferenceSystem().getCoordinateSystem();
                this.axisName = new ArrayList<String>();
                for (int i = 0; i < cs.getDimension(); ++i) {
                    this.axisName.add(cs.getAxis(i).getAbbreviation());
                }
            }
        }
    }

    public GridLimitsType getLimits() {
        return this.limits;
    }

    public void setLimits(GridLimitsType limits) {
        this.limits = limits;
    }

    public List<String> getAxisName() {
        if (this.axisName == null) {
            this.axisName = new ArrayList<String>();
        }
        return this.axisName;
    }

    public void setAxisName(List<String> axisName) {
        this.axisName = axisName;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }
}

