/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.internal.referencing.AnnotatedMatrix;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.referencing.provider.DatumShiftMethod;
import org.apache.sis.internal.referencing.provider.GeocentricAffine;
import org.apache.sis.internal.referencing.provider.GeocentricToGeographic;
import org.apache.sis.internal.referencing.provider.Geographic2Dto3D;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.LooselyDefinedMethod;
import org.apache.sis.referencing.operation.MathTransformContext;
import org.apache.sis.referencing.operation.SubOperationInfo;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

public class CoordinateOperationFinder
extends CoordinateOperationRegistry {
    private final Map<Identifier, Object> identifierOfStepCRS = new HashMap<Identifier, Object>(8);
    private final Map<CRSPair, Boolean> previousSearches = new HashMap<CRSPair, Boolean>(8);
    private final boolean useCache;

    public CoordinateOperationFinder(CoordinateOperationAuthorityFactory registry, CoordinateOperationFactory factory, CoordinateOperationContext context) throws FactoryException {
        super(registry, factory, context);
        this.useCache = context == null && factory == this.factorySIS;
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        boolean oldState = this.stopAtFirst;
        this.stopAtFirst = true;
        List<CoordinateOperation> operations = this.createOperations(sourceCRS, targetCRS);
        this.stopAtFirst = oldState;
        if (!operations.isEmpty()) {
            return operations.get(0);
        }
        throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS));
    }

    @Override
    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        Datum targetDatum;
        Datum sourceDatum;
        GeneralDerivedCRS source;
        List<CoordinateOperation> authoritatives;
        CoordinateOperation op;
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        if (Utilities.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            try {
                return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem())));
            }
            catch (IllegalArgumentException | IncommensurableException e) {
                throw new FactoryException(Resources.format((short)5, new CRSPair(sourceCRS, targetCRS)), e);
            }
        }
        CRSPair key = new CRSPair(sourceCRS, targetCRS);
        if (this.useCache && this.stopAtFirst && !this.previousSearches.isEmpty() && (op = this.factorySIS.cache.peek(key)) != null) {
            return CoordinateOperationFinder.asList(op);
        }
        if (this.previousSearches.put(key, Boolean.TRUE) != null) {
            throw new FactoryException(Resources.format((short)62, CoordinateOperation.class, key));
        }
        GeographicBoundingBox bbox = Extents.getGeographicBoundingBox(this.areaOfInterest);
        if (bbox == null) {
            bbox = Extents.intersection(CRS.getGeographicBoundingBox(sourceCRS), CRS.getGeographicBoundingBox(targetCRS));
            this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, bbox);
        }
        if (this.registry != null && !(authoritatives = super.createOperations(sourceCRS, targetCRS)).isEmpty()) {
            return authoritatives;
        }
        if (sourceCRS instanceof GeneralDerivedCRS) {
            source = (GeneralDerivedCRS)sourceCRS;
            if (targetCRS instanceof GeneralDerivedCRS) {
                return this.createOperationStep(source, (GeneralDerivedCRS)targetCRS);
            }
            if (targetCRS instanceof SingleCRS) {
                return this.createOperationStep(source, (SingleCRS)targetCRS);
            }
        }
        if (targetCRS instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS target = (GeneralDerivedCRS)targetCRS;
            if (sourceCRS instanceof SingleCRS) {
                return this.createOperationStep((SingleCRS)sourceCRS, target);
            }
        }
        if (sourceCRS instanceof GeodeticCRS) {
            source = (GeodeticCRS)sourceCRS;
            if (targetCRS instanceof GeodeticCRS) {
                return this.createOperationStep((GeodeticCRS)source, (GeodeticCRS)targetCRS);
            }
            if (targetCRS instanceof VerticalCRS) {
                return this.createOperationStep((GeodeticCRS)source, (VerticalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof VerticalCRS) {
            source = (VerticalCRS)sourceCRS;
            if (targetCRS instanceof VerticalCRS) {
                return this.createOperationStep((VerticalCRS)source, (VerticalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof TemporalCRS) {
            source = (TemporalCRS)sourceCRS;
            if (targetCRS instanceof TemporalCRS) {
                return this.createOperationStep((TemporalCRS)source, (TemporalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof SingleCRS && targetCRS instanceof SingleCRS && Utilities.equalsIgnoreMetadata(sourceDatum = ((SingleCRS)sourceCRS).getDatum(), targetDatum = ((SingleCRS)targetCRS).getDatum())) {
            try {
                return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem())));
            }
            catch (IllegalArgumentException | IncommensurableException e) {
                throw new FactoryException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS), e);
            }
        }
        if (sourceCRS instanceof CompoundCRS || targetCRS instanceof CompoundCRS) {
            return this.createOperationStep(sourceCRS, CRS.getSingleComponents(sourceCRS), targetCRS, CRS.getSingleComponents(targetCRS));
        }
        throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS));
    }

    protected List<CoordinateOperation> createOperationStep(SingleCRS sourceCRS, GeneralDerivedCRS targetCRS) throws FactoryException {
        List<CoordinateOperation> operations = this.createOperations((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS.getBaseCRS());
        ListIterator<CoordinateOperation> it = operations.listIterator();
        if (it.hasNext()) {
            Conversion step2 = targetCRS.getConversionFromBase();
            do {
                CoordinateOperation step1 = it.next();
                it.set(this.concatenate(step1, (CoordinateOperation)step2));
            } while (it.hasNext());
        }
        return operations;
    }

    protected List<CoordinateOperation> createOperationStep(GeneralDerivedCRS sourceCRS, SingleCRS targetCRS) throws FactoryException {
        List<CoordinateOperation> operations = this.createOperations((CoordinateReferenceSystem)sourceCRS.getBaseCRS(), (CoordinateReferenceSystem)targetCRS);
        ListIterator<CoordinateOperation> it = operations.listIterator();
        if (it.hasNext()) {
            CoordinateOperation step1;
            try {
                step1 = this.inverse((SingleOperation)sourceCRS.getConversionFromBase());
            }
            catch (OperationNotFoundException exception) {
                throw exception;
            }
            catch (NoninvertibleTransformException | FactoryException exception) {
                throw new OperationNotFoundException(CoordinateOperationFinder.canNotInvert(sourceCRS), exception);
            }
            do {
                CoordinateOperation step2 = it.next();
                it.set(this.concatenate(step1, step2));
            } while (it.hasNext());
        }
        return operations;
    }

    protected List<CoordinateOperation> createOperationStep(GeneralDerivedCRS sourceCRS, GeneralDerivedCRS targetCRS) throws FactoryException {
        List<CoordinateOperation> operations = this.createOperations((CoordinateReferenceSystem)sourceCRS.getBaseCRS(), (CoordinateReferenceSystem)targetCRS.getBaseCRS());
        ListIterator<CoordinateOperation> it = operations.listIterator();
        if (it.hasNext()) {
            CoordinateOperation step1;
            Conversion step3 = targetCRS.getConversionFromBase();
            try {
                step1 = this.inverse((SingleOperation)sourceCRS.getConversionFromBase());
            }
            catch (OperationNotFoundException exception) {
                throw exception;
            }
            catch (NoninvertibleTransformException | FactoryException exception) {
                throw new OperationNotFoundException(CoordinateOperationFinder.canNotInvert(sourceCRS), exception);
            }
            do {
                CoordinateOperation step2 = it.next();
                it.set(this.concatenate(step1, step2, (CoordinateOperation)step3));
            } while (it.hasNext());
        }
        return operations;
    }

    protected List<CoordinateOperation> createOperationStep(GeodeticCRS sourceCRS, GeodeticCRS targetCRS) throws FactoryException {
        ParameterValueGroup parameters;
        Identifier identifier;
        GeodeticDatum sourceDatum = sourceCRS.getDatum();
        GeodeticDatum targetDatum = targetCRS.getDatum();
        Matrix datumShift = null;
        MathTransformContext context = new MathTransformContext(sourceDatum, targetDatum);
        context.setSource(sourceCRS);
        context.setTarget(targetCRS);
        boolean isGeographicToGeocentric = false;
        CoordinateSystem sourceCS = context.getSourceCS();
        CoordinateSystem targetCS = context.getTargetCS();
        if (Utilities.equalsIgnoreMetadata(sourceDatum, targetDatum)) {
            boolean isGeocentricToGeographic;
            isGeographicToGeocentric = sourceCS instanceof EllipsoidalCS && targetCS instanceof CartesianCS;
            boolean bl = isGeocentricToGeographic = sourceCS instanceof CartesianCS && targetCS instanceof EllipsoidalCS;
            identifier = isGeocentricToGeographic ^ isGeographicToGeocentric ? GEOCENTRIC_CONVERSION : AXIS_CHANGES;
        } else {
            identifier = ELLIPSOID_CHANGE;
            if (sourceDatum instanceof DefaultGeodeticDatum && (datumShift = ((DefaultGeodeticDatum)sourceDatum).getPositionVectorTransformation(targetDatum, this.areaOfInterest)) != null) {
                identifier = DATUM_SHIFT;
            }
        }
        DefaultMathTransformFactory mtFactory = this.factorySIS.getDefaultMathTransformFactory();
        MathTransform before = null;
        MathTransform after = null;
        OperationMethod method = null;
        if (identifier == DATUM_SHIFT || identifier == ELLIPSOID_CHANGE) {
            parameters = GeocentricAffine.createParameters(sourceCS, targetCS, datumShift, DatumShiftMethod.forAccuracy(this.desiredAccuracy));
            if (parameters == null) {
                parameters = datumShift != null ? TensorParameters.WKT1.createValueGroup(CoordinateOperationFinder.properties("Affine"), datumShift) : Affine.identity(3);
                CoordinateSystem normalized = CommonCRS.WGS84.geocentric().getCoordinateSystem();
                before = mtFactory.createCoordinateSystemChange(sourceCS, normalized, sourceDatum.getEllipsoid());
                after = mtFactory.createCoordinateSystemChange(normalized, targetCS, targetDatum.getEllipsoid());
                context.setSource(normalized);
                context.setTarget(normalized);
                if (!before.isIdentity() || !after.isIdentity()) {
                    method = LooselyDefinedMethod.AFFINE_GEOCENTRIC;
                }
            }
        } else if (identifier == GEOCENTRIC_CONVERSION) {
            ParameterDescriptorGroup descriptor;
            GeodeticCRS geographic;
            if (isGeographicToGeocentric) {
                geographic = sourceCRS;
                descriptor = GeographicToGeocentric.PARAMETERS;
            } else {
                geographic = targetCRS;
                descriptor = GeocentricToGeographic.PARAMETERS;
            }
            parameters = descriptor.createValue();
            parameters.parameter("dim").setValue(geographic.getCoordinateSystem().getDimension());
        } else {
            int sourceDim = sourceCS.getDimension();
            int targetDim = targetCS.getDimension();
            if (sourceDim == 2 && targetDim == 3 && sourceCS instanceof EllipsoidalCS) {
                parameters = Geographic2Dto3D.PARAMETERS.createValue();
            } else if (sourceDim == 3 && targetDim == 2 && targetCS instanceof EllipsoidalCS) {
                parameters = Geographic3Dto2D.PARAMETERS.createValue();
            } else {
                parameters = Affine.identity(targetDim);
                before = mtFactory.createCoordinateSystemChange(sourceCS, targetCS, (sourceCS instanceof EllipsoidalCS ? sourceDatum : targetDatum).getEllipsoid());
                context.setSource(targetCS);
                method = mtFactory.getLastMethodUsed();
            }
        }
        MathTransform transform = mtFactory.createParameterizedTransform(parameters, context);
        if (method == null) {
            method = context.getMethodUsed();
        }
        if (before != null) {
            parameters = null;
            transform = mtFactory.createConcatenatedTransform(before, transform);
            if (after != null) {
                transform = mtFactory.createConcatenatedTransform(transform, after);
            }
        }
        Map<String, Object> properties = CoordinateOperationFinder.properties(identifier);
        if (datumShift instanceof AnnotatedMatrix) {
            properties.put("coordinateOperationAccuracy", new PositionalAccuracy[]{((AnnotatedMatrix)datumShift).accuracy});
        }
        return CoordinateOperationFinder.asList(this.createFromMathTransform(properties, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, transform, method, parameters, null));
    }

    protected List<CoordinateOperation> createOperationStep(GeodeticCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        boolean isEllipsoidalHeight;
        int i;
        EllipsoidalCS cs;
        CoordinateOperation step1 = null;
        CoordinateOperation step3 = null;
        GeodeticCRS interpolationCRS = sourceCRS;
        CoordinateSystem interpolationCS = interpolationCRS.getCoordinateSystem();
        if (!(interpolationCS instanceof EllipsoidalCS) && !Utilities.equalsIgnoreMetadata(interpolationCS, cs = CommonCRS.WGS84.geographic3D().getCoordinateSystem())) {
            GeographicCRS stepCRS = this.factorySIS.getCRSFactory().createGeographicCRS(this.derivedFrom((IdentifiedObject)sourceCRS), sourceCRS.getDatum(), cs);
            step1 = this.createOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)this.toAuthorityDefinition(GeographicCRS.class, stepCRS));
            interpolationCRS = step1.getTargetCRS();
            interpolationCS = interpolationCRS.getCoordinateSystem();
        }
        if ((i = AxisDirections.indexOfColinear(interpolationCS, AxisDirection.UP)) < 0) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS));
        }
        CoordinateSystemAxis expectedAxis = interpolationCS.getAxis(i);
        VerticalCRS heightCRS = targetCRS;
        VerticalCS heightCS = heightCRS.getCoordinateSystem();
        if (Utilities.equalsIgnoreMetadata(heightCS.getAxis(0), expectedAxis)) {
            isEllipsoidalHeight = ReferencingUtilities.isEllipsoidalHeight(heightCRS.getDatum());
        } else {
            heightCRS = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            heightCS = heightCRS.getCoordinateSystem();
            isEllipsoidalHeight = Utilities.equalsIgnoreMetadata(heightCS.getAxis(0), expectedAxis);
            if (!isEllipsoidalHeight) {
                heightCS = this.toAuthorityDefinition(VerticalCS.class, this.factorySIS.getCSFactory().createVerticalCS(this.derivedFrom((IdentifiedObject)heightCS), expectedAxis));
            }
        }
        if (!isEllipsoidalHeight) {
            heightCRS = this.toAuthorityDefinition(VerticalCRS.class, this.factorySIS.getCRSFactory().createVerticalCRS(this.derivedFrom((IdentifiedObject)heightCRS), CommonCRS.Vertical.ELLIPSOIDAL.datum(), heightCS));
        }
        if (heightCRS != targetCRS) {
            step3 = this.createOperation((CoordinateReferenceSystem)heightCRS, (CoordinateReferenceSystem)targetCRS);
            heightCRS = (VerticalCRS)step3.getSourceCRS();
            heightCS = heightCRS.getCoordinateSystem();
        }
        int srcDim = interpolationCS.getDimension();
        int tgtDim = heightCS.getDimension();
        MatrixSIS matrix = Matrices.createZero(tgtDim + 1, srcDim + 1);
        matrix.setElement(0, i, 1.0);
        matrix.setElement(tgtDim, srcDim, 1.0);
        CoordinateOperation step2 = this.createFromAffineTransform(AXIS_CHANGES, (CoordinateReferenceSystem)interpolationCRS, (CoordinateReferenceSystem)heightCRS, matrix);
        return CoordinateOperationFinder.asList(this.concatenate(step1, step2, step3));
    }

    protected List<CoordinateOperation> createOperationStep(VerticalCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        Matrix matrix;
        VerticalDatum targetDatum;
        VerticalDatum sourceDatum = sourceCRS.getDatum();
        if (!Utilities.equalsIgnoreMetadata(sourceDatum, targetDatum = targetCRS.getDatum())) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceDatum, (IdentifiedObject)targetDatum));
        }
        VerticalCS sourceCS = sourceCRS.getCoordinateSystem();
        VerticalCS targetCS = targetCRS.getCoordinateSystem();
        try {
            matrix = CoordinateSystems.swapAndScaleAxes((CoordinateSystem)sourceCS, (CoordinateSystem)targetCS);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS), exception);
        }
        return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, matrix));
    }

    protected List<CoordinateOperation> createOperationStep(TemporalCRS sourceCRS, TemporalCRS targetCRS) throws FactoryException {
        MatrixSIS matrix;
        TemporalDatum sourceDatum = sourceCRS.getDatum();
        TemporalDatum targetDatum = targetCRS.getDatum();
        TimeCS sourceCS = sourceCRS.getCoordinateSystem();
        TimeCS targetCS = targetCRS.getCoordinateSystem();
        Unit targetUnit = targetCS.getAxis(0).getUnit().asType(Time.class);
        DoubleDouble epochShift = DoubleDouble.of(sourceDatum.getOrigin().getTime());
        epochShift = epochShift.subtract(targetDatum.getOrigin().getTime());
        epochShift = DoubleDouble.of(Units.MILLISECOND.getConverterTo(targetUnit).convert((Number)epochShift), true);
        try {
            matrix = MatrixSIS.castOrCopy(CoordinateSystems.swapAndScaleAxes((CoordinateSystem)sourceCS, (CoordinateSystem)targetCS));
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS), exception);
        }
        int translationColumn = matrix.getNumCol() - 1;
        DoubleDouble translation = DoubleDouble.of(matrix.getNumber(0, translationColumn), true);
        matrix.setNumber(0, translationColumn, translation.add(epochShift));
        return CoordinateOperationFinder.asList(this.createFromAffineTransform(AXIS_CHANGES, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, matrix));
    }

    protected List<CoordinateOperation> createOperationStep(CoordinateReferenceSystem sourceCRS, List<? extends SingleCRS> sourceComponents, CoordinateReferenceSystem targetCRS, List<? extends SingleCRS> targetComponents) throws FactoryException {
        CoordinateOperation operation;
        CoordinateReferenceSystem stepSourceCRS;
        SubOperationInfo[] infos;
        try {
            infos = SubOperationInfo.createSteps(this, sourceComponents, targetComponents);
        }
        catch (TransformException e) {
            throw new FactoryException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS), (Throwable)e);
        }
        if (infos == null) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)sourceCRS, (IdentifiedObject)targetCRS));
        }
        CoordinateReferenceSystem[] stepComponents = SubOperationInfo.getSourceCRS(infos);
        MatrixSIS select = SubOperationInfo.sourceToSelected(sourceCRS.getCoordinateSystem().getDimension(), infos);
        if (select.isIdentity()) {
            stepSourceCRS = sourceCRS;
            operation = null;
        } else {
            if (stepComponents.length == 1) {
                stepSourceCRS = stepComponents[0];
            } else {
                CompoundCRS crs = this.factorySIS.getCRSFactory().createCompoundCRS(this.derivedFrom((IdentifiedObject)sourceCRS), stepComponents);
                stepSourceCRS = (CoordinateReferenceSystem)this.toAuthorityDefinition(CoordinateReferenceSystem.class, crs);
            }
            operation = this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, stepSourceCRS, select);
        }
        int endAtDimension = 0;
        int remainingSourceDimensions = select.getNumRow() - 1;
        int indexOfFinal = SubOperationInfo.indexOfFinal(infos);
        for (int i = 0; i < stepComponents.length; ++i) {
            CoordinateReferenceSystem target;
            SubOperationInfo info = infos[i];
            CoordinateReferenceSystem source = stepComponents[i];
            stepComponents[info.targetComponentIndex] = target = (CoordinateReferenceSystem)targetComponents.get(info.targetComponentIndex);
            CoordinateReferenceSystem stepTargetCRS = i >= indexOfFinal ? targetCRS : (info.isIdentity() ? stepSourceCRS : (stepComponents.length == 1 ? target : this.createCompoundCRS(target, stepComponents)));
            int delta = source.getCoordinateSystem().getDimension();
            int startAtDimension = endAtDimension;
            int numTrailingCoordinates = remainingSourceDimensions - (endAtDimension += delta);
            CoordinateOperation subOperation = info.operation;
            if ((startAtDimension | numTrailingCoordinates) != 0) {
                subOperation = new DefaultPassThroughOperation(IdentifiedObjects.getProperties((IdentifiedObject)subOperation, new String[0]), stepSourceCRS, stepTargetCRS, subOperation, startAtDimension, numTrailingCoordinates);
            }
            operation = this.concatenate(operation, subOperation);
            stepSourceCRS = stepTargetCRS;
            endAtDimension -= (delta -= target.getCoordinateSystem().getDimension());
            remainingSourceDimensions -= delta;
        }
        if (stepComponents.length < infos.length) {
            MatrixSIS m = SubOperationInfo.createConstantOperation(infos, stepComponents.length, stepSourceCRS.getCoordinateSystem().getDimension(), targetCRS.getCoordinateSystem().getDimension());
            operation = this.concatenate(operation, this.createFromAffineTransform(CONSTANTS, stepSourceCRS, targetCRS, m));
        }
        return CoordinateOperationFinder.asList(operation);
    }

    private CoordinateOperation createFromAffineTransform(Identifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Matrix matrix) throws FactoryException {
        MathTransform transform = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
        return this.createFromMathTransform(CoordinateOperationFinder.properties(name), sourceCRS, targetCRS, transform, null, null, null);
    }

    private CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem template, CoordinateReferenceSystem[] components) throws FactoryException {
        EllipsoidalHeightCombiner c = new EllipsoidalHeightCombiner(this.factorySIS.getCRSFactory(), this.factorySIS.getCSFactory(), this.factory);
        CoordinateReferenceSystem crs = c.createCompoundCRS(this.derivedFrom((IdentifiedObject)template), components);
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, crs);
    }

    private CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2) throws FactoryException {
        if (CoordinateOperationFinder.isIdentity(step1)) {
            return step2;
        }
        if (CoordinateOperationFinder.isIdentity(step2)) {
            return step1;
        }
        MathTransform mt1 = step1.getMathTransform();
        MathTransform mt2 = step2.getMathTransform();
        CoordinateReferenceSystem sourceCRS = step1.getSourceCRS();
        CoordinateReferenceSystem targetCRS = step2.getTargetCRS();
        CoordinateOperation main = null;
        boolean isAxisChange1 = CoordinateOperationFinder.canHide(step1.getName());
        boolean isAxisChange2 = CoordinateOperationFinder.canHide(step2.getName());
        if (isAxisChange1 && isAxisChange2 && CoordinateOperationFinder.isAffine(step1) && CoordinateOperationFinder.isAffine(step2)) {
            main = step2;
            if (main.getName() == IDENTITY && step1.getName() != IDENTITY) {
                main = step1;
            }
        } else {
            if (isAxisChange1 && mt1.getSourceDimensions() == mt1.getTargetDimensions()) {
                main = step2;
            }
            if (isAxisChange2 && mt2.getSourceDimensions() == mt2.getTargetDimensions()) {
                main = step1;
            }
        }
        if (main instanceof SingleOperation) {
            SingleOperation op = (SingleOperation)main;
            MathTransform mt = this.factorySIS.getMathTransformFactory().createConcatenatedTransform(mt1, mt2);
            main = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties((IdentifiedObject)main, new String[0])), sourceCRS, targetCRS, mt, op.getMethod(), op.getParameterValues(), main instanceof Transformation ? Transformation.class : (main instanceof Conversion ? Conversion.class : SingleOperation.class));
        } else {
            main = this.factory.createConcatenatedOperation(CoordinateOperationFinder.defaultName(sourceCRS, targetCRS), new CoordinateOperation[]{step1, step2});
        }
        if (main instanceof ConcatenatedOperation && main.getMathTransform().isIdentity()) {
            Class<Transformation> type = null;
            for (CoordinateOperation component : ((ConcatenatedOperation)main).getOperations()) {
                if (!(component instanceof Transformation)) continue;
                type = Transformation.class;
                break;
            }
            main = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties((IdentifiedObject)main, new String[0])), main.getSourceCRS(), main.getTargetCRS(), main.getMathTransform(), null, null, type);
        }
        return main;
    }

    private CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2, CoordinateOperation step3) throws FactoryException {
        if (CoordinateOperationFinder.isIdentity(step1)) {
            return this.concatenate(step2, step3);
        }
        if (CoordinateOperationFinder.isIdentity(step2)) {
            return this.concatenate(step1, step3);
        }
        if (CoordinateOperationFinder.isIdentity(step3)) {
            return this.concatenate(step1, step2);
        }
        if (CoordinateOperationFinder.canHide(step1.getName())) {
            return this.concatenate(this.concatenate(step1, step2), step3);
        }
        if (CoordinateOperationFinder.canHide(step3.getName())) {
            return this.concatenate(step1, this.concatenate(step2, step3));
        }
        Map<String, ?> properties = CoordinateOperationFinder.defaultName(step1.getSourceCRS(), step3.getTargetCRS());
        return this.factory.createConcatenatedOperation(properties, new CoordinateOperation[]{step1, step2, step3});
    }

    private static boolean isAffine(CoordinateOperation operation) {
        return operation instanceof SingleOperation && IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)((SingleOperation)operation).getMethod(), "Affine");
    }

    private static boolean isIdentity(CoordinateOperation operation) {
        if (operation == null) {
            return true;
        }
        if (operation instanceof Conversion && operation.getMathTransform().isIdentity()) {
            return CoordinateOperations.wrapAroundChanges(operation).isEmpty();
        }
        return false;
    }

    private static boolean canHide(Identifier id) {
        return id == AXIS_CHANGES || id == IDENTITY;
    }

    private static Map<String, ?> properties(String name) {
        return Map.of("name", name);
    }

    private Map<String, ?> derivedFrom(IdentifiedObject object) {
        Identifier oldID = object.getName();
        Object p = this.identifierOfStepCRS.get(oldID);
        if (p instanceof Identifier) {
            oldID = (Identifier)p;
            p = this.identifierOfStepCRS.get(oldID);
        }
        int count = p != null ? (Integer)p + 1 : 1;
        NamedIdentifier newID = new NamedIdentifier(Citations.SIS, oldID.getCode() + " (step " + count + ")");
        this.identifierOfStepCRS.put(newID, oldID);
        this.identifierOfStepCRS.put(oldID, count);
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>(4);
        properties.put("name", newID);
        properties.put("remarks", (NamedIdentifier)Vocabulary.formatInternational((short)58, (Object)CRSPair.label(object)));
        return properties;
    }

    private static Map<String, ?> defaultName(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        return CoordinateOperationFinder.properties(new CRSPair(source, target).toString());
    }

    private static List<CoordinateOperation> asList(CoordinateOperation operation) {
        ArrayList<CoordinateOperation> operations = new ArrayList<CoordinateOperation>(1);
        operations.add(operation);
        return operations;
    }

    private static String notFoundMessage(IdentifiedObject source, IdentifiedObject target) {
        return Resources.format((short)13, CRSPair.label(source), CRSPair.label(target));
    }

    private static String canNotInvert(GeneralDerivedCRS crs) {
        return Resources.format((short)52, crs.getConversionFromBase().getName().getCode());
    }
}

